/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.microsoftdynamics365.internal.connection.util;

import java.net.URI;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.ssl.SSLContexts;
import org.apache.olingo.client.core.http.AbstractHttpClientFactory;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.mule.extension.microsoftdynamics365.internal.params.OAuthAdvancedParams;
import org.mule.extension.microsoftdynamics365.internal.params.ProxySettingsParams;

public class DynamicsHttpClientFactory
extends AbstractHttpClientFactory {
    private RequestConfig reqConfig;
    private ProxySettingsParams proxyDetails;
    private static final String HTTP_PROXY_PORT = "http.proxyPort";
    private static final String HTTP_PROXY_HOST = "http.proxyHost";

    public DynamicsHttpClientFactory(OAuthAdvancedParams oAuthAdvancedParams, ProxySettingsParams proxyDetails) {
        this.reqConfig = RequestConfig.custom().setConnectTimeout(oAuthAdvancedParams.getConnectionTimeout().intValue()).setSocketTimeout(oAuthAdvancedParams.getReadTimeout().intValue()).build();
        this.proxyDetails = proxyDetails;
    }

    public HttpClient create(HttpMethod method, URI uri) {
        Properties properties;
        String httpProtocolsListAsString;
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setUserAgent(USER_AGENT);
        if (this.reqConfig != null) {
            httpClientBuilder.setDefaultRequestConfig(this.reqConfig);
        }
        if (this.proxyDetails != null && StringUtils.isNotBlank((String)this.proxyDetails.getProxyHost())) {
            String proxyHost = this.proxyDetails.getProxyHost();
            int proxyPort = this.proxyDetails.getProxyPort();
            String username = this.proxyDetails.getProxyUsername();
            String password = this.proxyDetails.getProxyPassword();
            httpClientBuilder.setProxy(new HttpHost(proxyHost, proxyPort));
            if (StringUtils.isNotBlank((String)username) && StringUtils.isNotBlank((String)password)) {
                HttpHost proxy = new HttpHost(proxyHost, proxyPort);
                DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
                httpClientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new UsernamePasswordCredentials(username, password));
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
        }
        if ((httpProtocolsListAsString = System.getProperty("https.protocols")) != null) {
            String[] httpProtocols = httpProtocolsListAsString.split(",");
            SSLContext sslContext = SSLContexts.createDefault();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, httpProtocols, null, (HostnameVerifier)new NoopHostnameVerifier());
            httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
        }
        if ((properties = System.getProperties()).getProperty(HTTP_PROXY_PORT) != null && properties.getProperty(HTTP_PROXY_HOST) != null) {
            httpClientBuilder.setProxy(new HttpHost(properties.getProperty(HTTP_PROXY_HOST), Integer.parseInt(properties.getProperty(HTTP_PROXY_PORT))));
        }
        return httpClientBuilder.build();
    }

    public void close(HttpClient httpClient) {
    }

    public RequestConfig getReqConfig() {
        return this.reqConfig;
    }
}

