/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.microsoftdynamics365.internal.connection.provider;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.mule.extension.microsoftdynamics365.internal.connection.Dynamics365Connection;
import org.mule.extension.microsoftdynamics365.internal.connection.Dynamics365UsernamePasswordConnection;
import org.mule.extension.microsoftdynamics365.internal.connection.provider.Dynamics365ConnectionProvider;
import org.mule.extension.microsoftdynamics365.internal.connection.util.DynamicsHttpClientFactory;
import org.mule.extension.microsoftdynamics365.internal.connection.util.OAuthRequest;
import org.mule.extension.microsoftdynamics365.internal.params.OAuthUserPassParams;
import org.mule.extension.microsoftdynamics365.internal.utils.URIUtils;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.sdk.api.annotation.semantics.connectivity.BasicAuth;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="oauth-user-pass")
@DisplayName(value="OAuth Username Password")
@BasicAuth
public class OAuthUsernamePasswordConnectionProvider
extends Dynamics365ConnectionProvider {
    private static final Logger logger = LoggerFactory.getLogger(OAuthUsernamePasswordConnectionProvider.class);
    @ParameterGroup(name="Connection")
    @Placement(order=1)
    private OAuthUserPassParams oAuthUserPassParams;

    public Dynamics365Connection connect() throws ConnectionException {
        try {
            DynamicsHttpClientFactory httpClientFactory = new DynamicsHttpClientFactory(this.getoAuthAdvancedParams(), this.getProxySettingsParams());
            OAuthRequest request = new OAuthRequest();
            request.setClientId(this.oAuthUserPassParams.getClientId());
            request.setClientSecret(this.oAuthUserPassParams.getClientSecret());
            request.setUsername(this.oAuthUserPassParams.getUsername());
            request.setPassword(this.oAuthUserPassParams.getPassword());
            request.setTokenEndpoint(this.oAuthUserPassParams.getTokenRequestEndpoint());
            request.setResource(this.oAuthUserPassParams.getResource());
            HttpPost tokenRequest = new HttpPost(URIUtils.getURI(request.getTokenEndpoint()));
            tokenRequest.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
            LinkedList<BasicNameValuePair> postParams = new LinkedList<BasicNameValuePair>();
            if (StringUtils.isNotBlank((String)request.getUsername()) && StringUtils.isNotBlank((String)request.getPassword())) {
                postParams.add(new BasicNameValuePair("username", request.getUsername()));
                postParams.add(new BasicNameValuePair("password", request.getPassword()));
            }
            postParams.add(new BasicNameValuePair("client_id", request.getClientId()));
            postParams.add(new BasicNameValuePair("resource", request.getResource()));
            postParams.add(new BasicNameValuePair("grant_type", "password"));
            if (StringUtils.isNotBlank((String)request.getClientSecret())) {
                postParams.add(new BasicNameValuePair("client_secret", request.getClientSecret()));
            }
            tokenRequest.setEntity((HttpEntity)new UrlEncodedFormEntity(postParams));
            HttpResponse response = httpClientFactory.create(null, null).execute((HttpUriRequest)tokenRequest);
            HttpEntity httpEntity = response.getEntity();
            if (httpEntity == null) {
                throw new ConnectionException("Unable to get login response");
            }
            InputStream responseStream = httpEntity.getContent();
            Map responseAsMap = (Map)new ObjectMapper().readValue(responseStream, HashMap.class);
            if (responseAsMap.containsKey("error")) {
                throw new ConnectionException("Failed establishing connection with Dynamics 365 API");
            }
            logger.info("Connection established!");
            return new Dynamics365UsernamePasswordConnection(request.getResource(), this.getVersion(), httpClientFactory, responseAsMap);
        }
        catch (IOException e) {
            throw new ConnectionException((Throwable)e);
        }
    }

    public void setOAuthUserPassParams(OAuthUserPassParams oAuthUserPassParams) {
        this.oAuthUserPassParams = oAuthUserPassParams;
    }
}

