/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.microsoftdynamics365.internal.connection.provider;

import java.text.MessageFormat;
import org.mule.extension.microsoftdynamics365.internal.connection.Dynamics365ClientCredentialsConnection;
import org.mule.extension.microsoftdynamics365.internal.connection.Dynamics365Connection;
import org.mule.extension.microsoftdynamics365.internal.connection.provider.Dynamics365ConnectionProvider;
import org.mule.extension.microsoftdynamics365.internal.connection.util.DynamicsHttpClientFactory;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.connectivity.oauth.ClientCredentials;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsState;
import org.mule.runtime.extension.api.security.CredentialsPlacement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="oauth-client-credentials")
@DisplayName(value="OAuth Client Credentials")
@ClientCredentials(tokenUrl="https://login.microsoftonline.com/{tenant}/oauth2/v2.0/token", credentialsPlacement=CredentialsPlacement.BODY)
public class ClientCredentialsConnectionProvider
extends Dynamics365ConnectionProvider {
    private static final Logger logger = LoggerFactory.getLogger(ClientCredentialsConnectionProvider.class);
    private static final String COULD_NOT_EXTRACT_FIELD = "Could not extract field {0}";
    @Summary(value="The App ID URI of the web API")
    @Example(value="https://{mydomain}.crm.dynamics.com")
    @Parameter
    private String endpoint;
    private ClientCredentialsState state;

    public Dynamics365Connection connect() throws ConnectionException {
        if (this.state.getAccessToken() == null) {
            throw new ConnectionException(MessageFormat.format(COULD_NOT_EXTRACT_FIELD, "accessToken"));
        }
        logger.info("Connection established!");
        return new Dynamics365ClientCredentialsConnection(this.endpoint, this.getVersion(), new DynamicsHttpClientFactory(this.getoAuthAdvancedParams(), this.getProxySettingsParams()), this.state);
    }
}

