/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.microsoftdynamics365.internal.connection.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.extension.microsoftdynamics365.internal.connection.dto.DynamicsBulkBuilder;
import org.mule.extension.microsoftdynamics365.internal.connection.dto.DynamicsBulkItem;

public final class DynamicsBulkResult<T>
implements Serializable {
    private static final long serialVersionUID = 8039267004891928585L;
    private final Serializable id;
    private final boolean successful;
    private final List<DynamicsBulkItem<T>> items;
    private final Map<String, Serializable> customProperties;

    private DynamicsBulkResult(Serializable id, boolean successful, List<DynamicsBulkItem<T>> items, Map<String, Serializable> customProperties) {
        this.id = id;
        this.successful = successful;
        this.items = items;
        this.customProperties = customProperties != null ? new HashMap<String, Serializable>(customProperties) : null;
    }

    public Serializable getId() {
        return this.id;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public List<DynamicsBulkItem<T>> getItems() {
        return this.items;
    }

    public Serializable getCustomProperty(String key) {
        return this.customProperties != null ? this.customProperties.get(key) : null;
    }

    public static <T> BulkOperationResultBuilder<T> builder() {
        return new BulkOperationResultBuilder();
    }

    public static class BulkOperationResultBuilder<T>
    extends DynamicsBulkBuilder {
        private Serializable id;
        private boolean successful = true;
        private List<DynamicsBulkItem.BulkItemBuilder<T>> items = new ArrayList<DynamicsBulkItem.BulkItemBuilder<T>>();

        private BulkOperationResultBuilder() {
        }

        public BulkOperationResultBuilder<T> setSuccessful(boolean successful) {
            this.successful = successful;
            return this;
        }

        public BulkOperationResultBuilder<T> setId(Serializable id) {
            this.id = id;
            return this;
        }

        public BulkOperationResultBuilder<T> addItem(DynamicsBulkItem.BulkItemBuilder<T> recordResultBuilder) {
            this.items.add(recordResultBuilder);
            return this;
        }

        public BulkOperationResultBuilder<T> addCustomProperty(String key, Serializable value) {
            this.customProperty(key, value);
            return this;
        }

        public DynamicsBulkResult<T> build() {
            if (this.items.isEmpty()) {
                throw new IllegalStateException("A BulkOperationResult must have at least one BulkItem. Please add a result an try again");
            }
            ArrayList<DynamicsBulkItem<T>> listItems = new ArrayList<DynamicsBulkItem<T>>(this.items.size());
            for (DynamicsBulkItem.BulkItemBuilder<T> recordBuilder : this.items) {
                DynamicsBulkItem<T> record = recordBuilder.build();
                listItems.add(record);
                if (record.isSuccessful()) continue;
                this.successful = false;
            }
            return new DynamicsBulkResult(this.id, this.successful, listItems, this.getCustomProperties());
        }
    }
}

