/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.microsoftdynamics365.internal.connection.client;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.http.HttpResponse;
import org.apache.olingo.client.api.Configuration;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.batch.BatchRequestFactory;
import org.apache.olingo.client.api.communication.request.batch.ODataBatchRequest;
import org.apache.olingo.client.api.http.HttpClientFactory;
import org.apache.olingo.client.core.communication.request.batch.BatchRequestFactoryImpl;
import org.apache.olingo.client.core.communication.request.batch.ODataBatchRequestImpl;
import org.apache.olingo.commons.api.format.ContentType;
import org.mule.extension.microsoftdynamics365.internal.connection.client.AbstractDynamicsClient;
import org.mule.extension.microsoftdynamics365.internal.utils.ODataCheckResponse;

public class DynamicsBatchClient
extends AbstractDynamicsClient {
    private static int THREAD_NUMBER_FOR_BATCH_CONFIG = 2;
    private static ExecutorService executor = Executors.newFixedThreadPool(THREAD_NUMBER_FOR_BATCH_CONFIG);

    public DynamicsBatchClient(HttpClientFactory httpClientFactory, Map<String, String> additionalHeaders) {
        super(httpClientFactory, additionalHeaders);
    }

    @Override
    public void initClientConfiguration() {
        Configuration configuration = this.getConfiguration();
        configuration.setUseChuncked(true);
        configuration.setDefaultBatchAcceptFormat(ContentType.APPLICATION_JSON);
        configuration.setContinueOnError(false);
        configuration.setExecutor(executor);
        configuration.setHttpClientFactory(this.httpClientFactory);
        configuration.setDefaultPubFormat(ContentType.create((ContentType)ContentType.JSON_NO_METADATA, (String)"IEEE754Compatible", (String)"true"));
    }

    public BatchRequestFactory getBatchRequestFactory() {
        return new Dynamics365BatchRequestFactory((ODataClient)this);
    }

    public class Dynamics365BatchRequestFactory
    extends BatchRequestFactoryImpl {
        private Dynamics365BatchRequestFactory(ODataClient client) {
            super(client);
        }

        public ODataBatchRequest getBatchRequest(String serviceRoot) {
            return new Dynamics365BatchRequest(this.client, this.client.newURIBuilder(serviceRoot).appendBatchSegment().build());
        }

        public class Dynamics365BatchRequest
        extends ODataBatchRequestImpl {
            private Dynamics365BatchRequest(ODataClient odataClient, URI uri) {
                super(odataClient, uri);
            }

            protected void checkResponse(ODataClient odataClient, HttpResponse response, String accept) {
                ODataCheckResponse.SINGLETON.checkResponse(odataClient, response, accept);
            }
        }
    }
}

