/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.microsoftdynamics365.internal.connection;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.ODataClientErrorException;
import org.apache.olingo.client.api.communication.request.ODataBatchableRequest;
import org.apache.olingo.client.api.communication.request.ODataRequest;
import org.apache.olingo.client.api.communication.request.batch.BatchManager;
import org.apache.olingo.client.api.communication.request.batch.ODataBatchRequest;
import org.apache.olingo.client.api.communication.request.batch.ODataBatchResponseItem;
import org.apache.olingo.client.api.communication.request.batch.ODataChangeset;
import org.apache.olingo.client.api.communication.request.retrieve.ODataEntityRequest;
import org.apache.olingo.client.api.communication.request.retrieve.ODataRawRequest;
import org.apache.olingo.client.api.communication.response.ODataBatchResponse;
import org.apache.olingo.client.api.communication.response.ODataDeleteResponse;
import org.apache.olingo.client.api.communication.response.ODataEntityCreateResponse;
import org.apache.olingo.client.api.communication.response.ODataResponse;
import org.apache.olingo.client.api.communication.response.ODataRetrieveResponse;
import org.apache.olingo.client.api.domain.ClientEntity;
import org.apache.olingo.client.api.domain.ClientObjectFactory;
import org.apache.olingo.client.api.http.HttpClientException;
import org.apache.olingo.client.api.http.HttpClientFactory;
import org.apache.olingo.client.api.uri.URIBuilder;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.odata2.api.batch.BatchException;
import org.apache.olingo.odata2.api.client.batch.BatchSingleResponse;
import org.apache.olingo.odata2.api.ep.EntityProvider;
import org.mule.extension.microsoftdynamics365.api.utils.rest.InvokeHttpMethod;
import org.mule.extension.microsoftdynamics365.internal.connection.MicrosoftDynamics365Executable;
import org.mule.extension.microsoftdynamics365.internal.connection.client.DynamicsBatchClient;
import org.mule.extension.microsoftdynamics365.internal.connection.client.DynamicsClient;
import org.mule.extension.microsoftdynamics365.internal.connection.dto.DynamicsBulkItem;
import org.mule.extension.microsoftdynamics365.internal.connection.dto.DynamicsBulkResult;
import org.mule.extension.microsoftdynamics365.internal.connection.dto.ErrorResponse;
import org.mule.extension.microsoftdynamics365.internal.connection.util.DynamicsHttpClientFactory;
import org.mule.extension.microsoftdynamics365.internal.error.Dynamics365ErrorType;
import org.mule.extension.microsoftdynamics365.internal.error.exception.Dynamics365ConnectionException;
import org.mule.extension.microsoftdynamics365.internal.error.exception.Dynamics365Exception;
import org.mule.extension.microsoftdynamics365.internal.error.exception.EntityCreationFailedException;
import org.mule.extension.microsoftdynamics365.internal.error.exception.EntityDisassociationFailedException;
import org.mule.extension.microsoftdynamics365.internal.error.exception.InvalidEntityIDException;
import org.mule.extension.microsoftdynamics365.internal.error.exception.InvalidJSONEncodingException;
import org.mule.extension.microsoftdynamics365.internal.error.exception.InvalidProtocolException;
import org.mule.extension.microsoftdynamics365.internal.error.exception.InvalidURIException;
import org.mule.extension.microsoftdynamics365.internal.error.exception.InvocationFailedException;
import org.mule.extension.microsoftdynamics365.internal.error.exception.JSONParsingException;
import org.mule.extension.microsoftdynamics365.internal.error.exception.LogicalNameNotFoundException;
import org.mule.extension.microsoftdynamics365.internal.error.exception.MissingBoundElementException;
import org.mule.extension.microsoftdynamics365.internal.error.exception.OperationFailedException;
import org.mule.extension.microsoftdynamics365.internal.error.exception.UnauthorizedAccessException;
import org.mule.extension.microsoftdynamics365.internal.error.exception.UnsupportedHTTPMethodException;
import org.mule.extension.microsoftdynamics365.internal.error.exception.handlers.HttpClientExceptionHandler;
import org.mule.extension.microsoftdynamics365.internal.error.exception.handlers.HttpResponseValidator;
import org.mule.extension.microsoftdynamics365.internal.error.exception.handlers.ODataClientErrorExceptionHandler;
import org.mule.extension.microsoftdynamics365.internal.operation.odata.DynamicsODataEntityCreateRequest;
import org.mule.extension.microsoftdynamics365.internal.operation.odata.DynamicsODataEntityUpdateRequest;
import org.mule.extension.microsoftdynamics365.internal.operation.util.OperationUtil;
import org.mule.extension.microsoftdynamics365.internal.utils.URIUtils;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.connectivity.oauth.AccessTokenExpiredException;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.http.api.HttpConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dynamics365Connection {
    private static final Logger logger = LoggerFactory.getLogger(Dynamics365Connection.class);
    public static final int MAX_PAGE_SIZE = 5000;
    private static final String NAMESPACE = "Microsoft.Dynamics.CRM.";
    private static final String ELEMENT_NOT_FOUND_EXCEPTION_MESSAGE = "Expected item not found";
    private static final String NO_ITEM_FOUND_EXCEPTION_MESSAGE = "No item found";
    private final String apiEndpoint;
    private final Map<String, String> defaultHeaders;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private DynamicsClient simpleClient;
    private DynamicsBatchClient batchClient;
    private DynamicsHttpClientFactory dynamicsHttpClientFactory;
    private final Gson gson = new Gson();
    private Boolean errorMessageAlreadyRead = false;

    public Dynamics365Connection(String endpoint, String version, DynamicsHttpClientFactory dynamicsHttpClientFactory) throws ConnectionException {
        this.defaultHeaders = new LinkedHashMap<String, String>();
        this.apiEndpoint = this.buildApiEndpoint(endpoint, version);
        this.simpleClient = new DynamicsClient((HttpClientFactory)dynamicsHttpClientFactory, this.defaultHeaders);
        this.batchClient = new DynamicsBatchClient((HttpClientFactory)dynamicsHttpClientFactory, this.defaultHeaders);
        this.dynamicsHttpClientFactory = dynamicsHttpClientFactory;
    }

    public URIBuilder newURIBuilder() {
        return this.simpleClient.newURIBuilder(this.apiEndpoint);
    }

    public DynamicsClient getSimpleClient() {
        return this.simpleClient;
    }

    public DynamicsBatchClient getBatchClient() {
        return this.batchClient;
    }

    public String getApiEndpoint() {
        return this.apiEndpoint;
    }

    public void onAccessTokenExpiredException() {
    }

    public String getAccessToken() {
        return null;
    }

    public Map<String, Object> get(String relativePath) {
        try {
            ODataRawRequest requestWrapper = this.simpleClient.getRetrieveRequestFactory().getRawRequest(URIUtils.getURI(String.format("%s%s", this.apiEndpoint, relativePath)));
            return (Map)this.objectMapper.readValue(this.simpleClient.getAsyncRequestFactory().getAsyncRequestWrapper((ODataRequest)requestWrapper).execute().getODataResponse().getRawResponse(), HashMap.class);
        }
        catch (IOException e) {
            throw new JSONParsingException(e);
        }
    }

    public void disconnect() {
    }

    public void validate() {
        try {
            this.get("timezonelocalizednames");
        }
        catch (ODataClientErrorException e) {
            if (Integer.parseInt(e.getODataError().getCode()) == 401) {
                this.onAccessTokenExpiredException();
                throw new ModuleException((ErrorTypeDefinition)Dynamics365ErrorType.CONNECTIVITY, (Throwable)new ConnectionException((Throwable)e));
            }
            throw new Dynamics365Exception(e.getMessage(), Dynamics365ErrorType.CONNECTIVITY);
        }
        catch (Exception e) {
            throw new Dynamics365Exception(e.getMessage(), Dynamics365ErrorType.CONNECTIVITY);
        }
    }

    private String buildApiEndpoint(String apiEndpoint, String version) {
        return String.format("%s%s%s", apiEndpoint, Optional.of("/").filter(value -> !apiEndpoint.endsWith("/")).orElse(""), Optional.of("api/data").filter(value -> !apiEndpoint.contains((CharSequence)value)).map(data -> String.format("%s/v%s/", data, version)).orElse(""));
    }

    protected void addAccessToken() throws ConnectionException {
        String token = Optional.ofNullable(this.getAccessToken()).orElseThrow(() -> new ConnectionException("Could not extract field 'accessToken'."));
        this.defaultHeaders.put("Authorization", String.format("%s%s", "Bearer ", token));
    }

    public DynamicsHttpClientFactory getDynamicsHttpClientFactory() {
        return this.dynamicsHttpClientFactory;
    }

    public <T> T execute(MicrosoftDynamics365Executable<T> executable) {
        try {
            this.addAccessToken();
            return executable.execute();
        }
        catch (HttpClientException exception) {
            throw new HttpClientExceptionHandler().handle((Exception)((Object)exception), this);
        }
        catch (ODataClientErrorException exception) {
            throw new ODataClientErrorExceptionHandler().handle(exception, this);
        }
        catch (Dynamics365ConnectionException exception) {
            throw new ModuleException((ErrorTypeDefinition)Dynamics365ErrorType.CONNECTIVITY, (Throwable)new ConnectionException(exception.getMessage()));
        }
        catch (AccessTokenExpiredException | ModuleException e) {
            throw e;
        }
        catch (Exception exception) {
            throw new OperationFailedException(exception);
        }
    }

    public String createEntity(String logicalName, Map<String, Object> attributes, String encoding) {
        return this.execute(() -> {
            try {
                ClientObjectFactory objectFactory = this.getSimpleClient().getObjectFactory();
                String entitySetName = OperationUtil.getEntitySetNameByLogicalName(logicalName, this);
                URI uri = this.newURIBuilder().appendEntitySetSegment(entitySetName).build();
                ClientEntity entity = OperationUtil.getClientEntity(objectFactory, attributes);
                DynamicsODataEntityCreateRequest<ClientEntity> request = new DynamicsODataEntityCreateRequest<ClientEntity>((ODataClient)this.getSimpleClient(), uri, entity);
                OperationUtil.addHeadersToRequest(encoding, request);
                ODataEntityCreateResponse response = (ODataEntityCreateResponse)request.execute();
                String entityIdHeaderResponseValue = OperationUtil.getEntityIdHeaderValue((ODataResponse)response);
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)entityIdHeaderResponseValue)) {
                    throw new EntityCreationFailedException(uri);
                }
                return OperationUtil.parseEntityIdFromURI(entityIdHeaderResponseValue);
            }
            catch (UnauthorizedAccessException e) {
                throw new Dynamics365ConnectionException(e.getCause());
            }
        });
    }

    public String deleteEntity(String logicalName, String id) {
        return this.execute(() -> {
            try {
                String entitySetName = OperationUtil.getEntitySetNameByLogicalName(logicalName, this);
                ODataDeleteResponse response = (ODataDeleteResponse)this.getSimpleClient().getCUDRequestFactory().getDeleteRequest(this.newURIBuilder().appendEntitySetSegment(entitySetName).appendKeySegment((Object)UUID.fromString(id)).build()).execute();
                return String.valueOf(response.getStatusCode());
            }
            catch (IllegalArgumentException e) {
                throw new InvalidEntityIDException(e);
            }
        });
    }

    public Map<String, Object> retrieve(String logicalName, String id) {
        return this.execute(() -> {
            try {
                String entitySetName = OperationUtil.getEntitySetNameByLogicalName(logicalName, this);
                URI uri = this.newURIBuilder().appendEntitySetSegment(entitySetName).appendKeySegment((Object)UUID.fromString(id)).build();
                ODataEntityRequest request = this.getSimpleClient().getRetrieveRequestFactory().getEntityRequest(uri);
                ODataRetrieveResponse response = (ODataRetrieveResponse)request.execute();
                return response != null ? (Map)new ObjectMapper().readValue(response.getRawResponse(), HashMap.class) : Collections.emptyMap();
            }
            catch (IllegalArgumentException e) {
                throw new InvalidEntityIDException(e);
            }
            catch (IOException e) {
                throw new JSONParsingException(e);
            }
        });
    }

    public void updateEntity(String logicalName, Map<String, Object> entityForUpdate, String encoding) {
        this.execute(() -> {
            try {
                String entityId = OperationUtil.extractEntityId(entityForUpdate);
                Map entityAttributes = OperationUtil.validateAttributes(entityForUpdate, Map.class);
                String entitySetName = OperationUtil.getEntitySetNameByLogicalName(logicalName, this);
                URI uri = this.getSimpleClient().newURIBuilder(this.getApiEndpoint()).appendEntitySetSegment(entitySetName).appendKeySegment((Object)UUID.fromString(entityId)).build();
                ClientObjectFactory objectFactory = this.getSimpleClient().getObjectFactory();
                ClientEntity entity = OperationUtil.getClientEntity(objectFactory, entityAttributes);
                DynamicsODataEntityUpdateRequest<ClientEntity> request = new DynamicsODataEntityUpdateRequest<ClientEntity>((ODataClient)this.getSimpleClient(), HttpMethod.PATCH, uri, entity);
                OperationUtil.addHeadersToRequest(encoding, request);
                request.execute();
            }
            catch (IllegalArgumentException e) {
                throw new InvalidEntityIDException(e);
            }
            return null;
        });
    }

    public Map<String, Object> rawRetrieve(URI uri, Map<String, String> headers) {
        try {
            ODataRawRequest request = this.getSimpleClient().getRetrieveRequestFactory().getRawRequest(uri);
            if (headers != null && headers.size() > 0) {
                for (Map.Entry<String, String> header : headers.entrySet()) {
                    request.addCustomHeader(header.getKey(), header.getValue());
                }
            }
            return (Map)new ObjectMapper().readValue(request.execute().getRawResponse(), HashMap.class);
        }
        catch (IOException e) {
            throw new JSONParsingException(e);
        }
    }

    public Map<String, Object> doAction(String actionName, String boundedEntityType, String boundedEntityId, Map<String, Object> relatedEntities, String encoding) {
        return this.execute(() -> {
            String json;
            URI location;
            boolean isBound = false;
            boolean isBoundEntityTypePresent = StringUtils.isNotEmpty((String)boundedEntityType);
            boolean isBoundEntityIdPresend = StringUtils.isNotEmpty((String)boundedEntityId);
            if (isBoundEntityTypePresent && isBoundEntityIdPresend) {
                isBound = true;
            } else if (!isBoundEntityTypePresent && isBoundEntityIdPresend || isBoundEntityTypePresent && !isBoundEntityIdPresend) {
                throw new MissingBoundElementException();
            }
            if (isBound) {
                UUID boundedEntity = UUID.fromString(boundedEntityId);
                location = this.newURIBuilder().appendEntitySetSegment(boundedEntityType).appendKeySegment((Object)boundedEntity).appendActionCallSegment(NAMESPACE + actionName).build();
            } else {
                location = this.newURIBuilder().appendActionCallSegment(actionName).build();
            }
            try {
                json = this.objectMapper.writeValueAsString((Object)relatedEntities);
            }
            catch (JsonProcessingException e) {
                throw new JSONParsingException(e);
            }
            Map<String, Object> invokeResponse = this.invoke(location.toString(), InvokeHttpMethod.POST, null, json, encoding);
            invokeResponse.remove("headers");
            return invokeResponse;
        });
    }

    public Map<String, Object> invoke(String uri, InvokeHttpMethod httpMethod, Map<String, String> headers, String json, String encoding) {
        return this.execute(() -> {
            try {
                HttpGet requestBase;
                URI resource = URIUtils.encodeQuery(uri);
                switch (httpMethod) {
                    case POST: {
                        HttpPost httpPost = new HttpPost(resource);
                        httpPost.setEntity((HttpEntity)new ByteArrayEntity(json.getBytes(encoding)));
                        requestBase = httpPost;
                        break;
                    }
                    case GET: {
                        requestBase = new HttpGet(resource);
                        break;
                    }
                    case PUT: {
                        HttpPut httpPut = new HttpPut(resource);
                        httpPut.setEntity((HttpEntity)new ByteArrayEntity(json.getBytes(encoding)));
                        requestBase = httpPut;
                        break;
                    }
                    case PATCH: {
                        HttpPatch httpPatch = new HttpPatch(resource);
                        httpPatch.setEntity((HttpEntity)new ByteArrayEntity(json.getBytes(encoding)));
                        requestBase = httpPatch;
                        break;
                    }
                    case DELETE: {
                        requestBase = new HttpDelete(resource);
                        break;
                    }
                    default: {
                        throw new UnsupportedHTTPMethodException();
                    }
                }
                Map additionalHeaders = Optional.ofNullable(headers).orElseGet(HashMap::new);
                Predicate<String> containsKeyPredicate = additionalHeaders::containsKey;
                Consumer<String> putConsumer = arg_0 -> Dynamics365Connection.lambda$null$9((HttpRequestBase)requestBase, encoding, arg_0);
                Optional.of("Authorization").filter(containsKeyPredicate.negate()).ifPresent(arg_0 -> this.lambda$null$10((HttpRequestBase)requestBase, arg_0));
                Optional.of("Accept").filter(containsKeyPredicate.negate()).ifPresent(putConsumer);
                Optional.of("Content-Type").filter(containsKeyPredicate.negate()).ifPresent(putConsumer);
                for (Map.Entry headerEntry : additionalHeaders.entrySet()) {
                    requestBase.addHeader((String)headerEntry.getKey(), (String)headerEntry.getValue());
                }
                HttpClient httpclient = this.getSimpleClient().getConfiguration().getHttpClientFactory().create(null, null);
                HttpResponse response = httpclient.execute((HttpUriRequest)requestBase);
                HttpResponseValidator.validate(response, this);
                HashMap<String, Object> mapResponse = new HashMap<String, Object>();
                mapResponse.put("responseMsg", response.getStatusLine().getReasonPhrase());
                mapResponse.put("responseCode", String.valueOf(response.getStatusLine().getStatusCode()));
                LinkedHashMap<String, String> allHeaders = new LinkedHashMap<String, String>();
                for (Header allHeader : Optional.ofNullable(response.getAllHeaders()).orElse(new Header[0])) {
                    allHeaders.put(allHeader.getName(), allHeader.getValue());
                }
                mapResponse.put("headers", allHeaders);
                mapResponse.put("body", Optional.ofNullable(response.getEntity()).map(this::getString).orElse(""));
                return mapResponse;
            }
            catch (UnsupportedEncodingException e) {
                throw new InvalidJSONEncodingException(e);
            }
            catch (ClientProtocolException e) {
                throw new InvalidProtocolException(e);
            }
            catch (URISyntaxException e) {
                throw new InvalidURIException(uri, e);
            }
            catch (IOException e) {
                throw new InvocationFailedException(e);
            }
        });
    }

    private String getString(HttpEntity entity) {
        try {
            return EntityUtils.toString((HttpEntity)entity, (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            throw new InvalidJSONEncodingException(e);
        }
    }

    public DynamicsBulkResult<Map<String, Object>> createMultipleEntities(String logicalName, List<Map<String, Object>> attributesList, boolean useSingleTransaction, String encoding, boolean continueOnError) {
        return this.execute(() -> {
            try {
                this.getBatchClient().getConfiguration().setContinueOnError(continueOnError);
                String entitySetName = OperationUtil.getEntitySetNameByLogicalName(logicalName, this);
                URI uri = this.getBatchClient().newURIBuilder(this.getApiEndpoint()).appendEntitySetSegment(entitySetName).build();
                ODataBatchRequest request = this.getBatchClient().getBatchRequestFactory().getBatchRequest(this.getApiEndpoint());
                BatchManager payloadManager = (BatchManager)request.payloadManager();
                if (useSingleTransaction) {
                    return this.createMultipleEntitiesAsSingleTransaction(attributesList, encoding, uri, payloadManager);
                }
                return this.createMultipleEntitiesAsMultipleTransactions(attributesList, encoding, uri, payloadManager);
            }
            catch (UnauthorizedAccessException e) {
                throw new Dynamics365ConnectionException(e.getCause());
            }
            catch (BatchException e) {
                throw new ModuleException(e.getMessage() != null ? e.getMessage() : "Unable to parse batch request!", (ErrorTypeDefinition)Dynamics365ErrorType.PARSE_ERROR);
            }
            catch (ExecutionException | TimeoutException e) {
                throw new ModuleException((ErrorTypeDefinition)Dynamics365ErrorType.TIMEOUT, (Throwable)e);
            }
        });
    }

    private DynamicsBulkResult<Map<String, Object>> createMultipleEntitiesAsMultipleTransactions(List<Map<String, Object>> attributesList, String encoding, URI uri, BatchManager payloadManager) throws InterruptedException, ExecutionException, TimeoutException, BatchException {
        for (Map<String, Object> entityAttributes : attributesList) {
            ODataChangeset changeset = payloadManager.addChangeset();
            changeset.addRequest(OperationUtil.createEntityForBatchRequest((ODataClient)this.getBatchClient(), uri, entityAttributes, encoding));
        }
        Future oDataBatchResponseFuture = payloadManager.getAsyncResponse();
        ODataBatchResponse batchResponse = (ODataBatchResponse)oDataBatchResponseFuture.get(this.getReadTimeout(), TimeUnit.MILLISECONDS);
        List batchResponses = EntityProvider.parseBatchResponse((InputStream)batchResponse.getRawResponse(), (String)batchResponse.getContentType());
        DynamicsBulkResult.BulkOperationResultBuilder<Map<String, Object>> builder = DynamicsBulkResult.builder();
        this.addItems(batchResponses, builder, attributesList);
        return builder.build();
    }

    private DynamicsBulkResult<Map<String, Object>> createMultipleEntitiesAsSingleTransaction(List<Map<String, Object>> attributesList, String encoding, URI uri, BatchManager payloadManager) throws InterruptedException, ExecutionException, TimeoutException {
        ODataChangeset changeset = payloadManager.addChangeset();
        for (Map<String, Object> entityAttributes : attributesList) {
            changeset.addRequest(OperationUtil.createEntityForBatchRequest((ODataClient)this.getBatchClient(), uri, entityAttributes, encoding));
        }
        Future oDataBatchResponseFuture = payloadManager.getAsyncResponse();
        ODataBatchResponse batchResponse = (ODataBatchResponse)oDataBatchResponseFuture.get(this.getReadTimeout(), TimeUnit.MILLISECONDS);
        DynamicsBulkResult.BulkOperationResultBuilder<Map<String, Object>> builder = DynamicsBulkResult.builder();
        Iterator iter = batchResponse.getBody();
        ODataResponse oDataResponse = null;
        ODataBatchResponseItem responseEntity = (ODataBatchResponseItem)iter.next();
        for (Map<String, Object> itemPayload : attributesList) {
            oDataResponse = this.getoDataResponse(batchResponse, builder, responseEntity, oDataResponse, itemPayload);
        }
        return builder.build();
    }

    private void addItems(List<BatchSingleResponse> batchResponses, DynamicsBulkResult.BulkOperationResultBuilder<Map<String, Object>> builder, List<Map<String, Object>> batchRequests) {
        for (int i = 0; i < batchResponses.size(); ++i) {
            builder.addItem(OperationUtil.getBulkItem(batchResponses.get(i), batchRequests.get(i)));
        }
        List<Map<String, Object>> unprocessedBatchRequests = batchRequests.subList(batchResponses.size(), batchRequests.size());
        for (Map<String, Object> unprocessedBatchRequest : unprocessedBatchRequests) {
            builder.addItem(OperationUtil.getDefaultBulkItem(unprocessedBatchRequest));
        }
    }

    private ODataResponse getoDataResponse(ODataBatchResponse batchResponse, DynamicsBulkResult.BulkOperationResultBuilder<Map<String, Object>> builder, ODataBatchResponseItem responseEntity, ODataResponse oDataResponse, Map<String, Object> itemPayload) {
        try {
            oDataResponse = (ODataResponse)responseEntity.next();
            builder.addItem(OperationUtil.getBulkItem(oDataResponse, itemPayload));
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            this.processErrorFromServer(batchResponse, builder, itemPayload, oDataResponse);
        }
        return oDataResponse;
    }

    public DynamicsBulkResult<Map<String, Object>> updateMultipleEntities(String logicalName, List<Map<String, Object>> attributesList, boolean useSingleTransaction, String encoding, boolean continueOnError) {
        return this.execute(() -> {
            try {
                this.getBatchClient().getConfiguration().setContinueOnError(continueOnError);
                String entitySetName = OperationUtil.getEntitySetNameByLogicalName(logicalName, this);
                ODataBatchRequest request = this.getBatchClient().getBatchRequestFactory().getBatchRequest(this.getApiEndpoint());
                BatchManager payloadManager = (BatchManager)request.payloadManager();
                if (useSingleTransaction) {
                    return this.updateMultipleEntitiesAsSingleTransaction(attributesList, encoding, entitySetName, payloadManager);
                }
                return this.updateMultipleEntitiesAsMultipleTransactions(attributesList, encoding, entitySetName, payloadManager);
            }
            catch (UnauthorizedAccessException e) {
                throw new Dynamics365ConnectionException(e.getCause());
            }
            catch (ExecutionException | TimeoutException e) {
                throw new ModuleException((ErrorTypeDefinition)Dynamics365ErrorType.TIMEOUT, (Throwable)e);
            }
        });
    }

    private DynamicsBulkResult<Map<String, Object>> updateMultipleEntitiesAsMultipleTransactions(List<Map<String, Object>> attributesList, String encoding, String entitySetName, BatchManager payloadManager) throws InterruptedException, ExecutionException, TimeoutException {
        LinkedList<Map<String, Object>> rejectedRequests = new LinkedList<Map<String, Object>>();
        for (Map<String, Object> entityForUpdate : attributesList) {
            this.updateRequest(entitySetName, payloadManager, rejectedRequests, entityForUpdate, encoding);
        }
        Future oDataBatchResponseFuture = payloadManager.getAsyncResponse();
        ODataBatchResponse batchResponse = (ODataBatchResponse)oDataBatchResponseFuture.get(this.getReadTimeout(), TimeUnit.MILLISECONDS);
        DynamicsBulkResult.BulkOperationResultBuilder<Map<String, Object>> builder = DynamicsBulkResult.builder();
        Iterator iter = batchResponse.getBody();
        for (Map<String, Object> anAttributesList : attributesList) {
            boolean isRejected = rejectedRequests.contains(anAttributesList);
            if (isRejected) {
                ErrorResponse oDataResponse = new ErrorResponse(400, "This entity was rejected for update. Please check you provided all the required fields.");
                builder.addItem(OperationUtil.getBulkItem(oDataResponse, anAttributesList));
                rejectedRequests.remove(anAttributesList);
                continue;
            }
            this.parseResponse(batchResponse, builder, iter, anAttributesList);
        }
        return builder.build();
    }

    private DynamicsBulkResult<Map<String, Object>> updateMultipleEntitiesAsSingleTransaction(List<Map<String, Object>> attributesList, String encoding, String entitySetName, BatchManager payloadManager) throws InterruptedException, ExecutionException, TimeoutException {
        ODataBatchResponse batchResponse = null;
        LinkedList<Map<String, Object>> rejectedRequests = new LinkedList<Map<String, Object>>();
        for (Map<String, Object> map : attributesList) {
            this.extractAndValidate(rejectedRequests, map);
        }
        if (CollectionUtils.isEmpty(rejectedRequests)) {
            ODataChangeset changeset = payloadManager.addChangeset();
            for (Map<String, Object> map : attributesList) {
                changeset.addRequest(this.getBatchRequestForUpdate(entitySetName, map, encoding));
            }
            Future future = payloadManager.getAsyncResponse();
            batchResponse = (ODataBatchResponse)future.get(this.getReadTimeout(), TimeUnit.MILLISECONDS);
        } else {
            payloadManager.finalizeBody();
        }
        boolean noResponse = batchResponse == null;
        DynamicsBulkResult.BulkOperationResultBuilder<Map<String, Object>> bulkOperationResultBuilder = DynamicsBulkResult.builder();
        ODataBatchResponseItem responseEntity = null;
        if (!noResponse) {
            Iterator iterator = batchResponse.getBody();
            responseEntity = (ODataBatchResponseItem)iterator.next();
        }
        ErrorResponse oDataResponse = null;
        for (Map<String, Object> itemPayload : attributesList) {
            boolean isRejected = rejectedRequests.contains(itemPayload);
            if (isRejected) {
                oDataResponse = new ErrorResponse(400, "This entity was rejected. Please check you provided the required fields.");
                bulkOperationResultBuilder.addItem(OperationUtil.getBulkItem(oDataResponse, itemPayload));
                rejectedRequests.remove(itemPayload);
                continue;
            }
            if (noResponse) {
                oDataResponse = new ErrorResponse(400, "Other requests were already rejected! No request was made to the server.");
                bulkOperationResultBuilder.addItem(OperationUtil.getBulkItem(oDataResponse, itemPayload));
                continue;
            }
            oDataResponse = this.getResponse(batchResponse, bulkOperationResultBuilder, responseEntity, oDataResponse, itemPayload);
        }
        return bulkOperationResultBuilder.build();
    }

    private void parseResponse(ODataBatchResponse batchResponse, DynamicsBulkResult.BulkOperationResultBuilder<Map<String, Object>> builder, Iterator<ODataBatchResponseItem> iter, Map<String, Object> itemPayload) {
        try {
            ODataBatchResponseItem responseEntity = iter.next();
            ODataResponse oDataResponse = (ODataResponse)responseEntity.next();
            builder.addItem(OperationUtil.getBulkItem(oDataResponse, itemPayload));
        }
        catch (RuntimeException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ErrorResponse oDataResponse = new ErrorResponse((ODataResponse)batchResponse);
            builder.addItem(OperationUtil.getBulkItem(oDataResponse, itemPayload));
        }
    }

    private void updateRequest(String entitySetName, BatchManager payloadManager, List<Map<String, Object>> rejectedRequests, Map<String, Object> entityForUpdate, String encoding) {
        try {
            ODataBatchableRequest updateRequest = this.getBatchRequestForUpdate(entitySetName, entityForUpdate, encoding);
            ODataChangeset changeset = payloadManager.addChangeset();
            changeset.addRequest(updateRequest);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            rejectedRequests.add(entityForUpdate);
        }
    }

    private ODataResponse getResponse(ODataBatchResponse batchResponse, DynamicsBulkResult.BulkOperationResultBuilder<Map<String, Object>> builder, ODataBatchResponseItem responseEntity, ODataResponse oDataResponse, Map<String, Object> itemPayload) {
        try {
            oDataResponse = (ODataResponse)responseEntity.next();
            builder.addItem(OperationUtil.getBulkItem(oDataResponse, itemPayload));
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            this.processErrorFromServer(batchResponse, builder, itemPayload, oDataResponse);
        }
        return oDataResponse;
    }

    private void extractAndValidate(List<Map<String, Object>> rejectedRequests, Map<String, Object> entityAttributes) {
        try {
            String entityId = OperationUtil.extractEntityId(entityAttributes);
            OperationUtil.validateAttributes(entityAttributes, Map.class);
            UUID.fromString(entityId);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            rejectedRequests.add(entityAttributes);
        }
    }

    public DynamicsBulkResult<String> deleteMultipleEntities(String logicalName, List<String> ids, boolean useSingleTransaction, boolean continueOnError) {
        return this.execute(() -> {
            try {
                this.getBatchClient().getConfiguration().setContinueOnError(continueOnError);
                LinkedList<String> rejectedRequests = new LinkedList<String>();
                String entitySetName = OperationUtil.getEntitySetNameByLogicalName(logicalName, this);
                ODataBatchRequest request = this.getBatchClient().getBatchRequestFactory().getBatchRequest(this.getApiEndpoint());
                BatchManager payloadManager = (BatchManager)request.payloadManager();
                ODataBatchResponse batchResponse = null;
                if (useSingleTransaction) {
                    return this.deleteMultipleEntitiesAsSingleTransaction(ids, entitySetName, payloadManager, batchResponse);
                }
                return this.deleteMultipleEntitiesAsMultipleTransactions(ids, rejectedRequests, entitySetName, payloadManager, continueOnError);
            }
            catch (UnauthorizedAccessException e) {
                throw new Dynamics365ConnectionException(e.getCause());
            }
            catch (ExecutionException | TimeoutException e) {
                throw new ModuleException((ErrorTypeDefinition)Dynamics365ErrorType.TIMEOUT, (Throwable)e);
            }
        });
    }

    private DynamicsBulkResult<String> deleteMultipleEntitiesAsMultipleTransactions(List<String> ids, List<String> rejectedRequests, String entitySetName, BatchManager payloadManager, boolean continueOnError) throws InterruptedException, ExecutionException, TimeoutException {
        for (String entityId : ids) {
            this.updateAfterDelete(rejectedRequests, entitySetName, payloadManager, entityId, continueOnError);
        }
        Future oDataBatchResponseFuture = payloadManager.getAsyncResponse();
        ODataBatchResponse batchResponse = (ODataBatchResponse)oDataBatchResponseFuture.get(this.getReadTimeout(), TimeUnit.MILLISECONDS);
        DynamicsBulkResult.BulkOperationResultBuilder<String> builder = DynamicsBulkResult.builder();
        Iterator iter = batchResponse.getBody();
        for (String itemPayload : ids) {
            boolean isRejected = rejectedRequests.contains(itemPayload);
            if (isRejected) {
                ErrorResponse oDataResponse = new ErrorResponse(400, "The ID for this request was rejected. The ID must have the UUID format.");
                builder.addItem(this.getBulkItemForDelete(oDataResponse, itemPayload));
                rejectedRequests.remove(itemPayload);
                continue;
            }
            this.addDeletedItem(batchResponse, builder, iter, itemPayload);
        }
        return builder.build();
    }

    private DynamicsBulkResult<String> deleteMultipleEntitiesAsSingleTransaction(List<String> ids, String entitySetName, BatchManager payloadManager, ODataBatchResponse batchResponse) throws InterruptedException, ExecutionException, TimeoutException {
        LinkedList<String> rejectedRequests = new LinkedList<String>();
        for (String string : ids) {
            this.fromString(rejectedRequests, string);
        }
        if (CollectionUtils.isEmpty(rejectedRequests)) {
            ODataChangeset changeset = payloadManager.addChangeset();
            for (String entityId : ids) {
                changeset.addRequest(OperationUtil.deleteEntityForBatchRequest((ODataClient)this.getBatchClient(), this.getApiEndpoint(), entitySetName, entityId));
            }
            Future future = payloadManager.getAsyncResponse();
            batchResponse = (ODataBatchResponse)future.get(this.getReadTimeout(), TimeUnit.MILLISECONDS);
        } else {
            payloadManager.finalizeBody();
        }
        boolean noResponse = batchResponse == null;
        DynamicsBulkResult.BulkOperationResultBuilder<String> bulkOperationResultBuilder = DynamicsBulkResult.builder();
        ODataBatchResponseItem responseEntity = null;
        if (!noResponse) {
            Iterator iter = batchResponse.getBody();
            responseEntity = (ODataBatchResponseItem)iter.next();
        }
        Optional<Object> errorMessage = Optional.empty();
        if (batchResponse != null) {
            errorMessage = this.getErrorMessage(batchResponse);
        }
        for (String itemPayload : ids) {
            ErrorResponse oDataResponse = null;
            boolean isRejected = rejectedRequests.contains(itemPayload);
            if (isRejected) {
                oDataResponse = new ErrorResponse(400, "The ID for this request was rejected. The ID must have the UUID format.");
                bulkOperationResultBuilder.addItem(this.getBulkItemForDelete(oDataResponse, itemPayload));
                rejectedRequests.remove(itemPayload);
                continue;
            }
            if (noResponse) {
                oDataResponse = new ErrorResponse(400, "Some delete requests were rejected because the ID was missing or not well formatted.");
                bulkOperationResultBuilder.addItem(this.getBulkItemForDelete(oDataResponse, itemPayload));
                continue;
            }
            if (errorMessage.isPresent() && ((String)errorMessage.get()).contains(itemPayload) && !this.errorMessageAlreadyRead.booleanValue()) {
                this.errorMessageAlreadyRead = true;
                oDataResponse = new ErrorResponse(batchResponse.getStatusCode(), batchResponse.getStatusMessage());
                bulkOperationResultBuilder.addItem(this.getBulkItemForDelete(oDataResponse, itemPayload));
                continue;
            }
            this.getItemForDelete(batchResponse, bulkOperationResultBuilder, responseEntity, oDataResponse, itemPayload);
        }
        return bulkOperationResultBuilder.build();
    }

    private void getItemForDelete(ODataBatchResponse batchResponse, DynamicsBulkResult.BulkOperationResultBuilder<String> builder, ODataBatchResponseItem responseEntity, ODataResponse oDataResponse, String itemPayload) {
        try {
            oDataResponse = (ODataResponse)responseEntity.next();
            builder.addItem(this.getBulkItemForDelete(oDataResponse, itemPayload));
        }
        catch (IllegalStateException | NoSuchElementException exception) {
            if (ELEMENT_NOT_FOUND_EXCEPTION_MESSAGE.equals(exception.getMessage()) || NO_ITEM_FOUND_EXCEPTION_MESSAGE.equals(exception.getMessage())) {
                oDataResponse = new ErrorResponse(400, "Some delete requests were rejected because the ID was missing or not well formatted.");
                builder.addItem(this.getBulkItemForDelete(oDataResponse, itemPayload));
            }
            throw exception;
        }
        catch (RuntimeException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            this.processErrorFromServer(batchResponse, builder, itemPayload, oDataResponse);
        }
    }

    private void addDeletedItem(ODataBatchResponse batchResponse, DynamicsBulkResult.BulkOperationResultBuilder<String> builder, Iterator<ODataBatchResponseItem> iter, String itemPayload) {
        try {
            ODataBatchResponseItem responseEntity = iter.next();
            ODataResponse oDataResponse = (ODataResponse)responseEntity.next();
            builder.addItem(this.getBulkItemForDelete(oDataResponse, itemPayload));
        }
        catch (IllegalStateException | NoSuchElementException exception) {
            if (ELEMENT_NOT_FOUND_EXCEPTION_MESSAGE.equals(exception.getMessage()) || NO_ITEM_FOUND_EXCEPTION_MESSAGE.equals(exception.getMessage())) {
                ErrorResponse oDataResponse = new ErrorResponse(400, "Some delete requests were rejected because the ID was missing or not well formatted.");
                builder.addItem(this.getBulkItemForDelete(oDataResponse, itemPayload));
            }
            throw exception;
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            ErrorResponse oDataResponse = new ErrorResponse(batchResponse.getStatusCode(), batchResponse.getStatusMessage());
            builder.addItem(this.getBulkItemForDelete(oDataResponse, itemPayload));
        }
    }

    private void updateAfterDelete(List<String> rejectedRequests, String entitySetName, BatchManager payloadManager, String entityId, boolean continueOnError) {
        try {
            ODataBatchableRequest updateRequest = OperationUtil.deleteEntityForBatchRequest((ODataClient)this.getBatchClient(), this.getApiEndpoint(), entitySetName, entityId);
            if (continueOnError || rejectedRequests.isEmpty()) {
                ODataChangeset changeset = payloadManager.addChangeset();
                changeset.addRequest(updateRequest);
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            rejectedRequests.add(entityId);
        }
    }

    private void fromString(List<String> rejectedRequests, String entityId) {
        try {
            UUID.fromString(entityId);
        }
        catch (Exception e) {
            logger.debug(e.getLocalizedMessage(), (Throwable)e);
            rejectedRequests.add(entityId);
        }
    }

    private DynamicsBulkItem.BulkItemBuilder<String> getBulkItemForDelete(ODataResponse item, String payload) {
        boolean isSuccesful = item.getStatusCode() == 204;
        DynamicsBulkItem.BulkItemBuilder<String> bulkItemBuilder = DynamicsBulkItem.builder();
        bulkItemBuilder.setSuccessful(isSuccesful);
        bulkItemBuilder.setPayload(payload);
        int statusCode = item.getStatusCode();
        bulkItemBuilder.setStatusCode(String.valueOf(item.getStatusCode()));
        if (statusCode >= HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode()) {
            InputStream odataRawResponse = item.getRawResponse();
            if (odataRawResponse != null) {
                bulkItemBuilder.setException(new Exception(IOUtils.toString((InputStream)odataRawResponse)));
            } else {
                bulkItemBuilder.setException(new Exception(item.getStatusMessage()));
            }
        }
        if (isSuccesful) {
            bulkItemBuilder.setRecordId(UUID.fromString(payload));
        } else {
            bulkItemBuilder.setMessage(item.getStatusMessage());
        }
        return bulkItemBuilder;
    }

    private Optional<String> getErrorMessage(ODataBatchResponse batchResponse) {
        Iterator responseItem;
        ODataBatchResponseItem responseEntity;
        if (batchResponse.getStatusCode() >= HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode() && (responseEntity = (ODataBatchResponseItem)(responseItem = batchResponse.getBody()).next()).hasNext()) {
            InputStream odataRawResponse;
            ODataResponse oDataResponse = (ODataResponse)responseEntity.next();
            String exceptionMessage = null;
            if (Integer.parseInt(String.valueOf(oDataResponse.getStatusCode())) >= HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode() && (odataRawResponse = oDataResponse.getRawResponse()) != null) {
                exceptionMessage = IOUtils.toString((InputStream)odataRawResponse);
            }
            Type resultType = new TypeToken<Map<String, Object>>(){}.getType();
            Map responseMessage = (Map)this.gson.fromJson(exceptionMessage, resultType);
            Map error = (Map)responseMessage.get("error");
            String errorMessage = String.valueOf(error.get("message"));
            return Optional.of(errorMessage);
        }
        return Optional.empty();
    }

    public void disassociateEntities(String logicalName, Map<String, Object> attributes) {
        this.execute(() -> {
            try {
                String entityId = OperationUtil.extractEntityId(attributes);
                List entityAttributes = OperationUtil.validateAttributes(attributes, List.class);
                String entitySetName = OperationUtil.getEntitySetNameByLogicalName(logicalName, this);
                ODataBatchRequest request = this.getBatchClient().getBatchRequestFactory().getBatchRequest(this.getApiEndpoint());
                BatchManager payloadManager = (BatchManager)request.payloadManager();
                ODataChangeset changeset = payloadManager.addChangeset();
                for (String relatedEntityKey : entityAttributes) {
                    changeset.addRequest((ODataBatchableRequest)this.getBatchClient().getCUDRequestFactory().getDeleteRequest(this.getBatchClient().newURIBuilder(this.getApiEndpoint()).appendEntitySetSegment(entitySetName).appendKeySegment((Object)UUID.fromString(entityId)).appendNavigationSegment(relatedEntityKey).appendRefSegment().build()));
                }
                Future oDataBatchResponseFuture = payloadManager.getAsyncResponse();
                ODataBatchResponse batchResponse = (ODataBatchResponse)oDataBatchResponseFuture.get(this.getReadTimeout(), TimeUnit.MILLISECONDS);
                Iterator batchResponseIterator = batchResponse.getBody();
                ODataBatchResponseItem deleteChangesetResponse = (ODataBatchResponseItem)batchResponseIterator.next();
                while (deleteChangesetResponse.hasNext()) {
                    ODataDeleteResponse deleteResponse = (ODataDeleteResponse)deleteChangesetResponse.next();
                    if (deleteResponse.getStatusCode() == 204) continue;
                    throw new EntityDisassociationFailedException();
                }
            }
            catch (UnauthorizedAccessException e) {
                throw new Dynamics365ConnectionException(e.getCause());
            }
            catch (ExecutionException | TimeoutException e) {
                throw new ModuleException((ErrorTypeDefinition)Dynamics365ErrorType.TIMEOUT, (Throwable)e);
            }
            return null;
        });
    }

    private ODataBatchableRequest getBatchRequestForUpdate(String entitySetName, Map<String, Object> entityForUpdate, String encoding) {
        DynamicsBatchClient client = this.getBatchClient();
        String entityId = OperationUtil.extractEntityId(entityForUpdate);
        Map entityAttributes = OperationUtil.validateAttributes(entityForUpdate, Map.class);
        URI uri = client.newURIBuilder(this.getApiEndpoint()).appendEntitySetSegment(entitySetName).appendKeySegment((Object)UUID.fromString(entityId)).build();
        ClientObjectFactory objectFactory = client.getObjectFactory();
        ClientEntity entity = OperationUtil.getClientEntity(objectFactory, entityAttributes);
        DynamicsODataEntityUpdateRequest<ClientEntity> request = new DynamicsODataEntityUpdateRequest<ClientEntity>((ODataClient)client, HttpMethod.PATCH, uri, entity);
        OperationUtil.addHeadersToRequest(encoding, request);
        return request;
    }

    private <T> void processErrorFromServer(ODataBatchResponse entireBatch, DynamicsBulkResult.BulkOperationResultBuilder<T> builder, T itemPayload, ODataResponse lastOdataBatchResponse) {
        builder.addItem(OperationUtil.getBulkItem(Optional.of(entireBatch).filter(batch -> batch.getStatusCode() != 200).map(ErrorResponse::new).orElse(new ErrorResponse(lastOdataBatchResponse)), itemPayload));
    }

    private int getReadTimeout() {
        int readTimeout = this.getDynamicsHttpClientFactory().getReqConfig().getSocketTimeout();
        return readTimeout != 0 ? readTimeout : 30000;
    }

    public Map<String, Object> getEntityTypes() {
        return this.execute(() -> this.get("EntityDefinitions?$select=LogicalName"));
    }

    public Map<String, Object> getLogicalNames(String ... additionalFieldsToSelect) {
        return this.execute(() -> {
            if (additionalFieldsToSelect != null) {
                StringJoiner path = new StringJoiner(",");
                for (String fieldToSelect : additionalFieldsToSelect) {
                    path.add(fieldToSelect);
                }
                return this.get("EntityDefinitions?$select=LogicalName," + path.toString());
            }
            return null;
        });
    }

    public Map<String, Object> getEntityAttributesByLogicalName(String entityLogicalName) {
        return this.execute(() -> this.get(String.format("EntityDefinitions(LogicalName='%s')/Attributes", entityLogicalName)));
    }

    public Map<String, Object> getEntitySetNames() {
        return this.execute(() -> this.get("EntityDefinitions?$select=EntitySetName"));
    }

    public Map<String, Object> getMetadata(String encoding) {
        return this.execute(() -> {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", MediaType.APPLICATION_XML.toString());
            return this.invoke(String.format("%s$metadata", this.getApiEndpoint()), InvokeHttpMethod.GET, headers, null, encoding);
        });
    }

    public String getLogicalNameByEntitySetName(String entitySetName) {
        return this.execute(() -> Optional.ofNullable(((List)this.get("EntityDefinitions/?$select=LogicalName,EntitySetName").get("value")).stream().filter(value -> ((String)value.get("EntitySetName")).equalsIgnoreCase(entitySetName.substring(0, entitySetName.indexOf("?")))).map(value -> (String)value.get("LogicalName")).findFirst().orElse(null)).filter(StringUtils::isNotBlank).orElseThrow(() -> new LogicalNameNotFoundException(entitySetName)));
    }

    private /* synthetic */ void lambda$null$10(HttpRequestBase requestBase, String key) {
        requestBase.addHeader(key, String.format("Bearer %s", this.getAccessToken()));
    }

    private static /* synthetic */ void lambda$null$9(HttpRequestBase requestBase, String encoding, String key) {
        requestBase.addHeader(key, MediaType.APPLICATION_JSON.withCharset(Charset.forName(encoding)).toString());
    }
}

