/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils;

import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.DynamicsCRMConnection;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.error.DynamicsCRMErrorType;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.error.exception.DynamicsCRMException;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.EntityCollection;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.FetchExpression;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.services.IOrganizationServiceRetrieveMultipleOrganizationServiceFaultFaultFaultMessage;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils.DynamicsCrmUtil;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils.PagingHelper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetrieveMultipleByQueryPagingDelegate
implements PagingProvider<DynamicsCRMConnection, Map<String, Object>> {
    private static final Logger log = LoggerFactory.getLogger(RetrieveMultipleByQueryPagingDelegate.class);
    private int itemsPerPage;
    private int singlePageNumber;
    private EntityCollection lastEntityCollection;
    private String nextQuery;
    private boolean firstPageRequest = true;
    private Integer totalRecordsCount;
    private boolean callExecuteQueryOnNextGetPage = true;

    public RetrieveMultipleByQueryPagingDelegate(String query, int itemsPerPage, int singlePageNumber) {
        this.nextQuery = query;
        this.itemsPerPage = itemsPerPage;
        this.singlePageNumber = singlePageNumber;
        if (PagingHelper.isNativeQueryCurrentPageNumber(query) && PagingHelper.getNativeQueryCurrentPageNumber(query) > 0) {
            this.singlePageNumber = PagingHelper.getNativeQueryCurrentPageNumber(query);
        }
    }

    public List<Map<String, Object>> getPage(DynamicsCRMConnection connection) {
        log.debug("Requesting new page");
        if (this.callExecuteQueryOnNextGetPage && this.nextQuery == null) {
            log.debug("Next query is null - do not retrieve more pages.");
            return Collections.emptyList();
        }
        if (!this.callExecuteQueryOnNextGetPage) {
            this.callExecuteQueryOnNextGetPage = true;
        } else {
            this.executeQuery(connection);
        }
        log.debug("Requested new page");
        List<Map<String, Object>> mapEntityCollectionToMapCollection = DynamicsCrmUtil.mapEntityCollectionToMapCollection(this.lastEntityCollection);
        return mapEntityCollectionToMapCollection == null || mapEntityCollectionToMapCollection.isEmpty() ? Collections.emptyList() : mapEntityCollectionToMapCollection;
    }

    public Optional<Integer> getTotalResults(DynamicsCRMConnection connection) {
        if (this.totalRecordsCount == null) {
            this.executeQuery(connection);
            this.callExecuteQueryOnNextGetPage = false;
        }
        return Optional.of(this.totalRecordsCount);
    }

    public boolean useStickyConnections() {
        return true;
    }

    public void close(DynamicsCRMConnection connection) {
        this.lastEntityCollection = null;
        this.nextQuery = null;
    }

    private void executeQuery(DynamicsCRMConnection connection) {
        this.buildNativeQuery();
        log.debug("Native Query: " + this.nextQuery);
        this.buildEntities(connection);
        if (this.singlePageNumber <= 0 && this.lastEntityCollection.getMoreRecords().booleanValue()) {
            log.debug("Using Paging Cookie for next request");
            this.nextQuery = PagingHelper.setNativeQueryPagingCookie(this.nextQuery, this.lastEntityCollection.getPagingCookie());
            if (PagingHelper.isNativeQueryTotalRecordCount(this.nextQuery)) {
                this.nextQuery = PagingHelper.removeNativeQueryTotalRecordCount(this.nextQuery);
            }
            int currentPageNumber = PagingHelper.getNativeQueryCurrentPageNumber(this.nextQuery);
            this.nextQuery = PagingHelper.setNativeQueryCurrentPageNumber(this.nextQuery, ++currentPageNumber);
            log.debug("Set next page to " + currentPageNumber);
        } else {
            log.debug("No more pages to retrieve");
            this.nextQuery = null;
        }
    }

    private void buildNativeQuery() {
        if (this.firstPageRequest) {
            this.firstPageRequest = false;
            this.nextQuery = PagingHelper.setNativeQueryTotalRecordCount(this.nextQuery);
            if (this.singlePageNumber > 0) {
                this.nextQuery = PagingHelper.setNativeQueryCurrentPageNumber(this.nextQuery, this.singlePageNumber);
            } else if (!PagingHelper.isNativeQueryCurrentPageNumber(this.nextQuery)) {
                this.nextQuery = PagingHelper.setNativeQueryCurrentPageNumber(this.nextQuery, 1);
                log.debug("Set page to 1");
            }
            if (!PagingHelper.isNativeQueryCurrentPageSize(this.nextQuery) && this.itemsPerPage > 0) {
                this.nextQuery = PagingHelper.setNativeQueryCurrentPageSize(this.nextQuery, this.itemsPerPage);
                log.debug("Set fetchSize (items per page) to " + this.itemsPerPage);
            }
        }
    }

    private void buildEntities(DynamicsCRMConnection connection) {
        FetchExpression query = new FetchExpression();
        query.setQuery(this.nextQuery);
        try {
            this.lastEntityCollection = connection.getSoapClient().retrieveMultiple(query);
            if (this.totalRecordsCount == null) {
                this.totalRecordsCount = this.lastEntityCollection.getTotalRecordCount();
            }
        }
        catch (IOrganizationServiceRetrieveMultipleOrganizationServiceFaultFaultFaultMessage e) {
            throw new DynamicsCRMException(DynamicsCRMErrorType.TRANSFORMATION, e);
        }
    }
}

