/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.source;

import com.mulesoft.connectors.microsoft.dynamics.crm.internal.datasense.RetrieveMetadataResolver;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.datasense.query.DynamicsCRMQueryTranslator;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.source.AbstractObjectTrigger;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.joda.time.DateTime;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.dsql.Direction;
import org.mule.runtime.extension.api.dsql.EntityType;
import org.mule.runtime.extension.api.dsql.Field;
import org.mule.runtime.extension.api.runtime.source.PollContext;

@Alias(value="deleted-object", description="Listener for deleted objects.")
@MetadataScope(outputResolver=RetrieveMetadataResolver.class)
public class DeletedObject
extends AbstractObjectTrigger {
    private static final String WATERMARK_FIELD_DELETED = "createdon";
    private static final String DELETE_TYPE_CODE = "3";
    private static final String OPERATION_ATTRIBUTE = "operation";
    private static final String OBJECT_TYPE_CODE_ATTRIBUTE = "objecttypecode";
    private static final String AUDIT_TABLE = "audit";
    @Parameter
    @MetadataKeyId(value=RetrieveMetadataResolver.class)
    private String fieldType;

    @Override
    protected String getWatermarkField() {
        return WATERMARK_FIELD_DELETED;
    }

    public void poll(PollContext<Map<String, Object>, Serializable> pollContext) {
        this.retrieveEntities(pollContext, this.fieldType);
    }

    @Override
    protected String createQuery(PollContext<Map<String, Object>, Serializable> pollContext, String fieldType) {
        Optional watermarkValue = pollContext.getWatermark();
        watermarkValue.ifPresent(serializable -> {
            this.actualDate = DateTime.parse((String)String.valueOf(serializable));
        });
        List<Field> fields = this.getFields(AUDIT_TABLE);
        Field watermarkAsField = new Field(this.getWatermarkField(), fieldType);
        Field operationAsField = new Field(OPERATION_ATTRIBUTE, String.class.getSimpleName());
        Field objectTypeAsField = new Field(OBJECT_TYPE_CODE_ATTRIBUTE, String.class.getSimpleName());
        DynamicsCRMQueryTranslator translator = new DynamicsCRMQueryTranslator();
        String entityTypeCode = this.getEntityTypeCode(fieldType);
        Field compareField = fields.stream().filter(field -> field.getName().equals(this.getWatermarkField())).findFirst().get();
        EntityType entityType = new EntityType(AUDIT_TABLE);
        translator.translateBeginExpression();
        translator.translateTypes(entityType);
        translator.translateFields(fields);
        translator.translateComparison("gt", compareField, String.valueOf(this.actualDate));
        translator.translateAnd();
        translator.translateComparison("eq", operationAsField, DELETE_TYPE_CODE);
        translator.translateAnd();
        translator.translateComparison("eq", objectTypeAsField, entityTypeCode);
        translator.translateOrderByFields(Collections.singletonList(watermarkAsField), Direction.ASC);
        return translator.getTranslation();
    }

    @Override
    protected String getId(Map<String, Object> entity, String fieldType) {
        return super.getId(entity, AUDIT_TABLE);
    }
}

