/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.source;

import com.mulesoft.connectors.microsoft.dynamics.crm.internal.config.DynamicsCRMConfig;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.DynamicsCRMConnection;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.datasense.query.DynamicsCRMQueryTranslator;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.serialization.Guid;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.OrganizationResponse;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.ParameterCollection;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.services.IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.metadata.AttributeMetadata;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.metadata.EntityFilters;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.metadata.EntityMetadata;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.service.DynamicsCRMServiceImpl;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils.DynamicsCrmUtils;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils.ParameterCollectionBuilder;
import java.io.Serializable;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.joda.time.DateTime;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.dsql.Direction;
import org.mule.runtime.extension.api.dsql.EntityType;
import org.mule.runtime.extension.api.dsql.Field;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.PollContext;
import org.mule.runtime.extension.api.runtime.source.PollingSource;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractObjectTrigger
extends PollingSource<Map<String, Object>, Serializable> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractObjectTrigger.class);
    private static final DateTimeFormatter MULE_DATETIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH);
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Summary(value="Required date format is 'yyyy-MM-dd'T'HH:mm:ss'Z'")
    protected String since;
    protected DateTime actualDate;
    @Config
    protected DynamicsCRMConfig config;
    @Connection
    protected ConnectionProvider<DynamicsCRMConnection> connectionProvider;
    protected DynamicsCRMConnection connection;

    protected void doStart() throws MuleException {
        this.connection = (DynamicsCRMConnection)this.connectionProvider.connect();
        this.actualDate = this.since == null || this.since.isEmpty() ? DateTime.parse((String)LocalDateTime.now(Clock.systemUTC()).format(MULE_DATETIME_FORMAT)) : DateTime.parse((String)this.since);
    }

    protected void doStop() {
        this.connectionProvider.disconnect((Object)this.connection);
    }

    protected abstract String getWatermarkField();

    protected Serializable extractWatermark(Map<String, Object> entity) {
        return LocalDateTime.parse(String.valueOf(entity.get(this.getWatermarkField())), MULE_DATETIME_FORMAT);
    }

    protected Result<Map<String, Object>, Serializable> toResult(Map<String, Object> entity) {
        return Result.builder().output(entity).build();
    }

    protected List<Field> getFields(String fieldType) {
        ArrayList<Field> fields = new ArrayList<Field>();
        EntityFilters filters = new EntityFilters();
        filters.getValues().add("Attributes");
        ParameterCollection reqParams = new ParameterCollectionBuilder().withKeyValue("EntityFilters", filters).withKeyValue("MetadataId", this.createEmptyGuid()).withKeyValue("LogicalName", fieldType).withKeyValue("RetrieveAsIfPublished", true).build();
        OrganizationResponse response = null;
        try {
            response = this.connection.getSoapClient().execute(DynamicsCrmUtils.createOrganizationRequest("RetrieveEntity", reqParams));
        }
        catch (IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        assert (response != null);
        EntityMetadata metadata = (EntityMetadata)response.getResults().getKeyValuePairOfstringanyTypes().get(0).getValue();
        List<AttributeMetadata> listOfAttributes = metadata.getAttributes().getAttributeMetadatas();
        listOfAttributes.forEach(attributeMetadata -> {
            if (attributeMetadata.getIsValidForRead().booleanValue()) {
                fields.add(new Field(attributeMetadata.getLogicalName(), attributeMetadata.getEntityLogicalName()));
            }
        });
        return fields;
    }

    protected String createQuery(PollContext<Map<String, Object>, Serializable> pollContext, String fieldType) {
        Optional watermarkValue = pollContext.getWatermark();
        watermarkValue.ifPresent(serializable -> {
            this.actualDate = DateTime.parse((String)String.valueOf(serializable));
        });
        DynamicsCRMQueryTranslator translator = new DynamicsCRMQueryTranslator();
        List<Field> fields = this.getFields(fieldType);
        Field watermarkAsField = new Field(this.getWatermarkField(), fieldType);
        Field compareField = fields.stream().filter(field -> field.getName().equals(this.getWatermarkField())).findFirst().get();
        EntityType entityType = new EntityType(fieldType);
        translator.translateBeginExpression();
        translator.translateTypes(entityType);
        translator.translateFields(fields);
        translator.translateComparison("gt", compareField, String.valueOf(this.actualDate));
        translator.translateOrderByFields(Arrays.asList(watermarkAsField), Direction.ASC);
        return translator.getTranslation();
    }

    String getEntityTypeCode(String logicalName) {
        EntityFilters filters = new EntityFilters();
        filters.getValues().add("Entity");
        ParameterCollection reqParams = new ParameterCollectionBuilder().withKeyValue("EntityFilters", filters).withKeyValue("MetadataId", this.createEmptyGuid()).withKeyValue("LogicalName", logicalName).withKeyValue("RetrieveAsIfPublished", true).build();
        OrganizationResponse response = null;
        try {
            response = this.connection.getSoapClient().execute(DynamicsCrmUtils.createOrganizationRequest("RetrieveEntity", reqParams));
        }
        catch (IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        assert (response != null);
        EntityMetadata metadata = (EntityMetadata)response.getResults().getKeyValuePairOfstringanyTypes().get(0).getValue();
        return String.valueOf(metadata.getObjectTypeCode());
    }

    protected void retrieveEntities(PollContext<Map<String, Object>, Serializable> pollContext, String fieldType) {
        String query = this.createQuery(pollContext, fieldType);
        DynamicsCRMServiceImpl service = new DynamicsCRMServiceImpl(this.config, this.connection);
        int itemsPerPage = 50;
        PagingProvider<DynamicsCRMConnection, Map<String, Object>> pagingDelegate = service.retrieveMultipleByQuery(query, itemsPerPage, -1);
        for (int totalResults = 0; totalResults < (Integer)pagingDelegate.getTotalResults((Object)this.connection).get(); totalResults += itemsPerPage) {
            pagingDelegate.getPage((Object)this.connection).forEach(entity -> pollContext.accept(item -> item.setResult(this.toResult((Map<String, Object>)entity)).setWatermark(this.extractWatermark((Map<String, Object>)entity)).setId(this.getId((Map<String, Object>)entity, fieldType))));
        }
    }

    protected String getId(Map<String, Object> entity, String fieldType) {
        return (String)entity.get(fieldType + "id");
    }

    private Guid createEmptyGuid() {
        Guid guid = new Guid();
        guid.setValue("00000000-0000-0000-0000-000000000000");
        return guid;
    }

    public void onRejectedItem(Result<Map<String, Object>, Serializable> result, SourceCallbackContext sourceCallbackContext) {
    }
}

