/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.policies.interceptors;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.interceptor.Soap12FaultInInterceptor;
import org.apache.cxf.interceptor.ClientFaultConverter;
import org.apache.cxf.message.Message;
import org.apache.cxf.staxutils.W3CDOMStreamReader;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JInInterceptor;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XrmFaultInterceptor
extends AbstractSoapInterceptor {
    private static final Log log = LogFactory.getLog(XrmFaultInterceptor.class);

    public XrmFaultInterceptor() {
        super("pre-protocol");
        this.addBefore(PolicyBasedWSS4JInInterceptor.class.getName());
    }

    public void handleMessage(SoapMessage arg0) {
    }

    public void handleFault(SoapMessage message) {
        Exception exception = (Exception)message.getContent(Exception.class);
        if (!(exception instanceof SoapFault)) {
            return;
        }
        if (!StringUtils.contains((CharSequence)exception.getMessage(), (CharSequence)"The signature or decryption was invalid")) {
            return;
        }
        XMLStreamReader reader = (XMLStreamReader)message.getContent(XMLStreamReader.class);
        if (reader == null) {
            return;
        }
        if (!(reader instanceof W3CDOMStreamReader)) {
            return;
        }
        W3CDOMStreamReader w3r = (W3CDOMStreamReader)reader;
        try {
            boolean isFaultMessage = this.isFaultMessage(w3r);
            if (isFaultMessage) {
                Soap12FaultInInterceptor soap12FaultInInterceptor = new Soap12FaultInInterceptor();
                soap12FaultInInterceptor.handleMessage(message);
                ClientFaultConverter clientFaultConverter = new ClientFaultConverter();
                clientFaultConverter.handleMessage((Message)message);
            }
        }
        catch (XMLStreamException e) {
            log.debug((Object)e);
        }
    }

    private boolean isFaultMessage(W3CDOMStreamReader w3r) throws XMLStreamException {
        while (w3r.hasNext()) {
            w3r.next();
            if (!w3r.getCurrentNode().getLocalName().equals("Body")) continue;
            NodeList l = w3r.getCurrentNode().getChildNodes();
            for (int i = 0; i < l.getLength(); ++i) {
                Node n = l.item(i);
                if (!n.getLocalName().equals("Fault")) continue;
                return true;
            }
        }
        return false;
    }
}

