/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.policies.interceptors;

import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.parameters.ProxySettingsParams;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online.MicrosoftOnlineAuthenticationPolicy;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online.MicrosoftOnlineSecurityHeaderInterceptor;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online.Office365ConnectionException;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online.Office365TokenRetriever;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online.RealmInfo;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.utils.DynamicsCrmConnectionUtils;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.utils.MessageUtils;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.security.assertors.XrmAuthenticationTypeAssertion;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils.DynamicsCrmConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import joptsimple.internal.Strings;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.EndpointReferenceUtils;
import org.apache.cxf.ws.addressing.VersionTransformer;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.trust.STSClient;
import org.apache.wss4j.policy.SP12Constants;
import org.apache.wss4j.policy.model.IssuedToken;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CrmAuthenticationPolicyOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Log log = LogFactory.getLog(CrmAuthenticationPolicyOutInterceptor.class);
    private final ProxySettingsParams proxySettingsParams;

    public CrmAuthenticationPolicyOutInterceptor(ProxySettingsParams proxySettingsParams) {
        super("prepare-send");
        this.addBefore("IssuedTokenOutInterceptor");
        this.proxySettingsParams = proxySettingsParams;
    }

    public void handleMessage(Message message) {
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        if (aim != null) {
            boolean disableCnCheck = MessageUtils.getContextualBoolean(message, "AuthenticationPolicy.DisableCnCheck", false);
            ArrayList<AssertionInfo> ais = new ArrayList<AssertionInfo>();
            Collection ais2011 = (Collection)aim.get((Object)DynamicsCrmConstants.AUTH_POLICY_2011);
            this.buildAssertionInfo(aim, ais, ais2011);
            for (AssertionInfo ai : ais) {
                XrmAuthenticationTypeAssertion authenticationPolicy = (XrmAuthenticationTypeAssertion)ai.getAssertion();
                if (authenticationPolicy != null && authenticationPolicy.getAuthenticationType() != null) {
                    log.debug((Object)("Authentication type from wsdl: " + authenticationPolicy.getAuthenticationType()));
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)Objects.requireNonNull(authenticationPolicy).getAuthenticationType(), (CharSequence)"Federation")) {
                    try {
                        String metadataWsdl = this.getMetadataWsdl(aim, ai);
                        if (metadataWsdl == null) {
                            return;
                        }
                        this.handleAuthTypeFederation(message, metadataWsdl, disableCnCheck);
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                        ai.setNotAsserted("Error when trying to configure conduit in STS Client: " + e.getMessage());
                        return;
                    }
                } else if (StringUtils.equalsIgnoreCase((CharSequence)authenticationPolicy.getAuthenticationType(), (CharSequence)"OnlineFederation")) {
                    this.handleAuthTypeOnlineFederation(message);
                } else if (StringUtils.equalsIgnoreCase((CharSequence)authenticationPolicy.getAuthenticationType(), (CharSequence)"ActiveDirectory")) {
                    this.handleAuthTypeActiveDirectory(message, ai, disableCnCheck);
                }
                ai.setAsserted(true);
            }
        }
    }

    private void handleAuthTypeFederation(Message message, String metadataWsdl, boolean disableCnCheck) throws EndpointException, BusException {
        String endpointName = this.getEndpointName(metadataWsdl);
        STSClient client = new STSClient((Bus)message.getExchange().get(Bus.class));
        client.setWsdlLocation(metadataWsdl);
        client.setEndpointQName(new QName("http://schemas.microsoft.com/ws/2008/06/identity/securitytokenservice", endpointName));
        client.setSendRenewing(false);
        client.setWspNamespace("http://schemas.xmlsoap.org/ws/2004/09/policy");
        message.put((Object)"security.sts.client", (Object)client);
        HTTPConduit conduit = (HTTPConduit)client.getClient().getConduit();
        DynamicsCrmConnectionUtils.setProxyConnection(conduit, this.proxySettingsParams);
        if (disableCnCheck) {
            DynamicsCrmConnectionUtils.disableCnCheck(conduit);
        }
    }

    private void handleAuthTypeOnlineFederation(Message message) {
        SecurityToken tok = (SecurityToken)MessageUtils.getContextualObject(message, "ws-security.token");
        if (tok == null || tok.isExpired() || tok.isAboutToExpire(30L)) {
            Bus bus = (Bus)message.getExchange().get(Bus.class);
            this.issueToken(message, bus);
        }
    }

    private void handleAuthTypeActiveDirectory(Message message, final AssertionInfo ai, final boolean disableCnCheck) {
        class CustomSTSClient
        extends STSClient {
            public CustomSTSClient(Bus b) {
                super(b);
            }

            protected void createClient() throws BusException, EndpointException {
                super.createClient();
                try {
                    HTTPConduit conduit = (HTTPConduit)this.getClient().getConduit();
                    DynamicsCrmConnectionUtils.setProxyConnection(conduit, CrmAuthenticationPolicyOutInterceptor.this.proxySettingsParams);
                    if (disableCnCheck) {
                        DynamicsCrmConnectionUtils.disableCnCheck(conduit);
                    }
                }
                catch (Exception e) {
                    log.error((Object)e);
                    ai.setNotAsserted("Error when trying to configure conduit in STS Client: " + e.getMessage());
                }
            }
        }
        message.put((Object)"security.sts.client", (Object)new CustomSTSClient((Bus)message.getExchange().get(Bus.class)));
    }

    private void buildAssertionInfo(AssertionInfoMap aim, Collection<AssertionInfo> ais, Collection<AssertionInfo> ais2011) {
        Collection ais2012;
        if (ais2011 != null) {
            ais.addAll(ais2011);
        }
        if ((ais2012 = (Collection)aim.get((Object)DynamicsCrmConstants.AUTH_POLICY_2012)) != null) {
            ais.addAll(ais2012);
        }
    }

    private String getMetadataWsdl(AssertionInfoMap aim, AssertionInfo ai) {
        Iterator iterator;
        String metadataWsdl = "";
        Collection issuedTokenAssertions = (Collection)aim.get((Object)SP12Constants.ISSUED_TOKEN);
        if (issuedTokenAssertions != null && !issuedTokenAssertions.isEmpty() && (iterator = issuedTokenAssertions.iterator()).hasNext()) {
            AssertionInfo issuedTokenAssertion = (AssertionInfo)iterator.next();
            IssuedToken issuedToken = (IssuedToken)issuedTokenAssertion.getAssertion();
            metadataWsdl = this.findMEXLocation(issuedToken.getIssuer());
        }
        if (Strings.isNullOrEmpty((String)metadataWsdl)) {
            ai.setNotAsserted("Unable to get Federation Metadata WSDL from CRM's Authentication Policy");
            return null;
        }
        log.debug((Object)("Found Federation Metadata WSDL from CRM's Authentication Policy: " + metadataWsdl));
        return metadataWsdl;
    }

    private String getEndpointName(String metadataWsdl) {
        String endpointName;
        try {
            Document doc = DynamicsCrmConnectionUtils.downloadUrlIntoDocument(metadataWsdl, this.proxySettingsParams);
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expr = xpath.compile("//*[local-name()='Address' and substring(text(), string-length(text()) - 36)='/adfs/services/trust/13/usernamemixed']");
            Node node = (Node)expr.evaluate(doc, XPathConstants.NODE);
            String[] parts = node.getParentNode().getParentNode().getAttributes().getNamedItem("binding").getTextContent().split(":");
            endpointName = parts.length > 1 ? parts[1] : parts[0];
            log.debug((Object)("Found '13/usernamemixed' endpoint in wsdl: " + endpointName));
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            endpointName = "UserNameWSTrustBinding_IWSTrust13Async1";
        }
        return endpointName;
    }

    private void issueToken(Message message, Bus bus) {
        RealmInfo realmInfo;
        log.info((Object)"Authenticating against Microsoft Online");
        Office365TokenRetriever tokenRetriever = (Office365TokenRetriever)MessageUtils.getContextualObject(message, "AuthenticationPolicy.OnlineTokenRetriever");
        String username = (String)MessageUtils.getContextualObject(message, "security.username");
        String password = (String)MessageUtils.getContextualObject(message, "security.password");
        try {
            realmInfo = tokenRetriever.getUserRealmInfo(username);
        }
        catch (Office365ConnectionException e) {
            throw new Fault((Throwable)e);
        }
        this.setRealmNamespaceType(message, realmInfo);
        PolicyEngine policyEngine = (PolicyEngine)bus.getExtension(PolicyEngine.class);
        MicrosoftOnlineAuthenticationPolicy onlineAuthenticationPolicy = (MicrosoftOnlineAuthenticationPolicy)MessageUtils.getContextualObject(message, "AuthenticationPolicy.OnlineAuthenticationPolicy");
        int authenticationRetries = (Integer)MessageUtils.getContextualObject(message, "AuthenticationPolicy.AuthenticationRetries");
        for (int i = 1; i <= authenticationRetries; ++i) {
            try {
                if ("Managed".equalsIgnoreCase(realmInfo.getNamespaceType())) {
                    policyEngine.setEnabled(true);
                    message.put((Object)"ws-security.token", (Object)tokenRetriever.getTokenFromOffice365(bus, username, password, onlineAuthenticationPolicy.getIssuerUri().toString(), onlineAuthenticationPolicy.getAppliesTo()));
                    break;
                }
                if ("LiveId".equalsIgnoreCase(realmInfo.getNamespaceType())) {
                    policyEngine.setEnabled(false);
                    bus.getOutInterceptors().add(new MicrosoftOnlineSecurityHeaderInterceptor(tokenRetriever.getTokenFromLiveId((String)MessageUtils.getContextualObject(message, "AuthenticationPolicy.OrganizationServiceUrl"), username, password, onlineAuthenticationPolicy)));
                    policyEngine.setEnabled(true);
                    break;
                }
                if (!"Federated".equalsIgnoreCase(realmInfo.getNamespaceType())) continue;
                policyEngine.setEnabled(true);
                SecurityToken adfsTokenForMicrosoftOnline = tokenRetriever.getTokenFromAdfs(bus, username, password, realmInfo.getMetadataUrl(), (String)MessageUtils.getContextualObject(message, "AuthenticationPolicy.PortName"), onlineAuthenticationPolicy.getMicrosoftOnlineIdentifier());
                SecurityToken microsoftOnlineTokenForCrm = tokenRetriever.getTokenFromMicrosoftOnline(bus, adfsTokenForMicrosoftOnline, onlineAuthenticationPolicy.getIssuerUri().toString(), onlineAuthenticationPolicy.getAppliesTo());
                message.put((Object)"ws-security.token", (Object)microsoftOnlineTokenForCrm);
                break;
            }
            catch (Exception e) {
                log.info((Object)"Error trying to authenticate against Microsoft Online.", (Throwable)e);
                if (i >= authenticationRetries) {
                    throw new Fault((Throwable)e);
                }
                log.info((Object)("Retries left: " + (authenticationRetries - i)));
            }
        }
    }

    private void setRealmNamespaceType(Message message, RealmInfo realmInfo) {
        if ("Unknown".equalsIgnoreCase(realmInfo.getNamespaceType())) {
            log.info((Object)"Realm info not provided - will try federated auth if custom sts provided");
            if (Strings.isNullOrEmpty((String)realmInfo.getMetadataUrl())) {
                String customMetadataUrl = (String)MessageUtils.getContextualObject(message, "AuthenticationPolicy.StsMetadataUrl");
                if (!Strings.isNullOrEmpty((String)customMetadataUrl)) {
                    realmInfo.setMetadataUrl(customMetadataUrl);
                    realmInfo.setNamespaceType("Federated");
                }
            } else {
                realmInfo.setNamespaceType("Federated");
            }
        }
    }

    private String findMEXLocation(EndpointReferenceType ref) {
        if (ref.getMetadata() != null && ref.getMetadata().getAny() != null) {
            for (Object any : ref.getMetadata().getAny()) {
                String addr;
                if (!(any instanceof Element) || (addr = this.findMEXLocation((Element)any)) == null) continue;
                return addr;
            }
        }
        return EndpointReferenceUtils.getAddress((EndpointReferenceType)ref);
    }

    private String findMEXLocation(Element ref) {
        Element el = DOMUtils.getFirstElement((Node)ref);
        while (el != null) {
            if (el.getLocalName().equals("Address") && VersionTransformer.isSupported((String)el.getNamespaceURI()) && "MetadataReference".equals(ref.getLocalName())) {
                return DOMUtils.getContent((Node)el);
            }
            String ad = this.findMEXLocation(el);
            if (ad != null) {
                return ad;
            }
            el = DOMUtils.getNextElement((Element)el);
        }
        return null;
    }
}

