/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online;

import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online.DeviceCredentials;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online.exception.DeviceRegistrationErrorCode;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online.exception.DeviceRegistrationFailedException;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils.HttpClientService;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.mule.runtime.core.api.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class DeviceIdManager {
    private static final Logger log = LoggerFactory.getLogger((String)DeviceIdManager.class.getName());
    private static final SecureRandom RandomInstance = new SecureRandom();

    public static DeviceCredentials registerDevice(HttpClientService httpClientService) throws SAXException, ParserConfigurationException, DeviceRegistrationFailedException, IOException, TimeoutException {
        return DeviceIdManager.registerDevice(UUID.randomUUID(), httpClientService);
    }

    public static DeviceCredentials registerDevice(UUID applicationId, HttpClientService httpClientService) throws SAXException, ParserConfigurationException, DeviceRegistrationFailedException, IOException, TimeoutException {
        if (applicationId == null) {
            throw new NullPointerException("applicationId");
        }
        DeviceCredentials credentials = DeviceIdManager.generateCredentials();
        String puid = DeviceIdManager.executeRegistrationRequest("https://login.microsoftonline.com/ppsecure/DeviceAddCredential.srf", DeviceIdManager.createRegistrationEnvelope("11", applicationId, credentials.getDeviceName(), credentials.getPassword()), httpClientService);
        log.debug("Device Registration PUID: " + puid);
        return credentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String createRegistrationEnvelope(String prefix, UUID applicationId, String deviceName, String password) {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        StringWriter envelope = new StringWriter();
        XMLStreamWriter xml = null;
        try {
            xml = factory.createXMLStreamWriter(envelope);
            xml.writeStartElement("DeviceAddRequest");
            xml.writeStartElement("ClientInfo");
            xml.writeAttribute("name", applicationId.toString());
            xml.writeAttribute("version", "1.0");
            xml.writeEndElement();
            xml.writeStartElement("Authentication");
            xml.writeStartElement("Membername");
            xml.writeCharacters(prefix + deviceName);
            xml.writeEndElement();
            xml.writeStartElement("Password");
            xml.writeCharacters(password);
            xml.writeEndElement();
            xml.writeEndElement();
            xml.writeEndElement();
        }
        catch (XMLStreamException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (xml != null) {
                try {
                    xml.flush();
                    xml.close();
                }
                catch (XMLStreamException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return envelope.toString();
    }

    private static String executeRegistrationRequest(String url, String soapEnvelope, HttpClientService httpClientService) throws SAXException, ParserConfigurationException, DeviceRegistrationFailedException, IOException, TimeoutException {
        InputStream response = null;
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/soap+xml; charset=UTF-8");
            response = httpClientService.sendPost(url, soapEnvelope, headers, null);
            return DeviceIdManager.parseRegistrationResponse(IOUtils.toString((InputStream)response), false);
        }
        catch (IOException | TimeoutException e) {
            DeviceIdManager.parseRegistrationResponse(IOUtils.toString(response), true);
            throw e;
        }
    }

    private static String parseRegistrationResponse(String responseBody, boolean isFailure) throws SAXException, IOException, ParserConfigurationException, DeviceRegistrationFailedException {
        if (responseBody != null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(responseBody);
            document.getDocumentElement().normalize();
            Element root = document.getDocumentElement();
            NodeList children = root.getChildNodes();
            return DeviceIdManager.parseChildrenNodes(children, isFailure);
        }
        return null;
    }

    private static String parseChildrenNodes(NodeList children, boolean isFailure) throws DeviceRegistrationFailedException {
        String errorSubCode = null;
        DeviceRegistrationErrorCode errorCode = null;
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().toUpperCase().equals("PUID")) {
                return node.getTextContent();
            }
            if (!isFailure) continue;
            errorCode = DeviceIdManager.getErrorCode(node);
            errorSubCode = DeviceIdManager.getErrorSubcode(node);
        }
        if (isFailure) {
            throw new DeviceRegistrationFailedException(errorCode, errorSubCode);
        }
        return null;
    }

    private static String getErrorSubcode(Node node) {
        String errorSubCode = null;
        if (node.getNodeName().toUpperCase().equals("ERRORSUBCODE")) {
            errorSubCode = node.getTextContent();
        }
        return errorSubCode;
    }

    private static DeviceRegistrationErrorCode getErrorCode(Node node) {
        DeviceRegistrationErrorCode errorCode = null;
        if (node.getNodeName().toUpperCase().equals("ERROR")) {
            errorCode = DeviceRegistrationErrorCode.UNKNOWN;
            NamedNodeMap attributes = node.getAttributes();
            String codeLabel = attributes.getNamedItem("Code").getTextContent();
            if (codeLabel != null && codeLabel.startsWith("dc")) {
                int code = Integer.parseInt(codeLabel.substring(2));
                errorCode = DeviceIdManager.translateErrorCode(code);
            }
        }
        return errorCode;
    }

    private static DeviceCredentials generateCredentials() {
        String deviceName = DeviceIdManager.generateRandomString("0123456789abcdefghijklmnopqrstuvqxyz", 24);
        String devicePassword = DeviceIdManager.generateRandomString("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^*()-_=+; ,./?`~", 24);
        return new DeviceCredentials(deviceName, devicePassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String generateRandomString(String characterSet, int count) {
        char[] value = new char[count];
        char[] set = characterSet.toCharArray();
        SecureRandom secureRandom = RandomInstance;
        synchronized (secureRandom) {
            for (int i = 0; i < count; ++i) {
                value[i] = set[RandomInstance.nextInt(set.length)];
            }
        }
        return new String(value);
    }

    private static DeviceRegistrationErrorCode translateErrorCode(int errorCode) {
        DeviceRegistrationErrorCode code;
        switch (errorCode) {
            case 0: {
                code = DeviceRegistrationErrorCode.UNKNOWN;
                break;
            }
            case 1: {
                code = DeviceRegistrationErrorCode.INTERFACE_DISABLED;
                break;
            }
            case 3: {
                code = DeviceRegistrationErrorCode.INVALID_REQUEST_FORMAT;
                break;
            }
            case 4: {
                code = DeviceRegistrationErrorCode.UNKNOWN_CLIENT_VERSION;
                break;
            }
            case 6: {
                code = DeviceRegistrationErrorCode.BLANK_PASSWORD;
                break;
            }
            case 7: {
                code = DeviceRegistrationErrorCode.MISSING_DEVICE_USER_NAME_OR_PASSWORD;
                break;
            }
            case 8: {
                code = DeviceRegistrationErrorCode.INVALID_PARAMETER_SYNTAX;
                break;
            }
            case 11: {
                code = DeviceRegistrationErrorCode.INTERFACE_DISABLED;
                break;
            }
            case 13: {
                code = DeviceRegistrationErrorCode.DEVICE_ALREADY_EXISTS;
                break;
            }
            default: {
                code = DeviceRegistrationErrorCode.UNKNOWN;
            }
        }
        return code;
    }

    private final class LiveIdConstants {
        public static final String REGISTRATION_ENDPOINT_URI = "https://login.microsoftonline.com/ppsecure/DeviceAddCredential.srf";
        public static final String DEVICE_PREFIX = "11";
        public static final String VALID_DEVICE_NAME_CHARACTERS = "0123456789abcdefghijklmnopqrstuvqxyz";
        public static final int DEVICE_NAME_LENGTH = 24;
        public static final String VALID_DEVICE_PASSWORD_CHARACTERS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^*()-_=+; ,./?`~";
        public static final int DEVICE_PASSWORD_LENGTH = 24;

        private LiveIdConstants() {
        }
    }
}

