/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.providers;

import com.mulesoft.connectors.commons.template.connection.provider.ConnectorConnectionProvider;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.DynamicsCRMConnection;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.parameters.AdvancedParams;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.parameters.NtlmCredentials;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.parameters.ProxySettingsParams;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.service.connection.soap.NtlmSoapClientProvider;
import javax.inject.Inject;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.connection.PoolingConnectionProvider;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.http.api.HttpService;

@Alias(value="ntlm")
public class NtlmConnectionProvider
implements PoolingConnectionProvider<DynamicsCRMConnection>,
ConnectorConnectionProvider<DynamicsCRMConnection> {
    @Inject
    private HttpService httpService;
    @Parameter
    @Summary(value="Username to connect to Dynamics CRM")
    String username;
    @Parameter
    @Summary(value="The Windows password to connect to Dynamics NAV")
    @Password
    String password;
    @Parameter
    @Summary(value="Base URL where the SOAP services are exposed in the form _https://<Server>:<WebServicePort>/<ServerInstance>/WS_. Example: https://hostname:7047/DynamicsNAV90/WS")
    String organizationServiceUrl;
    @Parameter
    @Optional
    @Summary(value="Disable SSL certificate validation")
    protected boolean disableCnCheck;
    @ParameterGroup(name="Advanced")
    @Placement(order=2)
    private AdvancedParams advancedParams;
    @ParameterGroup(name="Proxy")
    @Placement(order=4)
    private ProxySettingsParams proxySettingsParams;
    @Parameter
    @Placement(order=4)
    @Optional
    @Summary(value="Gateway Router Service Address.")
    String gatewayRouterServiceAddress;

    public DynamicsCRMConnection connect() throws ConnectionException {
        if (StringUtils.isBlank((String)this.proxySettingsParams.getProxyHost()) && System.getProperties().containsKey("http.proxyHost") && System.getProperties().containsKey("http.proxyPort")) {
            this.proxySettingsParams.setProxyHost(System.getProperty("http.proxyHost"));
            this.proxySettingsParams.setProxyPort(Integer.parseInt(System.getProperty("http.proxyPort")));
        }
        NtlmCredentials credentials = new NtlmCredentials(this.organizationServiceUrl, this.username, this.password, this.disableCnCheck, this.advancedParams, this.proxySettingsParams, this.gatewayRouterServiceAddress);
        NtlmSoapClientProvider soapClientProvider = new NtlmSoapClientProvider(credentials, false, this.httpService, new WebServiceFeature[]{new AddressingFeature(true, false)});
        return new DynamicsCRMConnection(soapClientProvider.createSoapClient());
    }

    public void disconnect(DynamicsCRMConnection connectorConnection) {
        connectorConnection.disconnect();
    }

    public ConnectionValidationResult validate(DynamicsCRMConnection connectorConnection) {
        try {
            connectorConnection.validate();
            return ConnectionValidationResult.success();
        }
        catch (Exception e) {
            return ConnectionValidationResult.failure((String)e.getMessage(), (Exception)e);
        }
    }
}

