/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection;

import com.mulesoft.connectors.commons.template.connection.ConnectorConnection;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.parameters.ConnectorErrorType;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.error.exception.DynamicsCRMException;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.services.IOrganizationService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.EndpointImpl;
import org.apache.cxf.frontend.ClientProxy;

public class DynamicsCRMConnection
implements ConnectorConnection {
    private static final Log log = LogFactory.getLog(DynamicsCRMConnection.class);
    private IOrganizationService soapClient;

    public DynamicsCRMConnection(IOrganizationService soapClient) {
        this.soapClient = soapClient;
    }

    public void disconnect() {
        try {
            Client cxfClient = ClientProxy.getClient((Object)this.soapClient);
            ((EndpointImpl)cxfClient.getEndpoint()).getBus().shutdown(false);
            cxfClient.destroy();
        }
        catch (Exception e) {
            log.debug((Object)"Error closing cxf soapClient", (Throwable)e);
        }
        finally {
            this.soapClient = null;
        }
    }

    public void validate() {
        if (this.soapClient == null) {
            throw new DynamicsCRMException("Invalid session!", ConnectorErrorType.CONNECTIVITY);
        }
    }

    public IOrganizationService getSoapClient() {
        return this.soapClient;
    }
}

