/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.service.connection.soap;

import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.parameters.KerberosCredentials;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.utils.XrmSpnegoClientAction;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.error.DynamicsCRMErrorType;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.error.exception.DynamicsCRMException;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.services.IOrganizationService;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.service.connection.soap.DynamicsCRMSoapClientProvider;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils.ExceptionUtilsCRM;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Arrays;
import javax.net.ssl.SSLHandshakeException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceFeature;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.EndpointImpl;
import org.apache.cxf.frontend.ClientProxy;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.http.api.HttpService;

public class KerberosSoapClientProvider
extends DynamicsCRMSoapClientProvider {
    private KerberosCredentials kerberosCredentials;

    public KerberosSoapClientProvider(KerberosCredentials credentials, boolean policyEngineEnabled, HttpService httpService, WebServiceFeature ... features) throws ConnectionException {
        super(credentials, policyEngineEnabled, httpService, features);
        this.kerberosCredentials = credentials;
    }

    @Override
    protected void testClientConnectivity(IOrganizationService client, String organizationServiceUrl) {
        try {
            this.callSimpleQueryToTestConnection(client);
        }
        catch (Exception e) {
            SSLHandshakeException sslHandshakeException = ExceptionUtilsCRM.getDeepestOccurenceOfType(e, SSLHandshakeException.class);
            if (sslHandshakeException != null) {
                throw new DynamicsCRMException("SSL certificate error when connecting to: " + organizationServiceUrl, DynamicsCRMErrorType.INVALID_CERTIFICATE, e);
            }
            SocketTimeoutException socketTimeoutException = ExceptionUtilsCRM.getDeepestOccurenceOfType(e, SocketTimeoutException.class);
            if (socketTimeoutException != null) {
                throw new DynamicsCRMException("Connection/read timeout! Consider adjusting the connection/read timeout value", DynamicsCRMErrorType.CONNECTIVITY, e);
            }
            throw new DynamicsCRMException("Unable to build the service client from: " + organizationServiceUrl, DynamicsCRMErrorType.CONNECTIVITY, e);
        }
    }

    @Override
    protected IOrganizationService createOrganizationServiceClient() throws ConnectionException {
        URL organizationServiceWsdlUrl;
        try {
            organizationServiceWsdlUrl = new URL(new URL(this.kerberosCredentials.getOrganizationServiceUrl() + "?wsdl"), "", new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL url) throws IOException {
                    URL target = new URL(url.toString());
                    URLConnection connection = target.openConnection();
                    if (KerberosSoapClientProvider.this.kerberosCredentials.getAdvancedParams().getConnectionTimeout() != null) {
                        connection.setConnectTimeout(KerberosSoapClientProvider.this.kerberosCredentials.getAdvancedParams().getConnectionTimeout());
                    }
                    if (KerberosSoapClientProvider.this.kerberosCredentials.getAdvancedParams().getReadTimeout() != null) {
                        connection.setReadTimeout(KerberosSoapClientProvider.this.kerberosCredentials.getAdvancedParams().getReadTimeout());
                    }
                    return connection;
                }

                @Override
                protected URLConnection openConnection(URL url, Proxy proxy) throws IOException {
                    URL target = new URL(url.toString());
                    URLConnection connection = target.openConnection(proxy);
                    if (KerberosSoapClientProvider.this.kerberosCredentials.getAdvancedParams().getConnectionTimeout() != null) {
                        connection.setConnectTimeout(KerberosSoapClientProvider.this.kerberosCredentials.getAdvancedParams().getConnectionTimeout());
                    }
                    if (KerberosSoapClientProvider.this.kerberosCredentials.getAdvancedParams().getReadTimeout() != null) {
                        connection.setReadTimeout(KerberosSoapClientProvider.this.kerberosCredentials.getAdvancedParams().getReadTimeout());
                    }
                    return connection;
                }
            });
        }
        catch (MalformedURLException e) {
            throw new DynamicsCRMException("Malformed organization service url: " + this.kerberosCredentials.getOrganizationServiceUrl(), DynamicsCRMErrorType.INVALID_URL, e);
        }
        this.getOrganizationServiceWsdl(organizationServiceWsdlUrl);
        IOrganizationService client = this.getNewClientInstance(organizationServiceWsdlUrl, true, new WebServiceFeature[0]);
        Client cxfClient = ClientProxy.getClient((Object)client);
        Bus bus = ((EndpointImpl)cxfClient.getEndpoint()).getBus();
        bus.getProperties().put("soap.no.validate.parts", true);
        cxfClient.getRequestContext().put("set-jaxb-validation-event-handler", "false");
        cxfClient.getRequestContext().put("ws-security.spnego.client.action", new XrmSpnegoClientAction());
        cxfClient.getRequestContext().put("security.username", this.kerberosCredentials.getUsername());
        cxfClient.getRequestContext().put("security.password", this.kerberosCredentials.getAuthPassword());
        cxfClient.getRequestContext().put("security.callback-handler", new UsernamePasswordCallbackHandler(this.kerberosCredentials.getUsername(), this.kerberosCredentials.getAuthPassword()));
        cxfClient.getRequestContext().put("ws-security.kerberos.spn", this.kerberosCredentials.getSpn());
        cxfClient.getRequestContext().put("ws-security.kerberos.jaas.context", "Kerberos");
        BindingProvider provider = (BindingProvider)client;
        provider.getRequestContext().remove("javax.xml.ws.service.endpoint.address");
        return client;
    }

    private class UsernamePasswordCallbackHandler
    implements CallbackHandler {
        private String username;
        private String password;

        UsernamePasswordCallbackHandler(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) {
            Arrays.stream(callbacks).forEach(callback -> {
                if (callback instanceof NameCallback) {
                    ((NameCallback)callback).setName(this.username);
                } else if (callback instanceof PasswordCallback) {
                    ((PasswordCallback)callback).setPassword(this.password.toCharArray());
                }
            });
        }
    }
}

