/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.service.connection.soap;

import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.parameters.ClaimsCredentials;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.onpremise.PasswordCallbackHandler;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.error.DynamicsCRMErrorType;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.error.exception.DynamicsCRMException;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.services.IOrganizationService;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.service.connection.soap.DynamicsCRMSoapClientProvider;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils.ExceptionUtilsCRM;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import javax.net.ssl.SSLHandshakeException;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.http.api.HttpService;

public class ClaimsSoapClientProvider
extends DynamicsCRMSoapClientProvider {
    private final ClaimsCredentials claimsCredentials;

    public ClaimsSoapClientProvider(ClaimsCredentials credentials, boolean policyEngineEnabled, HttpService httpService, WebServiceFeature ... features) throws ConnectionException {
        super(credentials, policyEngineEnabled, httpService, features);
        this.claimsCredentials = credentials;
    }

    @Override
    protected IOrganizationService createOrganizationServiceClient() throws ConnectionException {
        return this.createServiceForClaims(this.claimsCredentials.getUsername(), this.claimsCredentials.getAuthPassword(), this.claimsCredentials.getOrganizationServiceUrl());
    }

    @Override
    protected void testClientConnectivity(IOrganizationService client, String organizationServiceUrl) throws ConnectionException {
        try {
            this.callSimpleQueryToTestConnection(client);
        }
        catch (Exception e) {
            SSLHandshakeException sslHandshakeException = ExceptionUtilsCRM.getFirstOccurenceOfType(e, SSLHandshakeException.class);
            if (sslHandshakeException != null) {
                String url = this.getUrlFromSslExceptionMessage(organizationServiceUrl, sslHandshakeException);
                throw new DynamicsCRMException("SSL certificate error when connecting to: " + url, DynamicsCRMErrorType.INVALID_CERTIFICATE, e);
            }
            SOAPFaultException faultException = ExceptionUtilsCRM.getFirstOccurenceOfType(e, SOAPFaultException.class);
            if (faultException != null) {
                if (StringUtils.contains((CharSequence)faultException.getMessage(), (CharSequence)"The security token could not be authenticated")) {
                    throw new ConnectionException("Invalid Token", (Throwable)faultException);
                }
                throw new DynamicsCRMException("Error when trying to access the service. This may be caused by incorrect credentials. Error details: " + faultException.getMessage(), DynamicsCRMErrorType.INVALID_CREDENTIALS, (Throwable)faultException);
            }
            throw new ConnectionException("Unable to query the service: " + organizationServiceUrl, (Throwable)e);
        }
    }

    private String getUrlFromSslExceptionMessage(String organizationServiceUrl, SSLHandshakeException sslHandshakeException) {
        String sslExceptionMessage = sslHandshakeException.getMessage();
        String url = organizationServiceUrl;
        Matcher matcher = urlPattern.matcher(sslExceptionMessage);
        while (matcher.find()) {
            int matchStart = matcher.start(1);
            int matchEnd = matcher.end() - 1;
            url = sslExceptionMessage.substring(matchStart, matchEnd);
        }
        return url;
    }

    private IOrganizationService createServiceForClaims(String username, String password, String organizationServiceUrl) throws ConnectionException {
        URL organizationServiceWsdlUrl;
        try {
            organizationServiceWsdlUrl = new URL(organizationServiceUrl + "?wsdl");
        }
        catch (MalformedURLException e) {
            throw new DynamicsCRMException("Malformed organization service url: " + this.claimsCredentials.getOrganizationServiceUrl(), DynamicsCRMErrorType.INVALID_URL, e);
        }
        this.getOrganizationServiceWsdl(organizationServiceWsdlUrl);
        IOrganizationService client = this.getNewClientInstance(organizationServiceWsdlUrl, true, new WebServiceFeature[0]);
        Client cxfClient = ClientProxy.getClient((Object)client);
        cxfClient.getRequestContext().put("set-jaxb-validation-event-handler", "false");
        cxfClient.getRequestContext().put("security.username", username);
        cxfClient.getRequestContext().put("security.callback-handler", new PasswordCallbackHandler(password));
        BindingProvider provider = (BindingProvider)client;
        provider.getRequestContext().remove("javax.xml.ws.service.endpoint.address");
        return client;
    }
}

