/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.commons.template.config.ConnectorConfig;
import com.mulesoft.connectors.commons.template.connection.ConnectorConnection;
import com.mulesoft.connectors.commons.template.service.DefaultConnectorService;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.config.DynamicsCRMConfig;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.DynamicsCRMConnection;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.datasense.retrievers.BaseContext;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.datasense.retrievers.attributes.AttributesBaseRetriever;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.datasense.retrievers.attributes.AttributesContext;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.datasense.retrievers.attributes.AttributesFactoryManager;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.datasense.retrievers.attributes.AttributesFactoryScope;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.datasense.retrievers.relationship.RelationshipsFactory;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.datasense.retrievers.relationship.RelationshipsRetriever;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.error.DynamicsCRMErrorType;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.error.exception.DynamicsCRMException;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model._07.system_collections.KeyValuePairOfstringanyType;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.contracts.LoseOpportunityRequest;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.contracts.WinOpportunityRequest;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.serialization.Guid;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.AssociateRequest;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.AttributeCollection;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.ColumnSet;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.DisassociateRequest;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.Entity;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.EntityReference;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.EntityRole;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.OrganizationRequest;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.OrganizationResponse;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.Relationship;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.services.IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.services.Retrieve;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.metadata.ManyToManyRelationshipMetadata;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.metadata.OneToManyRelationshipMetadata;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.metadata.RelationshipMetadataBase;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2012.contracts.ExecuteMultipleSettings;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2012.contracts.OrganizationRequestCollection;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.service.DynamicsCRMService;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.service.actions.CallClient;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.service.actions.SupportedRequests;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils.DynamicsCrmUtil;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils.ParameterCollectionBuilder;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils.RetrieveMultipleByQueryPagingDelegate;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.bulk.BulkOperationResult;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;

public class DynamicsCRMServiceImpl
extends DefaultConnectorService<DynamicsCRMConfig, DynamicsCRMConnection>
implements DynamicsCRMService {
    private static AttributesFactoryManager attributesFactoryManager = new AttributesFactoryManager();
    private RelationshipsFactory relationshipsFactory = new RelationshipsFactory();
    private final String OPPORTUNITY_ID = "opportunityid";
    private final String OPPORTUNITY = "opportunity";
    private final String READ_METADATA_ENTITY_EXCEPTION = "Error when reading metadata of entity";

    public DynamicsCRMServiceImpl(DynamicsCRMConfig configuration, DynamicsCRMConnection connection) {
        super((ConnectorConfig)configuration, (ConnectorConnection)connection);
    }

    @Override
    @MediaType(value="*/*")
    public String create(String logicalName, Map<String, Object> attributes) {
        AttributeCollection collection;
        Entity entity = new Entity();
        this.convertDateAttributes(attributes);
        try {
            collection = DynamicsCrmUtil.populateCollection(attributes, this.getAttributesRetriever(AttributesFactoryScope.OPERATION).getMetadata(new AttributesContext(logicalName, attributes.keySet())));
        }
        catch (IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage e) {
            throw new DynamicsCRMException("Error when reading metadata of entity", DynamicsCRMErrorType.UNKNOWN, e);
        }
        entity.setAttributes(collection);
        entity.setLogicalName(logicalName);
        return (String)CallClient.CREATE.invoke(((DynamicsCRMConnection)this.getConnection()).getSoapClient(), entity);
    }

    @Override
    public BulkOperationResult<Map<String, Object>> createMultiple(String logicalName, List<Map<String, Object>> attributesList, boolean useSingleTransaction) {
        try {
            return this.executeBulkOperation("Create", logicalName, attributesList, useSingleTransaction);
        }
        catch (IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage e) {
            throw new DynamicsCRMException("Error when reading metadata of entity", DynamicsCRMErrorType.UNKNOWN, e);
        }
    }

    @Override
    public void update(String logicalName, String id, Map<String, Object> attributes) {
        AttributeCollection newAttributes;
        Guid guid = new Guid();
        guid.setValue(id);
        this.convertDateAttributes(attributes);
        try {
            newAttributes = DynamicsCrmUtil.populateCollection(attributes, this.getAttributesRetriever(AttributesFactoryScope.OPERATION).getMetadata(new AttributesContext(logicalName, attributes.keySet())));
        }
        catch (IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage e) {
            throw new DynamicsCRMException("Error when reading metadata of entity", DynamicsCRMErrorType.UNKNOWN, e);
        }
        Entity entity = new Entity();
        entity.setLogicalName(logicalName);
        entity.setId(guid);
        entity.setAttributes(newAttributes);
        CallClient.UPDATE.invoke(((DynamicsCRMConnection)this.getConnection()).getSoapClient(), entity);
    }

    private void convertDateAttributes(Map<String, Object> attributes) {
        attributes.keySet().forEach(key -> {
            if (attributes.get(key) instanceof LocalDateTime) {
                attributes.put((String)key, Date.from(((LocalDateTime)attributes.get(key)).atZone(ZoneId.of("UTC")).toInstant()));
            }
        });
    }

    @Override
    public BulkOperationResult<Map<String, Object>> updateMultiple(String logicalName, List<Map<String, Object>> attributesList, boolean useSingleTransaction) {
        try {
            return this.executeBulkOperation("Update", logicalName, attributesList, useSingleTransaction);
        }
        catch (IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage e) {
            throw new DynamicsCRMException("Error when reading metadata of entity", DynamicsCRMErrorType.UNKNOWN, e);
        }
    }

    @Override
    public Map<String, Object> retrieve(String logicalName, String id) {
        ColumnSet columnSet = new ColumnSet();
        columnSet.setAllColumns(true);
        Guid guid = new Guid();
        guid.setValue(id);
        Retrieve retrieveRequest = new Retrieve();
        retrieveRequest.setId(guid);
        retrieveRequest.setColumnSet(columnSet);
        retrieveRequest.setEntityName(logicalName);
        Entity retrievedEntity = (Entity)CallClient.RETRIEVE.invoke(((DynamicsCRMConnection)this.getConnection()).getSoapClient(), retrieveRequest);
        return DynamicsCrmUtil.mapEntityToMap(retrievedEntity);
    }

    @Override
    public void delete(String logicalName, String id) {
        Guid guid = new Guid();
        guid.setValue(id);
        Entity entity = new Entity();
        entity.setId(guid);
        entity.setLogicalName(logicalName);
        CallClient.DELETE.invoke(((DynamicsCRMConnection)this.getConnection()).getSoapClient(), entity);
    }

    @Override
    public BulkOperationResult<String> deleteMultiple(String logicalName, List<String> ids, boolean useSingleTransaction) {
        if (ids == null || ids.isEmpty()) {
            throw new DynamicsCRMException("Payload cannot be null or empty", DynamicsCRMErrorType.VALIDATION);
        }
        OrganizationRequestCollection orgCollection = new OrganizationRequestCollection();
        for (String id : ids) {
            EntityReference entityReference = new EntityReference();
            Guid guid = new Guid();
            guid.setValue(id);
            entityReference.setId(guid);
            entityReference.setLogicalName(logicalName);
            OrganizationRequest orgRequest = DynamicsCrmUtil.createOrganizationRequest("Delete", ParameterCollectionBuilder.singletonCollection("Target", entityReference));
            orgCollection.getOrganizationRequests().add(orgRequest);
        }
        OrganizationResponse responseWithMultiple = this.executeMultipleRequests(orgCollection, useSingleTransaction);
        try {
            return DynamicsCrmUtil.getResults(responseWithMultiple, ids);
        }
        catch (IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage e) {
            throw new DynamicsCRMException("Error when reading metadata of entity", DynamicsCRMErrorType.UNKNOWN, e);
        }
    }

    @Override
    public PagingProvider<DynamicsCRMConnection, Map<String, Object>> retrieveMultipleByQuery(String query, int itemsPerPage, int singlePageNumber) {
        return new RetrieveMultipleByQueryPagingDelegate(query, itemsPerPage, singlePageNumber);
    }

    @Override
    public void associate(String logicalName, String id, boolean relationshipEntityRoleIsReferenced, String relationshipSchemaName, List<String> relatedEntitiesIds) {
        String referencedEntity;
        Relationship relationship = new Relationship();
        try {
            referencedEntity = this.getReferencedLogicalNameAndConfigureRelationship(relationshipEntityRoleIsReferenced, relationshipSchemaName, null, relationship);
        }
        catch (IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage e) {
            throw new DynamicsCRMException("Error when reading metadata of a relationship", DynamicsCRMErrorType.UNKNOWN, e);
        }
        relationship.setSchemaName(relationshipSchemaName);
        Guid entityGuid = new Guid();
        entityGuid.setValue(id);
        EntityReference targetEntity = new EntityReference();
        targetEntity.setLogicalName(logicalName);
        targetEntity.setId(entityGuid);
        AssociateRequest associateRequest = new AssociateRequest();
        associateRequest.setRelatedEntities(DynamicsCrmUtil.mapIdsToEntityReferenceCollection("", referencedEntity, relatedEntitiesIds));
        associateRequest.setRelationship(relationship);
        associateRequest.setTarget(targetEntity);
        CallClient.ASSOCIATE.invoke(((DynamicsCRMConnection)this.getConnection()).getSoapClient(), associateRequest);
    }

    @Override
    public void dissasociate(String logicalName, String id, boolean relationshipEntityRoleIsReferenced, String relationshipSchemaName, List<String> relatedEntitiesIds) {
        String referencedEntity;
        Relationship relationship = new Relationship();
        try {
            referencedEntity = this.getReferencedLogicalNameAndConfigureRelationship(relationshipEntityRoleIsReferenced, relationshipSchemaName, null, relationship);
        }
        catch (IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage e) {
            throw new DynamicsCRMException("Error when reading metadata of a relationship", DynamicsCRMErrorType.UNKNOWN, e);
        }
        relationship.setSchemaName(relationshipSchemaName);
        Guid entityGuid = new Guid();
        entityGuid.setValue(id);
        EntityReference targetEntity = new EntityReference();
        targetEntity.setLogicalName(logicalName);
        targetEntity.setId(entityGuid);
        DisassociateRequest associateRequest = new DisassociateRequest();
        associateRequest.setRelatedEntities(DynamicsCrmUtil.mapIdsToEntityReferenceCollection("", referencedEntity, relatedEntitiesIds));
        associateRequest.setRelationship(relationship);
        associateRequest.setTarget(targetEntity);
        CallClient.DISASSOCIATE.invoke(((DynamicsCRMConnection)this.getConnection()).getSoapClient(), associateRequest);
    }

    @Override
    public Object execute(String requestName, Object parameters, String requestId) {
        SupportedRequests req;
        Object requestParameters = null;
        if (parameters == null || parameters instanceof Map) {
            try {
                Class<?> reqClazz = DynamicsCrmUtil.getRequestOrResponseClass(requestName, "Request");
                requestParameters = parameters != null ? new ObjectMapper().convertValue(parameters, reqClazz) : (Object)reqClazz.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new DynamicsCRMException("Error when creating request class for the operation '" + requestName + "'", DynamicsCRMErrorType.UNKNOWN, e);
            }
        }
        if (!(requestParameters instanceof OrganizationRequest)) {
            throw new DynamicsCRMException("Payload should be an instance of OrganizationRequest (or Map) type", DynamicsCRMErrorType.VALIDATION);
        }
        OrganizationRequest request = (OrganizationRequest)requestParameters;
        request.setRequestName(requestName);
        if (StringUtil.isNotBlank(requestId)) {
            Guid requestGuid = new Guid();
            requestGuid.setValue(requestId);
            request.setRequestId(requestGuid);
        }
        if ((req = SupportedRequests.fromTo(requestName)) != null) {
            switch (req) {
                case WIN_OPPORTUNITY: {
                    List<KeyValuePairOfstringanyType> winOpportunityRequestAttributes = ((WinOpportunityRequest)request).getOpportunityClose().getAttributes().getKeyValuePairOfstringanyTypes();
                    this.setAttributesValues(request, parameters, winOpportunityRequestAttributes);
                    break;
                }
                case LOSE_OPPORTUNITY: {
                    List<KeyValuePairOfstringanyType> loseOpportunityRequestAttributes = ((LoseOpportunityRequest)request).getOpportunityClose().getAttributes().getKeyValuePairOfstringanyTypes();
                    this.setAttributesValues(request, parameters, loseOpportunityRequestAttributes);
                }
            }
        }
        try {
            DynamicsCrmUtil.promoteMembersToParameters(request);
            OrganizationResponse response = (OrganizationResponse)CallClient.EXECUTE.invoke(((DynamicsCRMConnection)this.getConnection()).getSoapClient(), request);
            return DynamicsCrmUtil.promoteParametersToMembers(response);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new DynamicsCRMException("Error when creating request or response class for the operation '" + requestName + "' - detail: " + e.getMessage(), DynamicsCRMErrorType.TRANSFORMATION, e);
        }
    }

    private void setAttributesValues(OrganizationRequest request, Object parameters, List<KeyValuePairOfstringanyType> opportunityRequestAttributes) {
        EntityReference opportunityIdValue = new EntityReference();
        Guid opportunityIdGuid = new Guid();
        opportunityIdGuid.setValue(DynamicsCrmUtil.extractOpportunityId((HashMap)parameters));
        opportunityIdValue.setId(opportunityIdGuid);
        opportunityIdValue.setLogicalName("opportunity");
        for (KeyValuePairOfstringanyType attribute : opportunityRequestAttributes) {
            if (!"opportunityid".equalsIgnoreCase(attribute.getKey())) continue;
            attribute.setValue(opportunityIdValue);
        }
    }

    @Override
    public BulkOperationResult<Object> executeMultiple(List<Object> requests, boolean useSingleTransaction) {
        OrganizationRequestCollection requestCollection = new OrganizationRequestCollection();
        try {
            for (int i = 0; i < requests.size(); ++i) {
                Object object = requests.get(i);
                OrganizationRequest organizationRequest = this.validateRequestAndTransformItToOrganizationRequest(object, i);
                requestCollection.getOrganizationRequests().add(organizationRequest);
            }
            for (OrganizationRequest organizationRequest : requestCollection.getOrganizationRequests()) {
                DynamicsCrmUtil.promoteMembersToParameters(organizationRequest);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new DynamicsCRMException("Error when preparing to execute multiple operation - detail: " + e.getMessage(), DynamicsCRMErrorType.UNKNOWN, e);
        }
        try {
            return DynamicsCrmUtil.getResults(this.executeMultipleRequests(requestCollection, useSingleTransaction), null);
        }
        catch (IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage e) {
            throw new DynamicsCRMException("Error when parsing results of execute multiple operation", DynamicsCRMErrorType.TRANSFORMATION, e);
        }
    }

    private String getReferencedLogicalNameAndConfigureRelationship(boolean relationshipEntityRoleIsReferenced, String relationshipSchemaName, String referencedEntity, Relationship relationship) throws IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage {
        Iterable relationships = this.getRelationshipsRetriever().getMetadata(new BaseContext(relationshipSchemaName));
        RelationshipMetadataBase metadata = null;
        Iterator iterator = relationships.iterator();
        if (iterator.hasNext()) {
            RelationshipMetadataBase rel;
            metadata = rel = (RelationshipMetadataBase)iterator.next();
        }
        if (metadata instanceof OneToManyRelationshipMetadata) {
            referencedEntity = ((OneToManyRelationshipMetadata)metadata).getReferencingEntity();
            relationship.setPrimaryEntityRole(relationshipEntityRoleIsReferenced ? EntityRole.REFERENCED : EntityRole.REFERENCING);
        } else if (metadata instanceof ManyToManyRelationshipMetadata) {
            referencedEntity = ((ManyToManyRelationshipMetadata)metadata).getEntity2LogicalName();
        }
        return referencedEntity;
    }

    private OrganizationRequest validateRequestAndTransformItToOrganizationRequest(Object request, int itemNumber) throws ClassNotFoundException {
        OrganizationRequest organizationRequest = null;
        if (request instanceof OrganizationRequest) {
            if (!OrganizationRequest.class.equals(request.getClass()) && StringUtils.isBlank((String)((OrganizationRequest)request).getRequestName())) {
                ((OrganizationRequest)request).setRequestName(request.getClass().getSimpleName().replaceAll("Request$", ""));
            }
            if (StringUtils.isBlank((String)((OrganizationRequest)request).getRequestName())) {
                throw new DynamicsCRMException("Empty 'requestName' value on item " + itemNumber, DynamicsCRMErrorType.VALIDATION);
            }
            organizationRequest = (OrganizationRequest)request;
        } else if (request instanceof Map) {
            if (!((Map)request).containsKey("requestName")) {
                throw new DynamicsCRMException("Missing 'requestName' key on item " + itemNumber, DynamicsCRMErrorType.VALIDATION);
            }
            Object objRequestName = ((Map)request).get("requestName");
            if (objRequestName == null || StringUtils.isBlank((String)objRequestName.toString())) {
                throw new DynamicsCRMException("Empty 'requestName' value on item " + itemNumber, DynamicsCRMErrorType.VALIDATION);
            }
            organizationRequest = (OrganizationRequest)new ObjectMapper().convertValue(request, DynamicsCrmUtil.getRequestOrResponseClass(objRequestName.toString(), "Request"));
        }
        return organizationRequest;
    }

    private BulkOperationResult<Map<String, Object>> executeBulkOperation(String requestName, String logicalName, List<Map<String, Object>> attributesList, boolean useSingleTransaction) throws IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage {
        OrganizationRequestCollection orgCollection = new OrganizationRequestCollection();
        for (Map<String, Object> attributes : attributesList) {
            this.convertDateAttributes(attributes);
            Entity entityObj = new Entity();
            entityObj.setAttributes(DynamicsCrmUtil.populateCollection(attributes, this.getAttributesRetriever(AttributesFactoryScope.OPERATION).getMetadata(new AttributesContext(logicalName, attributes.keySet()))));
            entityObj.setLogicalName(logicalName);
            OrganizationRequest orgRequest = DynamicsCrmUtil.createOrganizationRequest(requestName, ParameterCollectionBuilder.singletonCollection("Target", entityObj));
            orgCollection.getOrganizationRequests().add(orgRequest);
        }
        OrganizationResponse responseWithMultiple = this.executeMultipleRequests(orgCollection, useSingleTransaction);
        return DynamicsCrmUtil.getResults(responseWithMultiple, attributesList);
    }

    private OrganizationResponse executeMultipleRequests(OrganizationRequestCollection orgCollection, boolean useSingleTransaction) {
        String requestName;
        ParameterCollectionBuilder parameterCollectionBuilder = new ParameterCollectionBuilder();
        if (useSingleTransaction) {
            requestName = "ExecuteTransaction";
            parameterCollectionBuilder.withKeyValue("Requests", orgCollection).withKeyValue("ReturnResponses", true);
        } else {
            requestName = "ExecuteMultiple";
            ExecuteMultipleSettings multipleSettings = new ExecuteMultipleSettings();
            multipleSettings.setContinueOnError(true);
            multipleSettings.setReturnResponses(true);
            parameterCollectionBuilder.withKeyValue("Requests", orgCollection).withKeyValue("Settings", multipleSettings);
        }
        return (OrganizationResponse)CallClient.EXECUTE.invoke(((DynamicsCRMConnection)this.getConnection()).getSoapClient(), DynamicsCrmUtil.createOrganizationRequest(requestName, parameterCollectionBuilder.build()));
    }

    private AttributesBaseRetriever getAttributesRetriever(AttributesFactoryScope scope) {
        return attributesFactoryManager.getFactory(scope).createAttributeRetriever((DynamicsCRMConnection)this.getConnection());
    }

    private RelationshipsRetriever getRelationshipsRetriever() {
        return this.relationshipsFactory.createAttributeRetriever((DynamicsCRMConnection)this.getConnection());
    }
}

