/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.error.exception;

import com.mulesoft.connectors.microsoft.dynamics.crm.internal.error.ErrorContent;
import java.util.Optional;
import org.mule.runtime.api.exception.ErrorMessageAwareException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class DynamicsCRMException
extends ModuleException
implements ErrorMessageAwareException {
    private final Message message;

    public DynamicsCRMException(ErrorTypeDefinition code, Throwable cause) {
        super(code, cause);
        this.message = this.buildErrorMessage(cause.getMessage(), code);
    }

    public DynamicsCRMException(String message, ErrorTypeDefinition code) {
        super(String.format("%s: %s", code, message), code);
        this.message = this.buildErrorMessage(message, code);
    }

    public DynamicsCRMException(String message, ErrorTypeDefinition code, Throwable cause) {
        super(String.format("%s: %s", code, message), code, cause);
        this.message = this.buildErrorMessage(message, code);
    }

    public Message getErrorMessage() {
        return Optional.ofNullable(this.message).orElse(null);
    }

    private Message buildErrorMessage(String message, ErrorTypeDefinition code) {
        return Message.builder().payload(new TypedValue((Object)new ErrorContent(code.getType(), message), DataType.OBJECT)).build();
    }
}

