/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.datasense.retrievers.attributes;

import com.mulesoft.connectors.microsoft.dynamics.crm.internal.datasense.retrievers.attributes.AttributesBaseRetriever;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.datasense.retrievers.attributes.AttributesContext;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.OrganizationResponse;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.ParameterCollection;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.services.IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.metadata.AttributeMetadata;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils.DynamicsCrmUtils;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils.MetadataUtil;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils.ParameterCollectionBuilder;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Optional;

public class AttributesMultipleRetriever
extends AttributesBaseRetriever {
    @Override
    protected Iterable<AttributeMetadata> resolveMetadata(AttributesContext ctx) throws IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage {
        ArrayList<AttributeMetadata> attributesMetadata = (ArrayList<AttributeMetadata>)this.getItemFromCache(ctx.getKey());
        if (attributesMetadata == null) {
            attributesMetadata = new ArrayList<AttributeMetadata>();
        }
        for (String attributeName : ctx.getAttributeNames()) {
            if (MetadataUtil.isLookupField(attributeName)) {
                attributeName = MetadataUtil.getLookupFieldName(attributeName);
            }
            String existingAttributeName = attributeName;
            Optional<AttributeMetadata> existingAttribute = attributesMetadata.stream().filter(attributeMetadata -> attributeMetadata.getLogicalName().equals(existingAttributeName)).findFirst();
            if (existingAttribute.isPresent()) continue;
            ParameterCollection reqParams = new ParameterCollectionBuilder().withKeyValue("MetadataId", this.createEmptyGuid()).withKeyValue("EntityLogicalName", ctx.getKey()).withKeyValue("LogicalName", attributeName).withKeyValue("RetrieveAsIfPublished", true).build();
            try {
                OrganizationResponse response = this.connection.getSoapClient().execute(DynamicsCrmUtils.createOrganizationRequest("RetrieveAttribute", reqParams));
                attributesMetadata.add((AttributeMetadata)response.getResults().getKeyValuePairOfstringanyTypes().stream().filter(item -> item.getKey().equals("AttributeMetadata")).findFirst().get().getValue());
            }
            catch (IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage e) {
                if (e.getFaultInfo().getErrorCode().equals(-2147220969)) continue;
                throw e;
            }
            catch (NoSuchElementException e) {
                throw new IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage("Could not find metadata for entity " + ctx.getKey(), e);
            }
        }
        return attributesMetadata;
    }

    @Override
    protected boolean isResolveRequired(Iterable<AttributeMetadata> attributeMetadata) {
        return true;
    }
}

