/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.utils;

import com.mulesoft.connectors.microsoft.dynamics.crm.internal.error.DynamicsCRMErrorType;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.error.exception.DynamicsCRMException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wss4j.common.spnego.SpnegoClientAction;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class XrmSpnegoClientAction
implements SpnegoClientAction {
    private Log log = LogFactory.getLog(XrmSpnegoClientAction.class);
    private String serviceName;
    private GSSContext secContext;
    private boolean mutualAuth;

    public void setMutualAuth(boolean mutualAuthentication) {
        this.mutualAuth = mutualAuthentication;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setUserNameServiceForm(boolean b) {
    }

    public GSSContext getContext() {
        return this.secContext;
    }

    public byte[] run() {
        this.log.info((Object)"Starting negotiaton for Kerberos TGT");
        try {
            GSSManager gssManager = GSSManager.getInstance();
            Oid oid = new Oid("1.3.6.1.5.5.2");
            GSSName gssService = gssManager.createName(this.serviceName, null);
            this.secContext = gssManager.createContext(gssService, oid, null, 0);
            this.secContext.requestMutualAuth(this.mutualAuth);
            this.secContext.requestCredDeleg(Boolean.FALSE);
            byte[] token = new byte[]{};
            return this.secContext.initSecContext(token, 0, token.length);
        }
        catch (GSSException e) {
            throw new DynamicsCRMException("Error in obtaining a Kerberos TGT", DynamicsCRMErrorType.CONNECTIVITY, e);
        }
    }
}

