/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.utils;

import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.parameters.ProxySettingsParams;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.policies.interceptors.XrmFaultInterceptor;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.providers.CrmAuthenticationPolicyInterceptorProvider;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.utils.ProxyAuthenticator;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.security.assertors.FailPolicyAssertionBuilder;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.security.assertors.OrganizationServiceAssertionBuilder;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.security.assertors.ProcessCreateAssertionBuilder;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.security.assertors.XrmAuthenticationPolicyBuilder;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.security.policies.providers.XrmKnownPolicyInterceptorProvider;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.security.ProxyAuthorizationPolicy;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.policy.AssertionBuilderRegistry;
import org.apache.cxf.ws.policy.PolicyInterceptorProvider;
import org.apache.cxf.ws.policy.PolicyInterceptorProviderRegistry;
import org.apache.neethi.builders.AssertionBuilder;
import org.mule.runtime.api.connection.ConnectionException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DynamicsCrmConnectionUtils {
    private static final Log log = LogFactory.getLog(DynamicsCrmConnectionUtils.class);

    private DynamicsCrmConnectionUtils() {
    }

    public static void disableCnCheckInHttpsURLConnection() throws ConnectionException {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509ExtendedTrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            throw new ConnectionException("Error when trying to disable CN check: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void restoreCnCheckInHttpsURLConnection() throws ConnectionException {
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, null, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            throw new ConnectionException("Error when trying to restore CN check: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void disableCnCheck(HTTPConduit conduit) {
        TLSClientParameters tlsClientParameters = new TLSClientParameters();
        tlsClientParameters.setUseHttpsURLConnectionDefaultHostnameVerifier(true);
        tlsClientParameters.setUseHttpsURLConnectionDefaultSslSocketFactory(true);
        tlsClientParameters.setDisableCNCheck(true);
        conduit.setTlsClientParameters(tlsClientParameters);
    }

    public static void configurePolicies(Bus bus, ProxySettingsParams proxySettingsParams) {
        PolicyInterceptorProviderRegistry policyRegistry = (PolicyInterceptorProviderRegistry)bus.getExtension(PolicyInterceptorProviderRegistry.class);
        if (policyRegistry != null) {
            policyRegistry.register((PolicyInterceptorProvider)new CrmAuthenticationPolicyInterceptorProvider(proxySettingsParams));
            policyRegistry.register((PolicyInterceptorProvider)new XrmKnownPolicyInterceptorProvider());
        } else {
            log.warn((Object)"PolicyInterceptorProviderRegistry cannot be found in bus extensions");
        }
        AssertionBuilderRegistry assertionRegistry = (AssertionBuilderRegistry)bus.getExtension(AssertionBuilderRegistry.class);
        if (assertionRegistry != null) {
            assertionRegistry.registerBuilder((AssertionBuilder)new XrmAuthenticationPolicyBuilder());
            assertionRegistry.registerBuilder((AssertionBuilder)new FailPolicyAssertionBuilder());
            assertionRegistry.registerBuilder((AssertionBuilder)new OrganizationServiceAssertionBuilder());
            assertionRegistry.registerBuilder((AssertionBuilder)new ProcessCreateAssertionBuilder());
        } else {
            log.warn((Object)"assertBuildRegistry cannot be found in bus extensions");
        }
        XrmFaultInterceptor registeredXrmFaultInterceptor = null;
        for (Interceptor interceptor : bus.getInInterceptors()) {
            if (!(interceptor instanceof XrmFaultInterceptor)) continue;
            registeredXrmFaultInterceptor = (XrmFaultInterceptor)interceptor;
        }
        if (registeredXrmFaultInterceptor == null) {
            bus.getInInterceptors().add(new XrmFaultInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document downloadUrlIntoDocument(String urlString, ProxySettingsParams proxyConnection) throws IOException, ParserConfigurationException, SAXException {
        URL url = new URL(urlString);
        try (InputStream ins = null;){
            Proxy proxy = DynamicsCrmConnectionUtils.createProxyConnection(proxyConnection);
            HttpURLConnection connection = proxy != null ? (HttpURLConnection)url.openConnection(proxy) : (HttpURLConnection)url.openConnection();
            ins = connection.getInputStream();
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document document = builder.parse(ins);
            return document;
        }
    }

    public static void setReadTimeout(HTTPConduit conduit, Integer receiveTimeoutInMs) {
        HTTPClientPolicy policy = conduit.getClient();
        policy.setReceiveTimeout((long)receiveTimeoutInMs.intValue());
    }

    public static void setConnectionTimeout(HTTPConduit conduit, Integer connectionTimeoutInMs) {
        HTTPClientPolicy policy = conduit.getClient();
        policy.setConnectionTimeout((long)connectionTimeoutInMs.intValue());
    }

    public static void setProxyConnection(HTTPConduit conduit, ProxySettingsParams proxySettingsParams) {
        if (proxySettingsParams != null && StringUtil.isNotBlank(proxySettingsParams.getProxyHost()) && proxySettingsParams.getProxyPort() != null) {
            HTTPClientPolicy client = conduit.getClient();
            client.setProxyServer(proxySettingsParams.getProxyHost());
            client.setProxyServerPort(proxySettingsParams.getProxyPort());
            if (StringUtil.isNotBlank(proxySettingsParams.getProxyUsername()) && StringUtil.isNotBlank(proxySettingsParams.getProxyPassword())) {
                ProxyAuthorizationPolicy policy = new ProxyAuthorizationPolicy();
                policy.setAuthorizationType("Basic");
                policy.setUserName(proxySettingsParams.getProxyUsername());
                policy.setPassword(proxySettingsParams.getProxyPassword());
                conduit.setProxyAuthorization(policy);
            }
        }
    }

    public static Proxy createProxyConnection(ProxySettingsParams proxySettingsParams) {
        if (proxySettingsParams != null && StringUtil.isNotBlank(proxySettingsParams.getProxyHost()) && proxySettingsParams.getProxyPort() != null) {
            if (StringUtil.isNotBlank(proxySettingsParams.getProxyUsername()) && StringUtil.isNotBlank(proxySettingsParams.getProxyPassword())) {
                Authenticator.setDefault(new ProxyAuthenticator(proxySettingsParams));
            }
            System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxySettingsParams.getProxyHost(), (int)proxySettingsParams.getProxyPort()));
        }
        return null;
    }
}

