/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online;

import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.parameters.ConnectorErrorType;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online.LiveIDManager;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online.MicrosoftOnlineAuthenticationPolicy;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online.MicrosoftOnlineSecurityData;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online.Office365ConnectionException;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online.RealmInfo;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online.exception.DeviceRegistrationFailedException;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.onpremise.PasswordCallbackHandler;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.policies.interceptors.XrmFaultInterceptor;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils.HttpClientService;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeoutException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.trust.STSClient;
import org.apache.neethi.Policy;
import org.apache.wss4j.policy.SPConstants;
import org.apache.wss4j.policy.model.Trust10;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.xml.sax.SAXException;

public class Office365TokenRetriever {
    private static final Log log = LogFactory.getLog(Office365TokenRetriever.class);
    private static final String MICROSOFT_ONLINE_GET_USER_REALM_INFO = "https://login.microsoftonline.com/GetUserRealm.srf";
    private static final String REQUEST_OBTAINING_HTTP_CONDUIT_EXCEPTION = "Error obtaining HTTP conduit from STS Client";
    private static final String REQUEST_SECURITY_TOKEN_EXCEPTION = "Error requesting a Security Token from STS Client";
    private final HttpClientService httpClientService;

    public Office365TokenRetriever(HttpClientService httpClientService) {
        this.httpClientService = httpClientService;
    }

    public SecurityToken getTokenFromOffice365(Bus bus, String username, String password, String issuerUrl, String appliesTo) throws Office365ConnectionException {
        SecurityToken token;
        Policy microsoftOnlineUsernamePolicy;
        try {
            microsoftOnlineUsernamePolicy = this.loadPolicy("MicrosoftOnlineUsernamePolicy.xml", bus);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new Office365ConnectionException("Error reading the Microsoft Online Username Policy", e);
        }
        STSClient stsClient = this.createSTSClient(bus);
        stsClient.setTrust(new Trust10(SPConstants.SPVersion.SP11, new Policy()));
        stsClient.setLocation(issuerUrl);
        stsClient.setSendKeyType(false);
        stsClient.setSoap12();
        stsClient.setPolicy((Object)microsoftOnlineUsernamePolicy);
        stsClient.getRequestContext().put("security.username", username);
        stsClient.getRequestContext().put("security.callback-handler", new PasswordCallbackHandler(password));
        try {
            this.disableAllowChunking(stsClient);
        }
        catch (BusException | EndpointException e) {
            throw new Office365ConnectionException(REQUEST_OBTAINING_HTTP_CONDUIT_EXCEPTION, (Exception)e);
        }
        try {
            token = stsClient.requestSecurityToken(appliesTo);
        }
        catch (Exception e) {
            throw new Office365ConnectionException(REQUEST_SECURITY_TOKEN_EXCEPTION, e);
        }
        log.info((Object)("Successfully authenticated against Microsoft Online: " + issuerUrl));
        return token;
    }

    public MicrosoftOnlineSecurityData getTokenFromLiveId(String organizationServiceUrl, String username, String password, MicrosoftOnlineAuthenticationPolicy organizationPolicy) throws Office365ConnectionException, TransformerException {
        LiveIDManager onlineManager = new LiveIDManager();
        try {
            MicrosoftOnlineSecurityData securityData = onlineManager.authenticateWithLiveID(organizationServiceUrl, username, password, organizationPolicy.getAppliesTo(), organizationPolicy.getLiveIdPolicy(), organizationPolicy.getIssuerUri(), this.httpClientService);
            log.info((Object)("Authenticated against Live ID for user: " + username));
            return securityData;
        }
        catch (DeviceRegistrationFailedException | IOException | IllegalStateException | TimeoutException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new Office365ConnectionException("Error authenticating against Live ID for user " + username, e);
        }
    }

    public RealmInfo getUserRealmInfo(String username) throws Office365ConnectionException {
        try {
            StringBuilder requestBody = new StringBuilder();
            requestBody.append("login").append("=").append(username).append("&").append("xml").append("=").append("1");
            InputStream response = this.httpClientService.sendPost(MICROSOFT_ONLINE_GET_USER_REALM_INFO, requestBody.toString(), null, null);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{RealmInfo.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            return (RealmInfo)jaxbUnmarshaller.unmarshal(response);
        }
        catch (JAXBException e) {
            throw new Office365ConnectionException("Error parsing response for getting User Realm Information", (Exception)((Object)e));
        }
        catch (IOException | TimeoutException e) {
            throw new Office365ConnectionException("Error reading User Realm Information", e);
        }
    }

    public SecurityToken getTokenFromAdfs(Bus bus, String username, String password, String metadataUrl, String portName, String appliesTo) throws Office365ConnectionException {
        SecurityToken token;
        STSClient stsClient = this.createSTSClient(bus);
        stsClient.getRequestContext().put("security.username", username);
        stsClient.getRequestContext().put("security.callback-handler", new PasswordCallbackHandler(password));
        stsClient.setKeyType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer");
        stsClient.setSendRenewing(false);
        stsClient.setWspNamespace("http://schemas.xmlsoap.org/ws/2004/09/policy");
        stsClient.setWsdlLocation(metadataUrl);
        stsClient.setEndpointName(portName);
        log.debug((Object)("Selected port name: '" + portName + "' to get a username token with the metadata url '" + metadataUrl + "'."));
        try {
            this.disableAllowChunking(stsClient);
        }
        catch (BusException | EndpointException e) {
            throw new Office365ConnectionException(REQUEST_OBTAINING_HTTP_CONDUIT_EXCEPTION, (Exception)e);
        }
        try {
            token = stsClient.requestSecurityToken(appliesTo);
        }
        catch (Exception e) {
            throw new Office365ConnectionException(REQUEST_SECURITY_TOKEN_EXCEPTION, e);
        }
        log.info((Object)("Successfully authenticated against STS: " + metadataUrl));
        return token;
    }

    public SecurityToken getTokenFromMicrosoftOnline(Bus bus, SecurityToken issuedToken, String issuerUrl, String appliesTo) throws Office365ConnectionException {
        SecurityToken token;
        Policy microsoftOnlineIssuedTokenPolicy;
        try {
            microsoftOnlineIssuedTokenPolicy = this.loadPolicy("MicrosoftOnlineIssuedTokenPolicy.xml", bus);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new Office365ConnectionException("Error reading the Microsoft Online Issued Token Policy", e);
        }
        STSClient stsClient = this.createSTSClient(bus);
        stsClient.setTrust(new Trust10(SPConstants.SPVersion.SP11, new Policy()));
        stsClient.setLocation(issuerUrl);
        stsClient.setSendKeyType(false);
        stsClient.setSoap12();
        stsClient.setPolicy((Object)microsoftOnlineIssuedTokenPolicy);
        stsClient.getRequestContext().put("ws-security.token", issuedToken);
        try {
            this.disableAllowChunking(stsClient);
        }
        catch (BusException | EndpointException e) {
            throw new Office365ConnectionException(REQUEST_OBTAINING_HTTP_CONDUIT_EXCEPTION, (Exception)e);
        }
        try {
            token = stsClient.requestSecurityToken(appliesTo);
        }
        catch (Exception e) {
            throw new Office365ConnectionException(REQUEST_SECURITY_TOKEN_EXCEPTION, e);
        }
        log.info((Object)("Successfully authenticated against Microsoft Online: " + issuerUrl));
        return token;
    }

    private Policy loadPolicy(String policy, Bus bus) throws IOException, ParserConfigurationException, SAXException {
        try {
            return ((PolicyBuilder)bus.getExtension(PolicyBuilder.class)).getPolicy(Thread.currentThread().getContextClassLoader().getResourceAsStream(policy));
        }
        catch (RuntimeException e) {
            throw new ModuleException((ErrorTypeDefinition)ConnectorErrorType.CONNECTIVITY, (Throwable)new ConnectionException((Throwable)e));
        }
    }

    private STSClient createSTSClient(Bus bus) {
        STSClient stsClient = new STSClient(bus);
        stsClient.getInInterceptors().add(new XrmFaultInterceptor());
        stsClient.setAddressingNamespace("http://www.w3.org/2005/08/addressing");
        stsClient.setSendRenewing(false);
        stsClient.setWspNamespace("http://schemas.xmlsoap.org/ws/2004/09/policy");
        return stsClient;
    }

    private void disableAllowChunking(STSClient stsClient) throws BusException, EndpointException {
        ((HTTPConduit)stsClient.getClient().getConduit()).getClient().setAllowChunking(false);
    }

    private class ForceUTF8EncodingInInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public ForceUTF8EncodingInInterceptor() {
            super("receive");
            this.addAfter("PolicyInInterceptor");
        }

        public void handleMessage(Message message) {
            message.put((Object)Message.ENCODING, (Object)"UTF-8");
        }
    }
}

