/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online;

import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online.MicrosoftOnlineSecurityData;
import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.source.SourceDataBinding;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.Fault;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MicrosoftOnlineSecurityHeaderInterceptor
extends AbstractSoapInterceptor {
    private static final SourceDataBinding db = new SourceDataBinding();
    private MicrosoftOnlineSecurityData securityData;

    public MicrosoftOnlineSecurityHeaderInterceptor(MicrosoftOnlineSecurityData securityData) {
        super("post-logical");
        this.securityData = securityData;
    }

    public void handleMessage(SoapMessage message) {
        ZonedDateTime timestampRequest = ZonedDateTime.now(ZoneId.of("GMT"));
        ZonedDateTime timestampExpiryRequest = timestampRequest.plusMinutes(5L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
        String paramTimestampRequest = timestampRequest.format(formatter);
        String paramTimestampExpiryRequest = timestampExpiryRequest.format(formatter);
        String securityHeaderTemplate = "<Security xmlns=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\" xmlns:util=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\"><EncryptedData    xmlns=\"http://www.w3.org/2001/04/xmlenc#\"   Id=\"Assertion0\"    Type=\"http://www.w3.org/2001/04/xmlenc#Element\">   <EncryptionMethod        Algorithm=\"http://www.w3.org/2001/04/xmlenc#tripledes-cbc\"/>   <ds:KeyInfo        xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\">       <EncryptedKey>           <EncryptionMethod                Algorithm=\"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p\"/>           <ds:KeyInfo Id=\"keyinfo\">               <wsse:SecurityTokenReference                    xmlns:wsse=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\">                   <wsse:KeyIdentifier                        EncodingType=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary\"                        ValueType=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier\">%s</wsse:KeyIdentifier>               </wsse:SecurityTokenReference>           </ds:KeyInfo>           <CipherData>               <CipherValue>%s</CipherValue>           </CipherData>       </EncryptedKey>   </ds:KeyInfo>   <CipherData>       <CipherValue>%s</CipherValue>   </CipherData></EncryptedData></Security>";
        String securityHeader = String.format(securityHeaderTemplate, this.securityData.getKeyIdentifier(), this.securityData.getSecurityToken0(), this.securityData.getSecurityToken1());
        try {
            Document parsedDocument = XMLUtils.createDocumentBuilder((boolean)true).parse(new ByteArrayInputStream(securityHeader.getBytes(Charset.forName("UTF-8"))));
            String securityNS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
            String utilityNS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
            Element timeStamp = parsedDocument.createElementNS(utilityNS, "util:Timestamp");
            timeStamp.setAttributeNS(utilityNS, "Id", "_0");
            Element created = parsedDocument.createElementNS(utilityNS, "util:Created");
            created.setTextContent(paramTimestampRequest);
            Element expires = parsedDocument.createElementNS(utilityNS, "util:Expires");
            expires.setTextContent(paramTimestampExpiryRequest);
            timeStamp.appendChild(created);
            timeStamp.appendChild(expires);
            Element root = parsedDocument.getDocumentElement();
            root.insertBefore(timeStamp, root.getFirstChild());
            Header security = new Header(new QName(securityNS, "Security"), (Object)parsedDocument.getDocumentElement(), (DataBinding)db);
            message.getHeaders().add(security);
        }
        catch (Exception e) {
            throw new SoapFault("Could not create security header.", (Throwable)e, Fault.FAULT_CODE_CLIENT);
        }
    }
}

