/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online;

import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.parameters.ProxySettingsParams;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online.exception.AuthenticationPolicyException;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online.exception.InvalidWSDLInfoException;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.utils.DynamicsCrmConnectionUtils;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.utils.UriUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import joptsimple.internal.Strings;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class MicrosoftOnlineAuthenticationPolicy {
    private String appliesTo;
    private URI issuerUri;
    private String microsoftOnlineIdentifier;
    private XPath xpath = XPathFactory.newInstance().newXPath();
    private String acsIdentifier;
    private String acsIssuer;
    private String crmIdentifier;
    private String liveIdPolicy;
    private final ProxySettingsParams proxySettingsParams;

    public MicrosoftOnlineAuthenticationPolicy(String organizationWsdlUrl, ProxySettingsParams proxySettingsParams) throws ParserConfigurationException, SAXException, IOException, URISyntaxException, XPathExpressionException, AuthenticationPolicyException, InvalidWSDLInfoException {
        this.proxySettingsParams = proxySettingsParams;
        this.initialize(organizationWsdlUrl);
    }

    private void initialize(String organizationWsdlUrl) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException, URISyntaxException, AuthenticationPolicyException, InvalidWSDLInfoException {
        MatcherAssert.assertThat((Object)organizationWsdlUrl, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Document wsdlDocument = DynamicsCrmConnectionUtils.downloadUrlIntoDocument(organizationWsdlUrl, this.proxySettingsParams);
        Node onlineFederationAuhtPolicyNode = this.getOnlineFederationAuthPolicyNode(wsdlDocument);
        if (onlineFederationAuhtPolicyNode == null) {
            throw new AuthenticationPolicyException("'OnlineFederation' AuthenticationPolicy not present in the WSDL: " + organizationWsdlUrl);
        }
        this.appliesTo = this.readStringValue(onlineFederationAuhtPolicyNode, "SecureTokenService/OrgTrust/AppliesTo");
        if (Strings.isNullOrEmpty((String)this.appliesTo)) {
            throw new InvalidWSDLInfoException("Unable to read the 'OrgTrust/AppliesTo' from the WSDL in this location: " + organizationWsdlUrl);
        }
        this.microsoftOnlineIdentifier = this.readStringValue(onlineFederationAuhtPolicyNode, "SecureTokenService/OrgTrust/Identifier");
        this.setAcsIdentifier(this.readStringValue(onlineFederationAuhtPolicyNode, "SecureTokenService/Identifier"));
        this.liveIdPolicy = this.readStringValue(onlineFederationAuhtPolicyNode, "SecureTokenService/OrgTrust/LivePolicy");
        String liveEndpoint = this.readStringValue(onlineFederationAuhtPolicyNode, "SecureTokenService/OrgTrust/LiveEndpoint");
        if (Strings.isNullOrEmpty((String)liveEndpoint)) {
            throw new InvalidWSDLInfoException("Unable to read the 'OrgTrust/LiveEndpoint' from the WSDL in this location: " + organizationWsdlUrl);
        }
        this.issuerUri = new URI(liveEndpoint);
        Node metadataReferenceNode = (Node)this.xpath.compile("//*[local-name()='MetadataReference']").evaluate(wsdlDocument, XPathConstants.NODE);
        if (metadataReferenceNode != null) {
            String metadataReferenceUrl = this.readStringValue(metadataReferenceNode, "Address");
            String metadataBaseUrl = UriUtils.getRootUri(metadataReferenceUrl);
            this.setAcsIssuer(metadataBaseUrl + "/v2/wstrust/13/issuedtoken-asymmetric");
        }
        this.setCrmIdentifier(UriUtils.getRootUri(organizationWsdlUrl) + "/");
    }

    private Node getOnlineFederationAuthPolicyNode(Document wsdlDocument) throws XPathExpressionException {
        NodeList authPolicies = (NodeList)this.xpath.compile("//*[local-name()='AuthenticationPolicy']").evaluate(wsdlDocument, XPathConstants.NODESET);
        Node onlineFederationAuhtPolicyNode = null;
        for (int i = 0; i < authPolicies.getLength(); ++i) {
            Node authPolicy = authPolicies.item(i);
            String authenticationPolicyType = this.xpath.compile("Authentication").evaluate(authPolicy);
            if (!"OnlineFederation".equalsIgnoreCase(authenticationPolicyType)) continue;
            onlineFederationAuhtPolicyNode = authPolicy;
            break;
        }
        return onlineFederationAuhtPolicyNode;
    }

    private String readStringValue(Node onlineFederationAuhtPolicyNode, String xpathQueryExpression) throws XPathExpressionException {
        return this.xpath.compile(xpathQueryExpression).evaluate(onlineFederationAuhtPolicyNode);
    }

    public final String getAppliesTo() {
        return this.appliesTo;
    }

    public final URI getIssuerUri() {
        return this.issuerUri;
    }

    public String getMicrosoftOnlineIdentifier() {
        return this.microsoftOnlineIdentifier;
    }

    public void setMicrosoftOnlineIdentifier(String identifier) {
        this.microsoftOnlineIdentifier = identifier;
    }

    public String getAcsIdentifier() {
        return this.acsIdentifier;
    }

    public void setAcsIdentifier(String acsIdentifier) {
        this.acsIdentifier = acsIdentifier;
    }

    public String getAcsIssuer() {
        return this.acsIssuer;
    }

    public void setAcsIssuer(String acsIssuer) {
        this.acsIssuer = acsIssuer;
    }

    public String getCrmIdentifier() {
        return this.crmIdentifier;
    }

    public void setCrmIdentifier(String crmIdentifier) {
        this.crmIdentifier = crmIdentifier;
    }

    public String getLiveIdPolicy() {
        return this.liveIdPolicy;
    }

    public void setLiveIdPolicy(String liveIdPolicy) {
        this.liveIdPolicy = liveIdPolicy;
    }
}

