/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.providers;

import com.mulesoft.connectors.commons.template.connection.provider.ConnectorConnectionProvider;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.DynamicsCRMConnection;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.parameters.AdvancedParams;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.parameters.KerberosCredentials;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.parameters.ProxySettingsParams;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.utils.ConnectorUtils;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.security.DefaultLoginConfiguration;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.service.connection.soap.KerberosSoapClientProvider;
import java.io.FileNotFoundException;
import javax.inject.Inject;
import javax.security.auth.login.Configuration;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.connection.PoolingConnectionProvider;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.http.api.HttpService;
import org.mule.sdk.api.annotation.semantics.SemanticTerms;
import org.mule.sdk.api.annotation.semantics.connectivity.ExcludeFromConnectivitySchema;
import org.mule.sdk.api.annotation.semantics.connectivity.KerberosAuth;
import org.mule.sdk.api.annotation.semantics.connectivity.Url;
import org.mule.sdk.api.annotation.semantics.security.Password;
import org.mule.sdk.api.annotation.semantics.security.Username;
import sun.security.krb5.Config;
import sun.security.krb5.KrbException;

@Alias(value="kerberos")
@KerberosAuth
public class KerberosConnectionProvider
implements PoolingConnectionProvider<DynamicsCRMConnection>,
ConnectorConnectionProvider<DynamicsCRMConnection> {
    @Inject
    private HttpService httpService;
    @Parameter
    @Username
    private String username;
    @Parameter
    @Password
    private String password;
    @Parameter
    @Url
    private String organizationServiceUrl;
    @DisplayName(value="SPN")
    @Parameter
    @Optional
    @Summary(value="(Optional) SPN for the SharePoint Web Service.")
    @SemanticTerms(value={"SPN"})
    private String spn;
    @DisplayName(value="Realm")
    @Parameter
    @Optional
    @Summary(value="(Optional) The case-sensitive default realm (Domain Name) that the user belongs to.")
    @SemanticTerms(value={"Realm"})
    private String realm;
    @DisplayName(value="KDC")
    @Parameter
    @Optional
    @Summary(value="(Optional) The KDC (usually the Domain Controller name) to authenticate the user.")
    @SemanticTerms(value={"KDC"})
    private String kdc;
    @DisplayName(value="Login Properties File Path")
    @Parameter
    @Optional
    @Summary(value="(Optional) Path to a customized Login Properties File. When not specified, default values which usually work for most cases will be set up.")
    @SemanticTerms(value={"Login Properties File Path"})
    private String loginPropertiesFilePath;
    @DisplayName(value="Kerberos Properties File Path")
    @Parameter
    @Optional
    @Summary(value="(Optional) Path to a customized Kerberos Properties File.")
    @SemanticTerms(value={"Kerberos Properties File Path"})
    private String kerberosPropertiesFilePath;
    @Parameter
    @Optional(defaultValue="false")
    @DisplayName(value="Disable SSL certificate validation")
    @ExcludeFromConnectivitySchema
    private boolean disableCnCheck;
    @ParameterGroup(name="Proxy")
    @Placement(order=4)
    private ProxySettingsParams proxySettingsParams;
    @ParameterGroup(name="Advanced")
    @Placement(order=2)
    private AdvancedParams advancedParams;

    public DynamicsCRMConnection connect() throws ConnectionException {
        this.clearSystemProperties();
        this.checkCredentialsParameters();
        this.setKerberosSystemProperties();
        KerberosCredentials credentials = new KerberosCredentials(this.organizationServiceUrl, this.username, this.password, this.spn, this.disableCnCheck, this.advancedParams, this.proxySettingsParams);
        KerberosSoapClientProvider soapClientProvider = new KerberosSoapClientProvider(credentials, false, this.httpService, new WebServiceFeature[]{new AddressingFeature(true, false)});
        return new DynamicsCRMConnection(soapClientProvider.createSoapClient());
    }

    public void disconnect(DynamicsCRMConnection connectorConnection) {
        connectorConnection.disconnect();
    }

    public ConnectionValidationResult validate(DynamicsCRMConnection connectorConnection) {
        try {
            connectorConnection.validate();
            return ConnectionValidationResult.success();
        }
        catch (Exception e) {
            return ConnectionValidationResult.failure((String)e.getMessage(), (Exception)e);
        }
    }

    private void setKerberosSystemProperties() throws ConnectionException {
        if (!StringUtils.isBlank((String)this.loginPropertiesFilePath)) {
            this.setConfigFileSystemProperty(this.loginPropertiesFilePath, "java.security.auth.login.config", "The loginPropertiesFile cannot be found!");
        } else {
            Configuration.setConfiguration(new DefaultLoginConfiguration(Boolean.TRUE));
        }
        if (!StringUtils.isBlank((String)this.kerberosPropertiesFilePath)) {
            this.setConfigFileSystemProperty(this.kerberosPropertiesFilePath, "java.security.krb5.conf", "The kerberosPropertiesFile cannot be found!");
        } else {
            System.setProperty("java.security.krb5.realm", this.realm);
            System.setProperty("java.security.krb5.kdc", this.kdc);
            System.setProperty("javax.security.auth.useSubjectCredsOnly", Boolean.FALSE.toString());
        }
    }

    private void setConfigFileSystemProperty(String configFilePath, String systemProperty, String errorMessage) throws ConnectionException {
        try {
            String replacedConfigFilePath = ConnectorUtils.resolvePathToAbsolutePath(configFilePath);
            if (!ConnectorUtils.checkFileExists(replacedConfigFilePath)) {
                throw new FileNotFoundException("Unable to find the file:" + replacedConfigFilePath + "'");
            }
            System.setProperty(systemProperty, replacedConfigFilePath);
        }
        catch (FileNotFoundException e) {
            throw new ConnectionException(errorMessage + " " + configFilePath, (Throwable)e);
        }
    }

    private void checkCredentialsParameters() throws ConnectionException {
        if (Boolean.TRUE.equals(this.realmOrKdcAndKrbFileAreBlank())) {
            try {
                Config.getInstance().getDefaultRealm();
            }
            catch (KrbException e) {
                throw new ConnectionException("Unable to automatically detect Kerberos configuration settings. Enter both the 'Realm' and the 'KDC'.", (Throwable)e);
            }
        } else if (Boolean.TRUE.equals(this.krbFileIsNotBlankAndRealmOrKdcAreNotBlank())) {
            throw new ConnectionException("When specifying the 'Kerberos properties file path', 'Realm' and 'KDC' must be left blank.");
        }
    }

    private Boolean realmOrKdcAndKrbFileAreBlank() {
        return (StringUtils.isBlank((String)this.realm) || StringUtils.isBlank((String)this.kdc)) && StringUtils.isBlank((String)this.kerberosPropertiesFilePath);
    }

    private Boolean krbFileIsNotBlankAndRealmOrKdcAreNotBlank() {
        return !StringUtils.isBlank((String)this.kerberosPropertiesFilePath) && (!StringUtils.isBlank((String)this.realm) || !StringUtils.isBlank((String)this.kdc));
    }

    private void clearSystemProperties() {
        System.clearProperty("java.security.auth.login.config");
        System.clearProperty("java.security.krb5.realm");
        System.clearProperty("java.security.krb5.kdc");
        System.clearProperty("java.security.krb5.conf");
        System.clearProperty("javax.security.auth.useSubjectCredsOnly");
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getOrganizationServiceUrl() {
        return this.organizationServiceUrl;
    }

    public void setOrganizationServiceUrl(String organizationServiceUrl) {
        this.organizationServiceUrl = organizationServiceUrl;
    }

    public String getSpn() {
        return this.spn;
    }

    public void setSpn(String spn) {
        this.spn = spn;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getKdc() {
        return this.kdc;
    }

    public void setKdc(String kdc) {
        this.kdc = kdc;
    }

    public String getLoginPropertiesFilePath() {
        return this.loginPropertiesFilePath;
    }

    public void setLoginPropertiesFilePath(String loginPropertiesFilePath) {
        this.loginPropertiesFilePath = loginPropertiesFilePath;
    }

    public String getKerberosPropertiesFilePath() {
        return this.kerberosPropertiesFilePath;
    }

    public void setKerberosPropertiesFilePath(String kerberosPropertiesFilePath) {
        this.kerberosPropertiesFilePath = kerberosPropertiesFilePath;
    }

    public boolean isDisableCnCheck() {
        return this.disableCnCheck;
    }

    public void setDisableCnCheck(boolean disableCnCheck) {
        this.disableCnCheck = disableCnCheck;
    }

    public ProxySettingsParams getProxySettingsParams() {
        return this.proxySettingsParams;
    }

    public void setProxySettingsParams(ProxySettingsParams proxySettingsParams) {
        this.proxySettingsParams = proxySettingsParams;
    }
}

