/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils;

import com.google.common.xml.XmlEscapers;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PagingHelper {
    private static final Pattern FETCH_ELEMENT = Pattern.compile("<fetch([^>]*)");
    private static final Pattern FETCH_PAGE_NUM_ELEMENT = Pattern.compile("<fetch([^>]* )page=\"([^\"]+)\"");
    private static final Pattern FETCH_PAGE_SIZE_ELEMENT = Pattern.compile("<fetch([^>]* )count=\"([^\"]+)\"");
    private static final Pattern FETCH_RECORD_COUNT_ELEMENT = Pattern.compile("<fetch([^>]* )returntotalrecordcount=\"([^\"]+)\"");
    private static final Pattern FETCH_PAGING_COOKIE_ELEMENT = Pattern.compile("<fetch([^>]* )paging-cookie=\"([^\"]+)\"");

    private PagingHelper() {
    }

    public static int getNativeQueryCurrentPageNumber(String nativeQuery) {
        if (StringUtil.isEmpty((String)nativeQuery)) {
            return -1;
        }
        Matcher matcher = FETCH_PAGE_NUM_ELEMENT.matcher(nativeQuery);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(2));
        }
        return 1;
    }

    public static String setNativeQueryCurrentPageNumber(String nativeQuery, int page) {
        if (StringUtil.isEmpty((String)nativeQuery)) {
            return null;
        }
        if (PagingHelper.isNativeQueryCurrentPageNumber(nativeQuery)) {
            Matcher matcher = FETCH_PAGE_NUM_ELEMENT.matcher(nativeQuery);
            matcher.find();
            return matcher.replaceFirst(String.format("<fetch%spage=\"%d\"", matcher.group(1), page));
        }
        Matcher matcher = FETCH_ELEMENT.matcher(nativeQuery);
        return matcher.replaceFirst(String.format("<fetch%s page=\"%d\"", matcher.find() ? matcher.group(1) : "", page));
    }

    public static boolean isNativeQueryCurrentPageNumber(String nativeQuery) {
        return !StringUtil.isEmpty((String)nativeQuery) && FETCH_PAGE_NUM_ELEMENT.matcher(nativeQuery).find();
    }

    public static int getNativeQueryCurrentPageSize(String nativeQuery) {
        if (StringUtil.isEmpty((String)nativeQuery)) {
            return -1;
        }
        Matcher matcher = FETCH_PAGE_SIZE_ELEMENT.matcher(nativeQuery);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(2));
        }
        return 1;
    }

    public static String setNativeQueryCurrentPageSize(String nativeQuery, int pageSize) {
        if (StringUtil.isEmpty((String)nativeQuery)) {
            return null;
        }
        if (PagingHelper.isNativeQueryCurrentPageSize(nativeQuery)) {
            Matcher matcher = FETCH_PAGE_SIZE_ELEMENT.matcher(nativeQuery);
            matcher.find();
            return matcher.replaceFirst(String.format("<fetch%scount=\"%d\"", matcher.group(1), pageSize));
        }
        Matcher matcher = FETCH_ELEMENT.matcher(nativeQuery);
        return matcher.replaceFirst(String.format("<fetch%s count=\"%d\"", matcher.find() ? matcher.group(1) : "", pageSize));
    }

    public static boolean isNativeQueryCurrentPageSize(String nativeQuery) {
        return !StringUtil.isEmpty((String)nativeQuery) && FETCH_PAGE_SIZE_ELEMENT.matcher(nativeQuery).find();
    }

    public static String setNativeQueryTotalRecordCount(String nativeQuery) {
        if (StringUtil.isEmpty((String)nativeQuery)) {
            return null;
        }
        Matcher matcher = FETCH_ELEMENT.matcher(nativeQuery);
        return PagingHelper.isNativeQueryTotalRecordCount(nativeQuery) ? nativeQuery : matcher.replaceFirst(String.format("<fetch%s returntotalrecordcount=\"true\"", matcher.find() ? matcher.group(1) : ""));
    }

    public static boolean isNativeQueryTotalRecordCount(String nativeQuery) {
        return !StringUtil.isEmpty((String)nativeQuery) && FETCH_RECORD_COUNT_ELEMENT.matcher(nativeQuery).find();
    }

    public static String removeNativeQueryTotalRecordCount(String nativeQuery) {
        Matcher matcher = FETCH_RECORD_COUNT_ELEMENT.matcher(nativeQuery);
        return matcher.replaceFirst(String.format("<fetch%s", matcher.find() ? matcher.group(1) : ""));
    }

    public static String setNativeQueryPagingCookie(String nativeQuery, String pagingCookie) {
        if (StringUtil.isEmpty((String)nativeQuery)) {
            return null;
        }
        if (PagingHelper.hasNativePagingCookie(nativeQuery)) {
            Matcher matcher = FETCH_PAGING_COOKIE_ELEMENT.matcher(nativeQuery);
            matcher.find();
            return matcher.replaceFirst(String.format("<fetch%spaging-cookie=\"%s\"", matcher.group(1), XmlEscapers.xmlAttributeEscaper().escape(pagingCookie)));
        }
        Matcher matcher = FETCH_ELEMENT.matcher(nativeQuery);
        String encodedPagingCookie = XmlEscapers.xmlAttributeEscaper().escape(pagingCookie);
        return matcher.replaceFirst(String.format("<fetch%s paging-cookie=\"%s\"", matcher.find() ? matcher.group(1) : "", encodedPagingCookie));
    }

    private static boolean hasNativePagingCookie(String nativeQuery) {
        return !StringUtil.isEmpty((String)nativeQuery) && FETCH_PAGING_COOKIE_ELEMENT.matcher(nativeQuery).find();
    }
}

