/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils;

import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class MetadataUtil {
    private static final Pattern lookupPattern = Pattern.compile("(\\w+)_referenceto_(\\w+)$");
    private static final Pattern lookupPatternLegacy = Pattern.compile("(\\w+)_(\\w+)_reference$");

    public static boolean isLookupField(String fieldName) {
        return lookupPatternLegacy.matcher(fieldName).find() || lookupPattern.matcher(fieldName).find();
    }

    public static String getLookupFieldName(String fieldName) {
        return MetadataUtil.getLookupMatch(fieldName, 1);
    }

    public static String getLookupEntityName(String fieldName) {
        return MetadataUtil.getLookupMatch(fieldName, 2);
    }

    public static String buildLookupField(String fieldName, String entityName) {
        return fieldName.concat("_referenceto_").concat(entityName);
    }

    public static String getEscapedFiledName(String name) {
        if ("select".equalsIgnoreCase(name) || "from".equalsIgnoreCase(name) || "where".equalsIgnoreCase(name) || "order".equalsIgnoreCase(name) || "by".equalsIgnoreCase(name) || "offset".equalsIgnoreCase(name) || "limit".equalsIgnoreCase(name) || "and".equalsIgnoreCase(name) || "or".equalsIgnoreCase(name)) {
            return "[" + name + "]";
        }
        return name;
    }

    public static String getUnescapedFiledName(String name) {
        if ("[select]".equalsIgnoreCase(name) || "[from]".equalsIgnoreCase(name) || "[where]".equalsIgnoreCase(name) || "[order]".equalsIgnoreCase(name) || "[by]".equalsIgnoreCase(name) || "[offset]".equalsIgnoreCase(name) || "[limit]".equalsIgnoreCase(name) || "[and]".equalsIgnoreCase(name) || "[or]".equalsIgnoreCase(name)) {
            return name.substring(1, name.length() - 1);
        }
        return name;
    }

    private static String getLookupMatch(String fieldName, int groupIndex) {
        Matcher lookupPatternMatcher = lookupPattern.matcher(fieldName);
        if (!lookupPatternMatcher.find() && !(lookupPatternMatcher = lookupPatternLegacy.matcher(fieldName)).find()) {
            return null;
        }
        String result = lookupPatternMatcher.group(groupIndex);
        return Strings.isNullOrEmpty((String)result) ? null : result;
    }

    public static String getEntityName(String query) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.parse(new ByteArrayInputStream(query.getBytes(StandardCharsets.UTF_8)));
        NodeList nodeList = document.getElementsByTagName("entity");
        if (nodeList.getLength() == 0) {
            return "";
        }
        return nodeList.item(0).getAttributes().getNamedItem("name").getNodeValue();
    }

    public static List<String> getEntityAttributes(String query) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.parse(new ByteArrayInputStream(query.getBytes(StandardCharsets.UTF_8)));
        NodeList nodeList = document.getElementsByTagName("attribute");
        ArrayList<String> attributes = new ArrayList<String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            attributes.add(nodeList.item(i).getAttributes().getNamedItem("name").getNodeValue());
        }
        return attributes;
    }
}

