/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils;

import com.google.common.base.Strings;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model._07.system_collections.KeyValuePairOfstringanyType;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model._07.system_collections.KeyValuePairOfstringstring;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.serialization.Guid;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.ArrayOfEntity;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.AttributeCollection;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.Entity;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.EntityCollection;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.EntityReference;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.EntityReferenceCollection;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.Money;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.OptionSetValue;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.OrganizationRequest;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.ParameterCollection;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.services.IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.metadata.AttributeMetadata;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.metadata.AttributeTypeCode;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.metadata.LookupAttributeMetadata;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils.MathUtil;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils.MetadataUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DynamicsCrmUtils {
    private static final String K_FORMATTEDVALUESCOLLECTION = "__formattedValues";

    private DynamicsCrmUtils() {
    }

    public static List<Map<String, Object>> mapEntityCollectionToMapCollection(EntityCollection entityCollection) {
        ArrayList<Map<String, Object>> entities = new ArrayList<Map<String, Object>>();
        for (Entity entity : entityCollection.getEntities().getEntities()) {
            entities.add(DynamicsCrmUtils.mapEntityToMap(entity));
        }
        return entities;
    }

    public static Map<String, Object> mapEntityToMap(Entity entity) {
        HashMap<String, Object> entityMap = new HashMap<String, Object>();
        for (KeyValuePairOfstringanyType attribute : entity.getAttributes().getKeyValuePairOfstringanyTypes()) {
            Object value = attribute.getValue();
            if (value instanceof Guid) {
                value = ((Guid)value).getValue();
                entityMap.put(attribute.getKey(), value);
                continue;
            }
            if (value instanceof EntityReference) {
                EntityReference valueAsEntityReference = (EntityReference)value;
                value = valueAsEntityReference.getId().getValue();
                entityMap.put(MetadataUtil.buildLookupField(attribute.getKey(), valueAsEntityReference.getLogicalName()), value);
                continue;
            }
            if (value instanceof OptionSetValue) {
                OptionSetValue valueAsOptionSetValue = (OptionSetValue)value;
                entityMap.put(attribute.getKey(), valueAsOptionSetValue.getValue());
                continue;
            }
            if (value instanceof Money) {
                Money valueAsMoney = (Money)value;
                entityMap.put(attribute.getKey(), valueAsMoney.getValue().doubleValue());
                continue;
            }
            if (value instanceof XMLGregorianCalendar) {
                XMLGregorianCalendar valueAsXMLGregorianCalendar = (XMLGregorianCalendar)value;
                entityMap.put(attribute.getKey(), valueAsXMLGregorianCalendar.toString());
                continue;
            }
            if (value instanceof EntityCollection) {
                ArrayList activityPartyReferences = new ArrayList();
                EntityCollection valueAsEntityCollection = (EntityCollection)value;
                if (valueAsEntityCollection.getEntities() != null && "activityparty".equalsIgnoreCase(valueAsEntityCollection.getEntityName())) {
                    for (Entity activityParty : valueAsEntityCollection.getEntities().getEntities()) {
                        if (activityParty.getAttributes() == null) continue;
                        for (KeyValuePairOfstringanyType activityPartyAttribute : activityParty.getAttributes().getKeyValuePairOfstringanyTypes()) {
                            if (!"partyid".equalsIgnoreCase(activityPartyAttribute.getKey()) || activityPartyAttribute.getValue() == null || !(activityPartyAttribute.getValue() instanceof EntityReference)) continue;
                            EntityReference activityPartyEntityReference = (EntityReference)activityPartyAttribute.getValue();
                            String activityPartyEntityReferenceName = MetadataUtil.buildLookupField(attribute.getKey(), activityPartyEntityReference.getLogicalName());
                            String activityPartyEntityReferenceId = activityPartyEntityReference.getId().getValue();
                            HashMap<String, String> activityPartyEntityReferenceMap = new HashMap<String, String>();
                            activityPartyEntityReferenceMap.put(activityPartyEntityReferenceName, activityPartyEntityReferenceId);
                            activityPartyReferences.add(activityPartyEntityReferenceMap);
                        }
                    }
                }
                entityMap.put(attribute.getKey(), activityPartyReferences);
                continue;
            }
            entityMap.put(attribute.getKey(), value);
        }
        HashMap<String, String> formattedValues = new HashMap<String, String>();
        for (KeyValuePairOfstringstring formattedValue : entity.getFormattedValues().getKeyValuePairOfstringstrings()) {
            formattedValues.put(formattedValue.getKey(), formattedValue.getValue());
        }
        entityMap.put(K_FORMATTEDVALUESCOLLECTION, formattedValues);
        return entityMap;
    }

    public static EntityReferenceCollection mapIdsToEntityReferenceCollection(String name, String logicalName, List<String> entityIds) {
        EntityReferenceCollection relatedEntities = new EntityReferenceCollection();
        for (String entityId : entityIds) {
            EntityReference relatedEntity = new EntityReference();
            Guid guid = new Guid();
            guid.setValue(entityId);
            relatedEntity.setId(guid);
            relatedEntity.setLogicalName(logicalName);
            relatedEntity.setName(name);
            relatedEntities.getEntityReferences().add(relatedEntity);
        }
        return relatedEntities;
    }

    public static AttributeCollection populateCollection(Map<String, Object> attributes, Iterable<AttributeMetadata> attributesMetadata) throws IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage {
        AttributeCollection attributeCollection = new AttributeCollection();
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            String valueAsString;
            String attributeName;
            if (entry.getKey().equalsIgnoreCase(K_FORMATTEDVALUESCOLLECTION)) continue;
            KeyValuePairOfstringanyType attribute = new KeyValuePairOfstringanyType();
            String attributeProperty = "";
            if (MetadataUtil.isLookupField(entry.getKey())) {
                attributeName = MetadataUtil.getLookupFieldName(entry.getKey());
                attributeProperty = MetadataUtil.getLookupEntityName(entry.getKey());
            } else {
                attributeName = entry.getKey();
            }
            attribute.setKey(attributeName);
            AttributeMetadata attributeMetadata = DynamicsCrmUtils.findInMetadata(attributeName, attributesMetadata);
            if (attributeMetadata == null) {
                attribute.setValue(entry.getValue());
            } else if (AttributeTypeCode.UNIQUEIDENTIFIER.equals((Object)attributeMetadata.getAttributeType())) {
                if (entry.getValue() != null && !Strings.isNullOrEmpty((String)(valueAsString = entry.getValue().toString()))) {
                    Guid guid = new Guid();
                    guid.setValue(valueAsString);
                    attribute.setValue(guid);
                }
            } else if (AttributeTypeCode.PICKLIST.equals((Object)attributeMetadata.getAttributeType()) || AttributeTypeCode.STATUS.equals((Object)attributeMetadata.getAttributeType()) || AttributeTypeCode.STATE.equals((Object)attributeMetadata.getAttributeType())) {
                Integer integerValue;
                try {
                    integerValue = Integer.parseInt(entry.getValue().toString());
                }
                catch (NumberFormatException nfe) {
                    integerValue = null;
                }
                if (integerValue != null) {
                    OptionSetValue optionSetValue = new OptionSetValue();
                    optionSetValue.setValue(integerValue);
                    attribute.setValue(optionSetValue);
                }
            } else if (AttributeTypeCode.MONEY.equals((Object)attributeMetadata.getAttributeType())) {
                if (entry.getValue() != null) {
                    Money money = new Money();
                    money.setValue(MathUtil.getBigDecimal(entry.getValue()));
                    attribute.setValue(money);
                }
            } else if (AttributeTypeCode.PARTY_LIST.equals((Object)attributeMetadata.getAttributeType())) {
                if (entry.getValue() != null) {
                    if (!(entry.getValue() instanceof List)) {
                        throw new IllegalArgumentException("The value of '" + attributeName + "' has to be a List<Map<String, String>>.");
                    }
                    ArrayOfEntity activityPartyEntities = new ArrayOfEntity();
                    List partyList = (List)entry.getValue();
                    for (Map activityPartyMap : partyList) {
                        for (String activityPartyKey : activityPartyMap.keySet()) {
                            String referencedEntityId = (String)activityPartyMap.get(activityPartyKey);
                            if (Strings.isNullOrEmpty((String)referencedEntityId)) continue;
                            String referencedEntityName = MetadataUtil.getLookupEntityName(activityPartyKey);
                            Guid guidId = new Guid();
                            guidId.setValue(referencedEntityId);
                            EntityReference entityReference = new EntityReference();
                            entityReference.setId(guidId);
                            entityReference.setLogicalName(referencedEntityName);
                            Entity activityParty = new Entity();
                            activityParty.setLogicalName("activityparty");
                            AttributeCollection activityPartyAttributeCollection = new AttributeCollection();
                            activityParty.setAttributes(activityPartyAttributeCollection);
                            KeyValuePairOfstringanyType partyidAttribute = new KeyValuePairOfstringanyType();
                            activityPartyAttributeCollection.getKeyValuePairOfstringanyTypes().add(partyidAttribute);
                            partyidAttribute.setKey("partyid");
                            partyidAttribute.setValue(entityReference);
                            activityPartyEntities.getEntities().add(activityParty);
                        }
                    }
                    EntityCollection activityPartyEntityCollection = new EntityCollection();
                    activityPartyEntityCollection.setEntities(activityPartyEntities);
                    attribute.setValue(activityPartyEntityCollection);
                }
            } else if (attributeMetadata instanceof LookupAttributeMetadata) {
                if (entry.getValue() != null && !Strings.isNullOrEmpty((String)(valueAsString = entry.getValue().toString()))) {
                    Guid guidId = new Guid();
                    guidId.setValue(valueAsString);
                    EntityReference entityReference = new EntityReference();
                    entityReference.setId(guidId);
                    entityReference.setLogicalName(attributeProperty);
                    attribute.setValue(entityReference);
                }
            } else {
                attribute.setValue(entry.getValue());
            }
            attributeCollection.getKeyValuePairOfstringanyTypes().add(attribute);
        }
        return attributeCollection;
    }

    public static OrganizationRequest createOrganizationRequest(String requestName, ParameterCollection parameterCollection) {
        OrganizationRequest request = new OrganizationRequest();
        request.setRequestName(requestName);
        request.setParameters(parameterCollection);
        return request;
    }

    public static String getXmlAsString(InputStream fetchXml) throws IOException, SAXException, TransformerException, ParserConfigurationException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(fetchXml);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(doc), new StreamResult(writer));
        transformer.setOutputProperty("indent", "no");
        return writer.toString();
    }

    private static AttributeMetadata findInMetadata(String key, Iterable<AttributeMetadata> attributesMetadata) {
        for (AttributeMetadata attr : attributesMetadata) {
            if (!key.equals(attr.getLogicalName())) continue;
            return attr;
        }
        return null;
    }
}

