/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.DynamicsCRMConnection;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model._07.system_collections.KeyValuePairOfstringanyType;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model._07.system_collections.KeyValuePairOfstringstring;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.serialization.Guid;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.ArrayOfEntity;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.AttributeCollection;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.Entity;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.EntityCollection;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.EntityReference;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.EntityReferenceCollection;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.Money;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.OptionSetValue;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.OrganizationRequest;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.OrganizationResponse;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.ParameterCollection;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.services.IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.metadata.AttributeMetadata;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.metadata.AttributeTypeCode;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.metadata.LookupAttributeMetadata;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2012.contracts.ExecuteMultipleResponseItem;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2012.contracts.OrganizationResponseCollection;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.service.exception.DynamicsCRMErrorType;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.service.exception.DynamicsCRMException;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils.MathUtil;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils.MetadataUtil;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils.StringUtil;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import jodd.bean.BeanUtil;
import org.mule.runtime.api.bulk.BulkItem;
import org.mule.runtime.api.bulk.BulkOperationResult;
import org.reflections.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicsCrmUtil {
    private static final Logger log = LoggerFactory.getLogger(DynamicsCrmUtil.class);
    private static final String FORMATTED_VALUES = "__formattedValues";

    public static AttributeCollection populateCollection(Map<String, Object> attributes, Iterable<AttributeMetadata> attributesMetadata) throws IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage {
        AttributeCollection attributeCollection = new AttributeCollection();
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            String attributeName;
            if (entry.getKey().equalsIgnoreCase(FORMATTED_VALUES)) continue;
            KeyValuePairOfstringanyType attribute = new KeyValuePairOfstringanyType();
            String attributeProperty = "";
            if (MetadataUtil.isLookupField(entry.getKey())) {
                attributeName = MetadataUtil.getLookupFieldName(entry.getKey());
                attributeProperty = MetadataUtil.getLookupEntityName(entry.getKey());
            } else {
                attributeName = entry.getKey();
            }
            attribute.setKey(attributeName);
            AttributeMetadata attributeMetadata = DynamicsCrmUtil.findInMetadata(attributeName, attributesMetadata);
            if (attributeMetadata == null) {
                attribute.setValue(entry.getValue());
            } else if (AttributeTypeCode.UNIQUEIDENTIFIER.equals((Object)attributeMetadata.getAttributeType())) {
                DynamicsCrmUtil.addGUIDValue(entry, attribute);
            } else if (AttributeTypeCode.PICKLIST.equals((Object)attributeMetadata.getAttributeType()) || AttributeTypeCode.STATUS.equals((Object)attributeMetadata.getAttributeType()) || AttributeTypeCode.STATE.equals((Object)attributeMetadata.getAttributeType())) {
                DynamicsCrmUtil.addNumberValue(entry, attribute);
            } else if (AttributeTypeCode.MONEY.equals((Object)attributeMetadata.getAttributeType())) {
                DynamicsCrmUtil.addMoneyValue(entry, attribute);
            } else if (AttributeTypeCode.PARTY_LIST.equals((Object)attributeMetadata.getAttributeType())) {
                DynamicsCrmUtil.addPartyListValue(entry, attribute, attributeName);
            } else if (attributeMetadata instanceof LookupAttributeMetadata) {
                DynamicsCrmUtil.addLookupAttributeMetadata(entry, attribute, attributeProperty);
            } else {
                attribute.setValue(entry.getValue());
            }
            attributeCollection.getKeyValuePairOfstringanyTypes().add(attribute);
        }
        return attributeCollection;
    }

    private static void addGUIDValue(Map.Entry<String, Object> entry, KeyValuePairOfstringanyType attribute) {
        String valueAsString;
        if (entry.getValue() != null && StringUtil.isNotBlank(valueAsString = entry.getValue().toString())) {
            Guid guid = new Guid();
            guid.setValue(valueAsString);
            attribute.setValue(guid);
        }
    }

    private static void addNumberValue(Map.Entry<String, Object> entry, KeyValuePairOfstringanyType attribute) {
        Integer integerValue;
        try {
            integerValue = Integer.parseInt(entry.getValue().toString());
        }
        catch (NumberFormatException nfe) {
            integerValue = null;
        }
        if (integerValue != null) {
            OptionSetValue optionSetValue = new OptionSetValue();
            optionSetValue.setValue(integerValue);
            attribute.setValue(optionSetValue);
        }
    }

    private static void addMoneyValue(Map.Entry<String, Object> entry, KeyValuePairOfstringanyType attribute) {
        if (entry.getValue() != null) {
            Money money = new Money();
            money.setValue(MathUtil.getBigDecimal(entry.getValue()));
            attribute.setValue(money);
        }
    }

    private static void addPartyListValue(Map.Entry<String, Object> entry, KeyValuePairOfstringanyType attribute, String attributeName) {
        if (entry.getValue() != null) {
            if (!(entry.getValue() instanceof List)) {
                throw new IllegalArgumentException("The value of '" + attributeName + "' has to be a List<Map<String, String>>.");
            }
            ArrayOfEntity activityPartyEntities = new ArrayOfEntity();
            List partyList = (List)entry.getValue();
            for (Map activityPartyMap : partyList) {
                for (String activityPartyKey : activityPartyMap.keySet()) {
                    String referencedEntityId = (String)activityPartyMap.get(activityPartyKey);
                    if (!StringUtil.isNotBlank(referencedEntityId)) continue;
                    String referencedEntityName = MetadataUtil.getLookupEntityName(activityPartyKey);
                    Guid guidId = new Guid();
                    guidId.setValue(referencedEntityId);
                    EntityReference entityReference = new EntityReference();
                    entityReference.setId(guidId);
                    entityReference.setLogicalName(referencedEntityName);
                    Entity activityParty = new Entity();
                    activityParty.setLogicalName("activityparty");
                    AttributeCollection activityPartyAttributeCollection = new AttributeCollection();
                    activityParty.setAttributes(activityPartyAttributeCollection);
                    KeyValuePairOfstringanyType partyidAttribute = new KeyValuePairOfstringanyType();
                    activityPartyAttributeCollection.getKeyValuePairOfstringanyTypes().add(partyidAttribute);
                    partyidAttribute.setKey("partyid");
                    partyidAttribute.setValue(entityReference);
                    activityPartyEntities.getEntities().add(activityParty);
                }
            }
            EntityCollection activityPartyEntityCollection = new EntityCollection();
            activityPartyEntityCollection.setEntities(activityPartyEntities);
            attribute.setValue(activityPartyEntityCollection);
        }
    }

    private static void addLookupAttributeMetadata(Map.Entry<String, Object> entry, KeyValuePairOfstringanyType attribute, String attributeProperty) {
        String valueAsString;
        if (entry.getValue() != null && StringUtil.isNotBlank(valueAsString = entry.getValue().toString())) {
            Guid guidId = new Guid();
            guidId.setValue(valueAsString);
            EntityReference entityReference = new EntityReference();
            entityReference.setId(guidId);
            entityReference.setLogicalName(attributeProperty);
            attribute.setValue(entityReference);
        }
    }

    private static AttributeMetadata findInMetadata(String key, Iterable<AttributeMetadata> attributesMetadata) {
        for (AttributeMetadata attr : attributesMetadata) {
            if (!key.equals(attr.getLogicalName())) continue;
            return attr;
        }
        return null;
    }

    public static OrganizationRequest createOrganizationRequest(String requestName, ParameterCollection parameterCollection) {
        OrganizationRequest request = new OrganizationRequest();
        request.setRequestName(requestName);
        request.setParameters(parameterCollection);
        return request;
    }

    public static String toXMLString(JAXBElement<?> input, DynamicsCRMConnection connection) {
        try {
            StringWriter writer = new StringWriter();
            connection.getMarshaller().setProperty("jaxb.formatted.output", (Object)true);
            connection.getMarshaller().marshal(input, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            throw new DynamicsCRMException(DynamicsCRMErrorType.TRANSFORMATION, e);
        }
    }

    public static JAXBElement wrap(Object input) {
        try {
            Class<?> objectFactory = Class.forName(input.getClass().getPackage().getName() + ".ObjectFactory");
            Method creator = (Method)Iterables.getOnlyElement((Iterable)ReflectionUtils.getMethods(objectFactory, (Predicate[])new Predicate[]{m -> m.getParameterCount() == 1 && m.getParameterTypes()[0].equals(input.getClass())}));
            creator.setAccessible(true);
            return (JAXBElement)JAXBElement.class.cast(creator.invoke(objectFactory.newInstance(), input));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            return new JAXBElement(new QName(StringUtil.uncapitalize(input.getClass().getSimpleName())), input.getClass(), input);
        }
    }

    public static <T> BulkOperationResult<T> getResults(OrganizationResponse responseWithMultiple, List<T> payloads) throws IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage {
        BulkOperationResult.BulkOperationResultBuilder builder = BulkOperationResult.builder();
        ParameterCollection results = responseWithMultiple.getResults();
        if (results != null) {
            KeyValuePairOfstringanyType pair = null;
            Optional<KeyValuePairOfstringanyType> keyValuePairOfstringanyType = results.getKeyValuePairOfstringanyTypes().stream().filter(item -> item.getKey().equals("Responses")).findFirst();
            if (keyValuePairOfstringanyType.isPresent()) {
                pair = keyValuePairOfstringanyType.get();
            }
            if (pair != null) {
                List<ExecuteMultipleResponseItem> items;
                Object responseValue = pair.getValue();
                if (responseValue instanceof OrganizationResponseCollection) {
                    items = ((OrganizationResponseCollection)pair.getValue()).getExecuteMultipleResponseItems();
                } else if (responseValue instanceof com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._7_1.contracts.OrganizationResponseCollection) {
                    items = new ArrayList<ExecuteMultipleResponseItem>();
                    for (OrganizationResponse response : ((com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._7_1.contracts.OrganizationResponseCollection)pair.getValue()).getOrganizationResponses()) {
                        ExecuteMultipleResponseItem fakeItem = new ExecuteMultipleResponseItem();
                        fakeItem.setResponse(response);
                        items.add(fakeItem);
                    }
                } else {
                    throw new IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage("Unrecognized response value type: " + responseValue.getClass().getName());
                }
                for (int i = 0; i < items.size(); ++i) {
                    OrganizationResponse payload = null;
                    if (payloads != null) {
                        payload = (OrganizationResponse)payloads.get(i);
                    } else {
                        try {
                            OrganizationResponse response = items.get(i).getResponse();
                            payload = response != null ? DynamicsCrmUtil.promoteParametersToMembers(response) : null;
                        }
                        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                            log.warn("While promoting parameters to members for bulk operations on item " + i, (Throwable)e);
                        }
                    }
                    builder.addItem(DynamicsCrmUtil.createBulkItemBuilder(items.get(i), payload));
                }
            }
        }
        return builder.build();
    }

    private static <T> BulkItem.BulkItemBuilder<T> createBulkItemBuilder(ExecuteMultipleResponseItem item, T payload) {
        BulkItem.BulkItemBuilder bulkItemBuilder = BulkItem.builder();
        bulkItemBuilder.setSuccessful(item.getFault() == null);
        bulkItemBuilder.setPayload(payload);
        if (item.getFault() != null) {
            IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage fault = new IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage(item.getFault().getMessage(), item.getFault());
            bulkItemBuilder.setException((Exception)fault);
            bulkItemBuilder.setMessage(item.getFault().getMessage());
            bulkItemBuilder.setStatusCode(item.getFault().getErrorCode().toString());
        } else {
            List<KeyValuePairOfstringanyType> resultsMap = item.getResponse().getResults().getKeyValuePairOfstringanyTypes();
            for (KeyValuePairOfstringanyType result : resultsMap) {
                bulkItemBuilder.setRecordId((Serializable)((Object)((Guid)result.getValue()).getValue()));
            }
        }
        return bulkItemBuilder;
    }

    public static OrganizationResponse promoteParametersToMembers(OrganizationResponse response) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        OrganizationResponse result;
        try {
            result = (OrganizationResponse)DynamicsCrmUtil.getRequestOrResponseClass(response.getResponseName(), "Response").newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.warn("Response class for operation " + response.getResponseName() + " not found", (Throwable)e);
            return response;
        }
        catch (ClassNotFoundException e) {
            log.debug("Response class for custom operation " + response.getResponseName(), (Throwable)e);
            return response;
        }
        result.setResponseName(response.getResponseName());
        DynamicsCrmUtil.fillPropertiesWithParameters(response.getResults(), result);
        return result;
    }

    public static void promoteMembersToParameters(OrganizationRequest request) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Field[] fields;
        if (OrganizationRequest.class.equals(request.getClass())) {
            return;
        }
        for (Field field : fields = request.getClass().getDeclaredFields()) {
            if (!DynamicsCrmUtil.shouldProcessProperty(field.getName())) continue;
            XmlElement xmlElement = field.getAnnotation(XmlElement.class);
            Object obj = BeanUtil.pojo.getProperty((Object)request, field.getName());
            DynamicsCrmUtil.addParameter(request, xmlElement.name(), obj);
        }
    }

    private static boolean shouldProcessProperty(String propertyName) {
        return !propertyName.equalsIgnoreCase("serialVersionUID") && !propertyName.equalsIgnoreCase("requestId") && !propertyName.equalsIgnoreCase("requestName") && !propertyName.equalsIgnoreCase("parameters") && !propertyName.startsWith("$");
    }

    private static <T> OrganizationRequest addParameter(OrganizationRequest request, String string, T value) {
        if (request.getParameters() == null) {
            request.setParameters(new ParameterCollection());
        }
        KeyValuePairOfstringanyType e = new KeyValuePairOfstringanyType();
        e.setKey(string);
        e.setValue(value);
        request.getParameters().getKeyValuePairOfstringanyTypes().add(e);
        return request;
    }

    private static void fillPropertiesWithParameters(ParameterCollection parameters, OrganizationResponse result) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Field[] fields;
        for (Field field : fields = result.getClass().getDeclaredFields()) {
            if (field.getName().equalsIgnoreCase("serialVersionUID") || field.getName().startsWith("$")) continue;
            XmlElement xmlElement = field.getAnnotation(XmlElement.class);
            Optional<KeyValuePairOfstringanyType> parameterKey = parameters.getKeyValuePairOfstringanyTypes().stream().filter(param -> param.getKey().equalsIgnoreCase(xmlElement.name())).findFirst();
            Object entry = parameterKey.isPresent() ? parameterKey.get().getValue() : new KeyValuePairOfstringanyType();
            BeanUtil.pojo.setProperty((Object)result, field.getName(), entry);
        }
    }

    public static Class<?> getRequestOrResponseClass(String entityName, String classEnding) throws ClassNotFoundException {
        Class<?> result;
        String className = "com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.contracts." + StringUtil.capitalize(entityName) + classEnding;
        try {
            result = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            className = "com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts." + StringUtil.capitalize(entityName) + classEnding;
            result = Class.forName(className);
        }
        return result;
    }

    public static Map<String, Object> mapEntityToMap(Entity entity) {
        HashMap<String, Object> entityMap = new HashMap<String, Object>();
        for (KeyValuePairOfstringanyType attribute : entity.getAttributes().getKeyValuePairOfstringanyTypes()) {
            Object value = attribute.getValue();
            if (value instanceof Guid) {
                value = ((Guid)value).getValue();
                entityMap.put(attribute.getKey(), value);
                continue;
            }
            if (value instanceof EntityReference) {
                EntityReference valueAsEntityReference = (EntityReference)value;
                value = valueAsEntityReference.getId().getValue();
                entityMap.put(MetadataUtil.buildLookupField(attribute.getKey(), valueAsEntityReference.getLogicalName()), value);
                continue;
            }
            if (value instanceof OptionSetValue) {
                OptionSetValue valueAsOptionSetValue = (OptionSetValue)value;
                entityMap.put(attribute.getKey(), valueAsOptionSetValue.getValue());
                continue;
            }
            if (value instanceof Money) {
                Money valueAsMoney = (Money)value;
                entityMap.put(attribute.getKey(), valueAsMoney.getValue().doubleValue());
                continue;
            }
            if (value instanceof XMLGregorianCalendar) {
                XMLGregorianCalendar valueAsXMLGregorianCalendar = (XMLGregorianCalendar)value;
                entityMap.put(attribute.getKey(), valueAsXMLGregorianCalendar.toString());
                continue;
            }
            if (value instanceof EntityCollection) {
                ArrayList<Map<String, String>> activityPartyReferences = new ArrayList<Map<String, String>>();
                EntityCollection valueAsEntityCollection = (EntityCollection)value;
                if (valueAsEntityCollection.getEntities() != null) {
                    DynamicsCrmUtil.buildActivityPartyEntity(attribute, activityPartyReferences, valueAsEntityCollection);
                }
                entityMap.put(attribute.getKey(), activityPartyReferences);
                continue;
            }
            entityMap.put(attribute.getKey(), value);
        }
        HashMap<String, String> formattedValues = new HashMap<String, String>();
        for (KeyValuePairOfstringstring formattedValue : entity.getFormattedValues().getKeyValuePairOfstringstrings()) {
            formattedValues.put(formattedValue.getKey(), formattedValue.getValue());
        }
        entityMap.put(FORMATTED_VALUES, formattedValues);
        return entityMap;
    }

    private static void buildActivityPartyEntity(KeyValuePairOfstringanyType attribute, List<Map<String, String>> activityPartyReferences, EntityCollection valueAsEntityCollection) {
        if ("activityparty".equalsIgnoreCase(valueAsEntityCollection.getEntityName())) {
            for (Entity activityParty : valueAsEntityCollection.getEntities().getEntities()) {
                if (activityParty.getAttributes() == null) continue;
                for (KeyValuePairOfstringanyType activityPartyAttribute : activityParty.getAttributes().getKeyValuePairOfstringanyTypes()) {
                    if (!"partyid".equalsIgnoreCase(activityPartyAttribute.getKey()) || activityPartyAttribute.getValue() == null || !(activityPartyAttribute.getValue() instanceof EntityReference)) continue;
                    EntityReference activityPartyEntityReference = (EntityReference)activityPartyAttribute.getValue();
                    String activityPartyEntityReferenceName = MetadataUtil.buildLookupField(attribute.getKey(), activityPartyEntityReference.getLogicalName());
                    String activityPartyEntityReferenceId = activityPartyEntityReference.getId().getValue();
                    HashMap<String, String> activityPartyEntityReferenceMap = new HashMap<String, String>();
                    activityPartyEntityReferenceMap.put(activityPartyEntityReferenceName, activityPartyEntityReferenceId);
                    activityPartyReferences.add(activityPartyEntityReferenceMap);
                }
            }
        }
    }

    public static List<Map<String, Object>> mapEntityCollectionToMapCollection(EntityCollection entityCollection) {
        ArrayList<Map<String, Object>> entities = new ArrayList<Map<String, Object>>();
        for (Entity entity : entityCollection.getEntities().getEntities()) {
            entities.add(DynamicsCrmUtil.mapEntityToMap(entity));
        }
        return entities;
    }

    public static EntityReferenceCollection mapIdsToEntityReferenceCollection(String name, String logicalName, List<String> entityIds) {
        EntityReferenceCollection relatedEntities = new EntityReferenceCollection();
        for (String entityId : entityIds) {
            EntityReference relatedEntity = new EntityReference();
            Guid guid = new Guid();
            guid.setValue(entityId);
            relatedEntity.setId(guid);
            relatedEntity.setLogicalName(logicalName);
            relatedEntity.setName(name);
            relatedEntities.getEntityReferences().add(relatedEntity);
        }
        return relatedEntities;
    }
}

