/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.service.utils;

import com.mulesoft.connectors.microsoft.dynamics.crm.internal.service.connection.soap.XmlTypeField;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class BeanUtils {
    private static final Logger logger = LoggerFactory.getLogger(BeanUtils.class);
    public static final String LIST_TYPE = "List";
    private static final String STRING_TYPE = "java.lang.String";
    private static final String PRIMITIVE_TYPE = "Primitive";
    public static final String POJO_TYPE = "Pojo";

    private BeanUtils() {
    }

    public static String isListOrPojo(Class type) {
        if (type.isAssignableFrom(List.class)) {
            return LIST_TYPE;
        }
        if (ClassUtils.isPrimitiveOrWrapper((Class)type) || STRING_TYPE.equals(type.getName())) {
            return PRIMITIVE_TYPE;
        }
        return POJO_TYPE;
    }

    public static List<XmlTypeField> getXmlTypeFields(Class<?> type) {
        ArrayList<XmlTypeField> xmlTypeFields = new ArrayList<XmlTypeField>();
        String[] propOrderFields = BeanUtils.getPropOrderFields(type);
        for (Field field : type.getDeclaredFields()) {
            if (!field.isAnnotationPresent(XmlElement.class) && !Arrays.asList(propOrderFields).contains(field.getName())) continue;
            String fieldName = BeanUtils.getXmlElementAnnotationName(field);
            xmlTypeFields.add(new XmlTypeField(field.getType(), fieldName, BeanUtils.getListFieldGenericType(field)));
        }
        return xmlTypeFields;
    }

    public static String getXmlElementAnnotationName(Field field) {
        String fieldName = field.getName();
        if (field.isAnnotationPresent(XmlElement.class)) {
            XmlElement xmlElement = field.getAnnotation(XmlElement.class);
            fieldName = xmlElement.name().equals("##default") ? field.getName() : xmlElement.name();
        }
        return fieldName;
    }

    private static String[] getPropOrderFields(Class<?> type) {
        try {
            return type.getAnnotation(XmlType.class).propOrder();
        }
        catch (Exception e) {
            logger.debug(String.format("Failed to get XmlType annotation and its properties from class %s", type), (Throwable)e);
            return new String[0];
        }
    }

    private static Class getListFieldGenericType(Field field) {
        if (BeanUtils.isListOrPojo(field.getType()).equals(LIST_TYPE)) {
            ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
            return (Class)parameterizedType.getActualTypeArguments()[0];
        }
        return null;
    }
}

