/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.service.connection.soap;

import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.parameters.OnlineCredentials;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online.MicrosoftOnlineAuthenticationPolicy;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online.Office365TokenRetriever;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online.exception.AuthenticationPolicyException;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online.exception.InvalidWSDLInfoException;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.services.IOrganizationService;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.service.connection.soap.DynamicsCRMSoapClientProvider;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.service.exception.DynamicsCRMErrorType;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.service.exception.DynamicsCRMException;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils.ExceptionUtils;
import java.net.MalformedURLException;
import java.net.URL;
import javax.net.ssl.SSLHandshakeException;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceFeature;
import joptsimple.internal.Strings;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.transport.http.HTTPConduit;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.http.api.HttpService;

public class OnlineSoapClientProvider
extends DynamicsCRMSoapClientProvider {
    private static final String DEFAULT_PORT_NAME = "{http://schemas.microsoft.com/ws/2008/06/identity/securitytokenservice}UserNameWSTrustBinding_IWSTrust13Async";
    private OnlineCredentials credentials;

    public OnlineSoapClientProvider(OnlineCredentials credentials, boolean policyEngineEnabled, HttpService httpService, WebServiceFeature ... features) throws ConnectionException {
        super(credentials, policyEngineEnabled, httpService, features);
        this.credentials = credentials;
    }

    @Override
    protected void testClientConnectivity(IOrganizationService client, String organizationServiceUrl) throws ConnectionException {
        try {
            this.callSimpleQueryToTestConnection(client);
        }
        catch (SoapFault e) {
            if (e.getSubCode() != null && "FailedAuthentication".equalsIgnoreCase(e.getSubCode().getLocalPart())) {
                throw new ConnectionException("Exception when trying to acquire token.", (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            SSLHandshakeException sslHandshakeException = ExceptionUtils.getDeepestOccurenceOfType(e, SSLHandshakeException.class);
            if (sslHandshakeException != null) {
                throw new DynamicsCRMException("SSL certificate error when connecting to: " + organizationServiceUrl, DynamicsCRMErrorType.INVALID_CERTIFICATE, e);
            }
            throw new DynamicsCRMException("Unable to build the service client from: " + organizationServiceUrl, DynamicsCRMErrorType.CONNECTIVITY, e);
        }
    }

    @Override
    protected IOrganizationService createOrganizationServiceClient() throws ConnectionException {
        URL organizationServiceWsdlUrl;
        MicrosoftOnlineAuthenticationPolicy authenticationPolicy;
        try {
            authenticationPolicy = new MicrosoftOnlineAuthenticationPolicy(this.credentials.getOrganizationServiceUrl() + "?WSDL=wsdl0", this.credentials.getProxySettingsParams());
        }
        catch (AuthenticationPolicyException | InvalidWSDLInfoException ex) {
            throw new DynamicsCRMException(ex.getMessage(), DynamicsCRMErrorType.INCOMPLETE_WSDL, ex);
        }
        catch (Exception e) {
            throw new DynamicsCRMException("Error trying to create the security policy", DynamicsCRMErrorType.INVALID_CERTIFICATE, e);
        }
        try {
            organizationServiceWsdlUrl = new URL(this.credentials.getOrganizationServiceUrl() + "?wsdl");
        }
        catch (MalformedURLException e) {
            throw new DynamicsCRMException("Malformed organization service url: " + this.credentials.getOrganizationServiceUrl(), DynamicsCRMErrorType.INVALID_URL, e);
        }
        IOrganizationService client = this.getNewClientInstance(organizationServiceWsdlUrl, true, new WebServiceFeature[0]);
        Client cxfClient = ClientProxy.getClient((Object)client);
        cxfClient.getRequestContext().put("set-jaxb-validation-event-handler", "false");
        cxfClient.getRequestContext().put("ws-security.username", this.credentials.getUsername());
        cxfClient.getRequestContext().put("ws-security.password", this.credentials.getAuthPassword());
        if (!Strings.isNullOrEmpty((String)this.credentials.getStsMetadataUrl())) {
            cxfClient.getRequestContext().put("AuthenticationPolicy.StsMetadataUrl", this.credentials.getStsMetadataUrl());
        }
        BindingProvider provider = (BindingProvider)client;
        provider.getRequestContext().remove("javax.xml.ws.service.endpoint.address");
        cxfClient.getRequestContext().put("AuthenticationPolicy.PortName", !Strings.isNullOrEmpty((String)this.credentials.getStsUsernamePortQname()) ? this.credentials.getStsUsernamePortQname() : DEFAULT_PORT_NAME);
        cxfClient.getRequestContext().put("AuthenticationPolicy.OrganizationServiceUrl", this.credentials.getOrganizationServiceUrl());
        cxfClient.getRequestContext().put("AuthenticationPolicy.OnlineAuthenticationPolicy", authenticationPolicy);
        cxfClient.getRequestContext().put("AuthenticationPolicy.OnlineTokenRetriever", new Office365TokenRetriever(this.createHttpClientService()));
        cxfClient.getRequestContext().put("AuthenticationPolicy.AuthenticationRetries", this.credentials.getAuthenticationRetries() < 1 ? 1 : this.credentials.getAuthenticationRetries());
        return client;
    }

    @Override
    protected void configureHttpConduit(HTTPConduit httpConduit) {
        super.configureHttpConduit(httpConduit);
        AuthorizationPolicy authorization = new AuthorizationPolicy();
        authorization.setUserName(this.credentials.getUsername());
        authorization.setPassword(this.credentials.getAuthPassword());
        authorization.setAuthorizationType("Basic");
        httpConduit.setAuthorization(authorization);
    }
}

