/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.service.connection.soap;

import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.parameters.NtlmCredentials;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.services.IOrganizationService;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.service.connection.soap.DynamicsCRMSoapClientProvider;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.service.connection.soap.client.interceptors.NtlmConnectionRoutingInterceptor;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.service.exception.DynamicsCRMErrorType;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.service.exception.DynamicsCRMException;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils.ExceptionUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import javax.net.ssl.SSLHandshakeException;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.transport.common.gzip.GZIPOutInterceptor;
import org.apache.cxf.transport.http.HTTPConduit;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.http.api.HttpService;

public class NtlmSoapClientProvider
extends DynamicsCRMSoapClientProvider {
    private NtlmCredentials credentials;

    public NtlmSoapClientProvider(NtlmCredentials credentials, boolean policyEngineEnabled, HttpService httpService, WebServiceFeature ... features) throws ConnectionException {
        super(credentials, policyEngineEnabled, httpService, features);
        this.credentials = credentials;
    }

    @Override
    protected void testClientConnectivity(IOrganizationService client, String organizationServiceUrl) throws ConnectionException {
        try {
            this.callSimpleQueryToTestConnection(client);
        }
        catch (Exception e) {
            SSLHandshakeException sslHandshakeException = ExceptionUtils.getFirstOccurenceOfType(e, SSLHandshakeException.class);
            if (sslHandshakeException != null) {
                String sslExceptionMessage = sslHandshakeException.getMessage();
                String url = organizationServiceUrl;
                Matcher matcher = urlPattern.matcher(sslExceptionMessage);
                while (matcher.find()) {
                    int matchStart = matcher.start(1);
                    int matchEnd = matcher.end() - 1;
                    url = sslExceptionMessage.substring(matchStart, matchEnd);
                }
                throw new DynamicsCRMException("SSL certificate error when connecting to: " + url, DynamicsCRMErrorType.INVALID_CERTIFICATE, e);
            }
            SOAPFaultException faultException = ExceptionUtils.getFirstOccurenceOfType(e, SOAPFaultException.class);
            if (faultException != null) {
                if (StringUtils.contains((CharSequence)faultException.getMessage(), (CharSequence)"The security token could not be authenticated")) {
                    throw new ConnectionException("Invalid Token", (Throwable)faultException);
                }
                throw new DynamicsCRMException("Error when trying to access the service. This may be caused by incorrect credentials. Error details: " + faultException.getMessage(), DynamicsCRMErrorType.INVALID_CREDENTIALS, (Throwable)faultException);
            }
            throw new ConnectionException("Unable to query the service: " + organizationServiceUrl, (Throwable)e);
        }
    }

    @Override
    protected IOrganizationService createOrganizationServiceClient() throws ConnectionException {
        URL organizationServiceWsdlUrl;
        try {
            organizationServiceWsdlUrl = new URL(this.credentials.getOrganizationServiceUrl() + "?wsdl");
        }
        catch (MalformedURLException e) {
            throw new DynamicsCRMException("Malformed organization service url: " + this.credentials.getOrganizationServiceUrl(), DynamicsCRMErrorType.INVALID_URL, e);
        }
        this.getOrganizationServiceWsdl(organizationServiceWsdlUrl);
        IOrganizationService client = this.getNewClientInstance(organizationServiceWsdlUrl, false, new WebServiceFeature[]{new AddressingFeature(true, false)});
        ((BindingProvider)client).getRequestContext().remove(GZIPOutInterceptor.USE_GZIP_KEY);
        Client cxfClient = ClientProxy.getClient((Object)client);
        BindingProvider provider = (BindingProvider)client;
        provider.getRequestContext().put("javax.xml.ws.service.endpoint.address", this.credentials.getGatewayUrl());
        cxfClient.getEndpoint().getEndpointInfo().setProperty("set-jaxb-validation-event-handler", (Object)"false");
        cxfClient.getOutInterceptors().add(new NtlmConnectionRoutingInterceptor(this.credentials.getOrganizationServiceUrl()));
        return client;
    }

    @Override
    protected void configureHttpConduit(HTTPConduit httpConduit) {
        super.configureHttpConduit(httpConduit);
        AuthorizationPolicy authorization = new AuthorizationPolicy();
        authorization.setUserName(this.credentials.getUsername());
        authorization.setPassword(this.credentials.getAuthPassword());
        authorization.setAuthorizationType("Basic");
        httpConduit.setAuthorization(authorization);
    }
}

