/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.service.connection.soap;

import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.parameters.AdvancedParams;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.parameters.Credentials;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.parameters.ProxySettingsParams;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.utils.DynamicsCrmConnectionUtils;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.FetchExpression;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.OrganizationService;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.services.IOrganizationService;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.services.IOrganizationServiceRetrieveMultipleOrganizationServiceFaultFaultFaultMessage;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.service.exception.DynamicsCRMErrorType;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.service.exception.DynamicsCRMException;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils.DynamicsCrmUtils;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils.ExceptionUtils;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils.HttpClientService;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.net.ssl.SSLHandshakeException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceFeature;
import joptsimple.internal.Strings;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.EndpointImpl;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.transport.common.gzip.GZIPInInterceptor;
import org.apache.cxf.transport.common.gzip.GZIPOutInterceptor;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HTTPConduitConfigurer;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.client.proxy.ProxyConfigBuilder;
import org.mule.runtime.http.api.tcp.TcpClientSocketProperties;
import org.mule.runtime.http.api.tcp.TcpClientSocketPropertiesBuilder;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class DynamicsCRMSoapClientProvider {
    private static final String HTTPS_PROTOCOLS_SYSTEM_PROPERTY_KEY = "https.protocols";
    private static final String HTTP_CLIENT_CONFIG = "httpClientConfig";
    protected Credentials credentials;
    protected boolean policyEngineEnabled;
    protected WebServiceFeature[] features;
    private static final Log log = LogFactory.getLog(DynamicsCRMSoapClientProvider.class);
    protected static final Pattern urlPattern = Pattern.compile("(?:^|[\\W])((ht|f)tp(s?):\\/\\/|www\\.)(([\\w\\-]+\\.){1,}?([\\w\\-.~]+\\/?)*[\\p{Alnum}.,%_=?&#\\-+()\\[\\]\\*$~@!:/{};']*)", 42);
    private HttpService httpService;

    public DynamicsCRMSoapClientProvider(Credentials credentials, boolean policyEngineEnabled, HttpService httpService, WebServiceFeature ... features) throws ConnectionException {
        this.credentials = credentials;
        this.policyEngineEnabled = policyEngineEnabled;
        this.features = features;
        this.httpService = httpService;
        if (Strings.isNullOrEmpty((String)credentials.getUsername())) {
            throw new DynamicsCRMException("'Username's is mandatory.", DynamicsCRMErrorType.INVALID_CREDENTIALS);
        }
        if (!SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_7)) {
            throw new DynamicsCRMException("Java 1.7 or later is needed in order to run the 'Microsoft Dynamics CRM'  connector.", DynamicsCRMErrorType.INVALID_JDK_VERSION);
        }
        String jceNotInstalledErrorMessage = "Java Cryptography Extensions are not installed. The JCE package is required to allow the Connector to use HTTPS to communicate securely with CRM. Please install JCE for your Java version from the Sun website: http://www.oracle.com/technetwork/java/javase/downloads/index.html";
        try {
            if (Cipher.getMaxAllowedKeyLength("AES") == 128) {
                throw new DynamicsCRMException(jceNotInstalledErrorMessage, DynamicsCRMErrorType.UNKNOWN);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new DynamicsCRMException(jceNotInstalledErrorMessage, DynamicsCRMErrorType.INVALID_CRYPTOGRAPHIC_ALGORITHM, e);
        }
        if (credentials.getAdvancedParams().getConnectionTimeout() == null) {
            credentials.getAdvancedParams().setConnectionTimeout(60);
        }
        if (credentials.isDisableCnCheck()) {
            DynamicsCrmConnectionUtils.disableCnCheckInHttpsURLConnection();
        } else {
            DynamicsCrmConnectionUtils.restoreCnCheckInHttpsURLConnection();
        }
    }

    public IOrganizationService createSoapClient() throws ConnectionException {
        IOrganizationService client = this.createOrganizationServiceClient();
        Client cxfClient = ClientProxy.getClient((Object)client);
        if (this.credentials.isDisableCnCheck()) {
            cxfClient.getRequestContext().put("AuthenticationPolicy.DisableCnCheck", true);
        }
        this.testClientConnectivity(client, this.credentials.getOrganizationServiceUrl());
        return client;
    }

    protected OrganizationService getNewServiceInstance(Bus bus, URL organizationServiceWsdlUrl) {
        Bus originalBus = BusFactory.getAndSetThreadDefaultBus((Bus)bus);
        try {
            OrganizationService organizationService = new OrganizationService(organizationServiceWsdlUrl);
            return organizationService;
        }
        catch (Exception e) {
            SSLHandshakeException sslHandshakeException = ExceptionUtils.getFirstOccurenceOfType(e, SSLHandshakeException.class);
            if (sslHandshakeException != null) {
                throw new DynamicsCRMException("SSL certificate error when connecting to: " + organizationServiceWsdlUrl, DynamicsCRMErrorType.INVALID_CERTIFICATE, e);
            }
            throw new DynamicsCRMException("Unable to build the service client from: " + organizationServiceWsdlUrl, DynamicsCRMErrorType.CONNECTIVITY, e);
        }
        finally {
            BusFactory.setThreadDefaultBus((Bus)originalBus);
        }
    }

    protected Document getOrganizationServiceWsdl(URL organizationServiceWsdlUrl) throws ConnectionException {
        log.debug((Object)("Getting WSDL to configure WS from: " + organizationServiceWsdlUrl.toString()));
        HttpURLConnection connection = null;
        InputStream xml = null;
        try {
            Proxy proxy = DynamicsCrmConnectionUtils.createProxyConnection(this.credentials.getProxySettingsParams());
            connection = proxy != null ? (HttpURLConnection)organizationServiceWsdlUrl.openConnection(proxy) : (HttpURLConnection)organizationServiceWsdlUrl.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Accept", "application/xml");
            xml = connection.getInputStream();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(xml);
            return document;
        }
        catch (ConnectException ce) {
            throw new ConnectionException(ce.getMessage() + " " + organizationServiceWsdlUrl.toString(), (Throwable)ce);
        }
        catch (UnknownHostException uhe) {
            throw new DynamicsCRMException("Unknown host " + uhe.getMessage(), DynamicsCRMErrorType.INVALID_URL, uhe);
        }
        catch (FileNotFoundException fnfEx) {
            throw new DynamicsCRMException("The url does not exist " + fnfEx.getMessage(), DynamicsCRMErrorType.INVALID_URL, fnfEx);
        }
        catch (SSLHandshakeException e) {
            throw new DynamicsCRMException("SSL certificate error when connecting to: " + organizationServiceWsdlUrl.toString(), DynamicsCRMErrorType.INVALID_CERTIFICATE, e);
        }
        catch (IOException ioEx) {
            throw new DynamicsCRMException(ioEx.getMessage(), DynamicsCRMErrorType.UNKNOWN, ioEx);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new DynamicsCRMException("Error when parsing document from: " + organizationServiceWsdlUrl.toString(), DynamicsCRMErrorType.UNKNOWN, e);
        }
        finally {
            if (xml != null) {
                try {
                    xml.close();
                }
                catch (IOException e) {
                    log.debug((Object)e);
                }
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    protected IOrganizationService getNewClientInstance(URL organizationServiceWsdlUrl, boolean policyEngineEnabled, WebServiceFeature ... features) {
        Bus bus = this.getNewBusForClient(policyEngineEnabled);
        IOrganizationService client = this.getNewServiceInstance(bus, organizationServiceWsdlUrl).getCustomBindingIOrganizationService(features);
        Client cxfClient = ClientProxy.getClient((Object)client);
        ((EndpointImpl)cxfClient.getEndpoint()).setBus(bus);
        cxfClient.getInInterceptors().add(new GZIPInInterceptor());
        cxfClient.getOutInterceptors().add(new GZIPOutInterceptor());
        ((BindingProvider)client).getRequestContext().put(GZIPOutInterceptor.USE_GZIP_KEY, GZIPOutInterceptor.UseGzip.NO);
        return client;
    }

    protected Bus getNewBusForClient(boolean policyEngineEnabled) {
        Bus bus = BusFactory.newInstance().createBus();
        DynamicsCrmConnectionUtils.configurePolicies(bus, this.credentials.getProxySettingsParams());
        class CustomHTTPConduitConfigurer
        implements HTTPConduitConfigurer {
            CustomHTTPConduitConfigurer() {
            }

            public void configure(String name, String address, HTTPConduit c) {
                DynamicsCRMSoapClientProvider.this.configureHttpConduit(c);
            }
        }
        bus.setExtension((Object)new CustomHTTPConduitConfigurer(), HTTPConduitConfigurer.class);
        ((PolicyEngine)bus.getExtension(PolicyEngine.class)).setEnabled(policyEngineEnabled);
        return bus;
    }

    protected void configureHttpConduit(HTTPConduit httpConduit) {
        HTTPClientPolicy policy = httpConduit.getClient();
        if (policy == null) {
            httpConduit.setClient(new HTTPClientPolicy());
        }
        if (this.credentials.isDisableCnCheck()) {
            DynamicsCrmConnectionUtils.disableCnCheck(httpConduit);
        }
        DynamicsCrmConnectionUtils.setReceiveTimeout(httpConduit, this.credentials.getAdvancedParams().getConnectionTimeout());
        DynamicsCrmConnectionUtils.setProxyConnection(httpConduit, this.credentials.getProxySettingsParams());
    }

    private HttpClient createHttpClient(ProxySettingsParams proxySettingsParams, AdvancedParams oAuthAdvancedParams, HttpService httpService) {
        String httpProtocolsListAsString;
        HttpClientConfiguration.Builder httpClientConfigurationBuilder = new HttpClientConfiguration.Builder().setName(HTTP_CLIENT_CONFIG);
        if (proxySettingsParams != null && StringUtils.isNotBlank((CharSequence)proxySettingsParams.getProxyHost())) {
            ProxyConfigBuilder proxyConfigBuilder = ProxyConfig.builder();
            ((ProxyConfigBuilder)proxyConfigBuilder.host(proxySettingsParams.getProxyHost())).port(proxySettingsParams.getProxyPort().intValue());
            if (StringUtils.isNotBlank((CharSequence)proxySettingsParams.getProxyUsername()) && StringUtils.isNotBlank((CharSequence)proxySettingsParams.getProxyPassword())) {
                ((ProxyConfigBuilder)proxyConfigBuilder.username(proxySettingsParams.getProxyUsername())).password(proxySettingsParams.getProxyPassword());
            }
            httpClientConfigurationBuilder.setProxyConfig(proxyConfigBuilder.build());
        }
        if (oAuthAdvancedParams != null) {
            TcpClientSocketPropertiesBuilder tcpClientSocketPropertiesBuilder = TcpClientSocketProperties.builder();
            if (oAuthAdvancedParams.getConnectionTimeout() != null) {
                tcpClientSocketPropertiesBuilder.connectionTimeout(oAuthAdvancedParams.getConnectionTimeout());
            }
            if (oAuthAdvancedParams.getReadTimeout() != null) {
                tcpClientSocketPropertiesBuilder.clientTimeout(oAuthAdvancedParams.getReadTimeout());
            }
            httpClientConfigurationBuilder.setClientSocketProperties(tcpClientSocketPropertiesBuilder.build());
        }
        if ((httpProtocolsListAsString = System.getProperty(HTTPS_PROTOCOLS_SYSTEM_PROPERTY_KEY)) != null) {
            TlsContextFactory tlsContextFactory;
            try {
                tlsContextFactory = TlsContextFactory.builder().enabledProtocols(httpProtocolsListAsString).build();
            }
            catch (CreateException e) {
                throw new DynamicsCRMException("Failed configuring the Http Client for Dynamics CRM API", DynamicsCRMErrorType.CONNECTIVITY, e);
            }
            httpClientConfigurationBuilder.setTlsContextFactory(tlsContextFactory);
        }
        return httpService.getClientFactory().create(httpClientConfigurationBuilder.build());
    }

    protected HttpClientService createHttpClientService() {
        HttpClient httpClient = this.createHttpClient(this.credentials.getProxySettingsParams(), this.credentials.getAdvancedParams(), this.httpService);
        return new HttpClientService(httpClient);
    }

    protected void callSimpleQueryToTestConnection(IOrganizationService client) throws IOrganizationServiceRetrieveMultipleOrganizationServiceFaultFaultFaultMessage {
        FetchExpression query = new FetchExpression();
        try {
            String fetchXml = DynamicsCrmUtils.getXmlAsString(this.getClass().getClassLoader().getResourceAsStream("fetch-account.xml"));
            query.setQuery(fetchXml);
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
            throw new IOrganizationServiceRetrieveMultipleOrganizationServiceFaultFaultFaultMessage("Query file not found or is corrupted");
        }
        client.retrieveMultiple(query);
    }

    protected abstract IOrganizationService createOrganizationServiceClient() throws ConnectionException;

    protected abstract void testClientConnectivity(IOrganizationService var1, String var2) throws ConnectionException;
}

