/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.security.policies.interceptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JOutInterceptor;

public class AssertAllKnownAssertionsInterceptor
extends AbstractSoapInterceptor {
    private List<QName> knownAssertions;

    public AssertAllKnownAssertionsInterceptor(List<QName> knownAssertions) {
        super("pre-protocol");
        this.addAfter(PolicyBasedWSS4JInInterceptor.class.getName());
        this.addAfter(PolicyBasedWSS4JOutInterceptor.class.getName());
        this.knownAssertions = knownAssertions;
    }

    public void handleMessage(SoapMessage message) {
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        if (aim != null) {
            ArrayList knownAis = new ArrayList();
            for (QName knownAssertion : this.knownAssertions) {
                Collection ais = (Collection)aim.get((Object)knownAssertion);
                if (ais == null) continue;
                knownAis.addAll(ais);
            }
            if (null == knownAis || knownAis.isEmpty()) {
                return;
            }
            for (AssertionInfo ai : knownAis) {
                ai.setAsserted(true);
            }
        }
    }
}

