/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.datasense.retrievers.attributes;

import com.mulesoft.connectors.microsoft.dynamics.crm.internal.caching.LRUCache;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.DynamicsCRMConnection;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.datasense.retrievers.attributes.AttributesBaseRetriever;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.datasense.retrievers.attributes.AttributesEntityRetriever;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.datasense.retrievers.attributes.AttributesFactoryScope;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.datasense.retrievers.attributes.AttributesMultipleRetriever;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.metadata.AttributeMetadata;

public class AttributesFactory {
    private AttributesFactoryScope scope;
    private LRUCache<String, Iterable<AttributeMetadata>> cache;

    public AttributesFactory(AttributesFactoryScope scope) {
        this.scope = scope;
        this.cache = new LRUCache(11);
    }

    public AttributesBaseRetriever createAttributeRetriever(DynamicsCRMConnection connection) {
        AttributesBaseRetriever retriever;
        switch (this.scope) {
            case Operation: {
                retriever = new AttributesMultipleRetriever();
                break;
            }
            default: {
                retriever = new AttributesEntityRetriever();
            }
        }
        retriever.setConnection(connection);
        retriever.setCache(this.cache);
        return retriever;
    }
}

