/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.datasense.retrievers;

import com.google.common.base.Strings;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.caching.LRUCache;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.DynamicsCRMConnection;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.datasense.retrievers.Retriever;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.datasense.retrievers.RetrieverContext;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.services.IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage;

public abstract class BaseRetriever<T, C extends RetrieverContext>
implements Retriever<T, C> {
    private final String RETRIEVERS_NO_CACHE = "org.mule.module.dynamicscrm.metadata.retrievers.nocache";
    private LRUCache<String, Iterable<T>> cache;
    protected DynamicsCRMConnection connection;

    @Override
    public Iterable<T> getMetadata(C ctx) throws IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage {
        Iterable<T> metadata = this.getItemFromCache(ctx.getKey());
        if (this.isResolveRequired(metadata)) {
            metadata = this.putItemInCache(ctx.getKey(), this.resolveMetadata(ctx));
        }
        return metadata;
    }

    @Override
    public void setConnection(DynamicsCRMConnection connection) {
        this.connection = connection;
    }

    @Override
    public void setCache(LRUCache<String, Iterable<T>> cache) {
        this.cache = cache;
    }

    protected boolean isResolveRequired(Iterable<T> metadata) {
        return metadata == null;
    }

    protected Iterable<T> getItemFromCache(String entityName) {
        if (!this.useCache()) {
            return null;
        }
        return (Iterable)this.cache.get(entityName);
    }

    protected Iterable<T> putItemInCache(String key, Iterable<T> metadata) {
        if (this.useCache()) {
            this.cache.put(key, metadata);
        }
        return metadata;
    }

    protected boolean useCache() {
        if (this.cache == null) {
            return false;
        }
        String prop = System.getProperty("org.mule.module.dynamicscrm.metadata.retrievers.nocache");
        String customProp = System.getProperty(this.getCustomDisableCachePropertyName());
        return !(!Strings.isNullOrEmpty((String)prop) && prop.equals("1") || !Strings.isNullOrEmpty((String)customProp) && customProp.equals("1"));
    }

    protected abstract Iterable<T> resolveMetadata(C var1) throws IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage;

    protected abstract String getCustomDisableCachePropertyName();
}

