/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.datasense.query;

import com.mulesoft.connectors.microsoft.dynamics.crm.internal.datasense.query.DynamicsCrmOperatorVisitor;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.datasense.query.DynamicsCrmWhereManager;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.service.exception.DynamicsCRMErrorType;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.service.exception.DynamicsCRMException;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils.MetadataUtil;
import java.util.List;
import org.mule.runtime.extension.api.dsql.Direction;
import org.mule.runtime.extension.api.dsql.EntityType;
import org.mule.runtime.extension.api.dsql.Field;
import org.mule.runtime.extension.api.dsql.OperatorTranslator;
import org.mule.runtime.extension.api.dsql.QueryTranslator;
import org.mule.runtime.extension.api.dsql.Value;

public class DynamicsCRMQueryTranslator
implements QueryTranslator {
    private String entityName = null;
    private List<Field> fields = null;
    private DynamicsCrmWhereManager where = new DynamicsCrmWhereManager();
    private List<Field> orderBy = null;
    private Direction orderByDirection;

    public void translateFields(List<Field> list) {
        this.fields = list;
    }

    public void translateTypes(EntityType entityType) {
        this.entityName = entityType.getName();
    }

    public void translateOrderByFields(List<Field> list, Direction direction) {
        this.orderBy = list;
        this.orderByDirection = direction;
    }

    public void translateAnd() {
        this.where.and();
    }

    public void translateOR() {
        this.where.or();
    }

    public void translateComparison(String comparator, Field field, Value<?> value) {
        this.where.comparison(comparator, field.getName(), value.getValue().toString());
    }

    public void translateBeginExpression() {
        this.where.beginExpression();
    }

    public void translateInitPrecedence() {
        this.where.initPrecedence();
    }

    public void translateEndPrecedence() {
        this.where.endPrecedence();
    }

    public void translateLimit(int i) {
    }

    public void translateOffset(int i) {
    }

    public OperatorTranslator operatorTranslator() {
        return new DynamicsCrmOperatorVisitor();
    }

    public String getTranslation() {
        if (this.entityName == null) {
            throw new DynamicsCRMException("The entity for the query must be specified", DynamicsCRMErrorType.VALIDATION);
        }
        if (this.fields == null) {
            throw new DynamicsCRMException("The fields of the entity for the query must be specified", DynamicsCRMErrorType.VALIDATION);
        }
        StringBuilder queryString = new StringBuilder();
        queryString.append("<fetch mapping=\"logical\">").append(String.format("<entity name=\"%s\">", this.entityName));
        for (Field field : this.fields) {
            String attributeName = MetadataUtil.getUnescapedFiledName(field.getName());
            if (MetadataUtil.isLookupField(attributeName)) {
                attributeName = MetadataUtil.getLookupFieldName(attributeName);
            }
            queryString.append(String.format("<attribute name=\"%s\" />", attributeName));
        }
        queryString.append(this.where.getQueryXml());
        this.where.release();
        if (this.orderBy != null) {
            for (Field field : this.orderBy) {
                queryString.append(String.format("<order attribute=\"%s\" descending=\"%s\" />", field.getName(), this.orderByDirection.equals((Object)Direction.DESC) ? "true" : "false"));
            }
        }
        queryString.append("</entity>").append("</fetch>");
        return queryString.toString();
    }
}

