/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.datasense;

import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.DynamicsCRMConnection;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.datasense.retrievers.attributes.AttributesBaseRetriever;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.datasense.retrievers.attributes.AttributesContext;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.datasense.retrievers.attributes.AttributesFactoryManager;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.datasense.retrievers.attributes.AttributesFactoryScope;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.datasense.retrievers.entities.EntitiesContext;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.datasense.retrievers.entities.EntitiesFactory;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.datasense.retrievers.entities.EntitiesRetriever;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.services.IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.metadata.AttributeMetadata;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.metadata.AttributeTypeCode;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.metadata.EntityMetadata;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.metadata.LookupAttributeMetadata;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils.MetadataUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;

public abstract class AbstractMetadataResolver {
    private AttributesFactoryManager attributesFactoryManager = new AttributesFactoryManager();

    protected Set<MetadataKey> getEntitiesAsMetadataKeys(MetadataContext metadataContext) throws ConnectionException, MetadataResolvingException {
        HashSet<MetadataKey> keys = new HashSet<MetadataKey>();
        EntitiesFactory entitiesFactory = new EntitiesFactory();
        EntitiesRetriever entityRetriever = entitiesFactory.createAttributeRetriever(this.extractConnection(metadataContext));
        try {
            for (EntityMetadata entityMetadata : entityRetriever.getMetadata(new EntitiesContext())) {
                String name = entityMetadata.getLogicalName();
                keys.add(MetadataKeyBuilder.newKey((String)name).withDisplayName(name).build());
            }
        }
        catch (IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage ex) {
            throw new ConnectionException(ex.getMessage(), (Throwable)ex);
        }
        return keys;
    }

    private DynamicsCRMConnection extractConnection(MetadataContext metadataContext) throws ConnectionException, MetadataResolvingException {
        Optional optionalConnection = metadataContext.getConnection();
        return (DynamicsCRMConnection)optionalConnection.orElseThrow(() -> new MetadataResolvingException("No connection available.", FailureCode.UNKNOWN));
    }

    protected MetadataType buildObjectMetadata(String metadataKey, MetadataContext metadataContext) throws ConnectionException, MetadataResolvingException, IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage {
        ObjectTypeBuilder metadataBuilder = metadataContext.getTypeBuilder().objectType().id(metadataKey);
        for (AttributeMetadata attributeMetadata : this.getAttributesRetriever(AttributesFactoryScope.Metadata, this.extractConnection(metadataContext)).getMetadata(new AttributesContext(metadataKey))) {
            if (attributeMetadata instanceof LookupAttributeMetadata) {
                this.addLookupFieldToObjectBuilder(metadataBuilder, attributeMetadata, metadataContext);
                continue;
            }
            this.addFieldToObjectBuilder(metadataBuilder, attributeMetadata);
        }
        return metadataBuilder.build();
    }

    protected MetadataType buildObjectMetadata(String metadataKey, MetadataContext metadataContext, List<String> fieldsToBeAdded) throws ConnectionException, MetadataResolvingException, IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage {
        ObjectTypeBuilder metadataBuilder = metadataContext.getTypeBuilder().objectType().id(metadataKey);
        for (AttributeMetadata attributeMetadata : this.getAttributesRetriever(AttributesFactoryScope.Metadata, this.extractConnection(metadataContext)).getMetadata(new AttributesContext(metadataKey))) {
            if (!fieldsToBeAdded.contains(MetadataUtil.getEscapedFiledName(attributeMetadata.getLogicalName()))) continue;
            if (attributeMetadata instanceof LookupAttributeMetadata) {
                this.addLookupFieldToObjectBuilder(metadataBuilder, attributeMetadata, metadataContext);
                continue;
            }
            this.addFieldToObjectBuilder(metadataBuilder, attributeMetadata);
        }
        return metadataBuilder.build();
    }

    private void addLookupFieldToObjectBuilder(ObjectTypeBuilder metadataBuilder, AttributeMetadata attributeMetadata, MetadataContext metadataContext) {
        AttributeTypeCode fieldTypeKind = attributeMetadata.getAttributeType();
        LookupAttributeMetadata attributeMetadataAsLookup = (LookupAttributeMetadata)attributeMetadata;
        switch (fieldTypeKind) {
            case LOOKUP: 
            case OWNER: 
            case CUSTOMER: {
                for (String targetEntityName : attributeMetadataAsLookup.getTargets().getStrings()) {
                    metadataBuilder.addField().key(MetadataUtil.buildLookupField(attributeMetadata.getLogicalName(), targetEntityName)).label(MetadataUtil.buildLookupField(attributeMetadata.getLogicalName(), targetEntityName)).value().stringType();
                }
                break;
            }
            case PARTY_LIST: {
                ObjectTypeBuilder objectTypeBuilder = metadataContext.getTypeBuilder().objectType();
                for (String targetEntityName : attributeMetadataAsLookup.getTargets().getStrings()) {
                    objectTypeBuilder.addField().key(MetadataUtil.buildLookupField(attributeMetadata.getLogicalName(), targetEntityName)).label(MetadataUtil.buildLookupField(attributeMetadata.getLogicalName(), targetEntityName)).value().stringType();
                }
                metadataBuilder.addField().key(MetadataUtil.getEscapedFiledName(attributeMetadata.getLogicalName())).label(MetadataUtil.getEscapedFiledName(attributeMetadata.getLogicalName())).value().arrayType().of((TypeBuilder)objectTypeBuilder);
                break;
            }
            default: {
                metadataBuilder.addField().key(MetadataUtil.getEscapedFiledName(attributeMetadata.getLogicalName())).label(MetadataUtil.getEscapedFiledName(attributeMetadata.getLogicalName())).value().anyType();
            }
        }
    }

    private void addFieldToObjectBuilder(ObjectTypeBuilder metadataBuilder, AttributeMetadata attributeMetadata) {
        AttributeTypeCode fieldTypeKind = attributeMetadata.getAttributeType();
        switch (fieldTypeKind) {
            case MONEY: 
            case BIG_INT: 
            case DECIMAL: 
            case DOUBLE: 
            case INTEGER: 
            case STATE: 
            case STATUS: 
            case PICKLIST: {
                metadataBuilder.addField().key(MetadataUtil.getEscapedFiledName(attributeMetadata.getLogicalName())).label(MetadataUtil.getEscapedFiledName(attributeMetadata.getLogicalName())).value().numberType();
                break;
            }
            case LOOKUP: 
            case OWNER: 
            case CUSTOMER: 
            case UNIQUEIDENTIFIER: 
            case STRING: 
            case MEMO: 
            case ENTITY_NAME: {
                metadataBuilder.addField().key(MetadataUtil.getEscapedFiledName(attributeMetadata.getLogicalName())).label(MetadataUtil.getEscapedFiledName(attributeMetadata.getLogicalName())).value().stringType();
                break;
            }
            case BOOLEAN: {
                metadataBuilder.addField().key(MetadataUtil.getEscapedFiledName(attributeMetadata.getLogicalName())).label(MetadataUtil.getEscapedFiledName(attributeMetadata.getLogicalName())).value().booleanType();
                break;
            }
            case DATE_TIME: {
                metadataBuilder.addField().key(MetadataUtil.getEscapedFiledName(attributeMetadata.getLogicalName())).label(MetadataUtil.getEscapedFiledName(attributeMetadata.getLogicalName())).value().dateTimeType();
                break;
            }
            default: {
                metadataBuilder.addField().key(MetadataUtil.getEscapedFiledName(attributeMetadata.getLogicalName())).label(MetadataUtil.getEscapedFiledName(attributeMetadata.getLogicalName())).value().anyType();
            }
        }
    }

    public AttributesBaseRetriever getAttributesRetriever(AttributesFactoryScope scope, DynamicsCRMConnection connection) {
        return this.attributesFactoryManager.getFactory(scope).createAttributeRetriever(connection);
    }
}

