/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.policies.interceptors;

import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.parameters.ProxySettingsParams;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online.MicrosoftOnlineAuthenticationPolicy;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online.MicrosoftOnlineSecurityHeaderInterceptor;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online.Office365ConnectionException;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online.Office365TokenRetriever;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online.RealmInfo;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.utils.DynamicsCrmConnectionUtils;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.utils.MessageUtils;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.security.assertors.XrmAuthenticationTypeAssertion;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils.DynamicsCrmConstants;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import joptsimple.internal.Strings;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.VersionTransformer;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.IssuedToken;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.trust.STSClient;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CrmAuthenticationPolicyOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Log log = LogFactory.getLog(CrmAuthenticationPolicyOutInterceptor.class);
    private final ProxySettingsParams proxySettingsParams;

    public CrmAuthenticationPolicyOutInterceptor(ProxySettingsParams proxySettingsParams) {
        super("prepare-send");
        this.addBefore("IssuedTokenOutInterceptor");
        this.proxySettingsParams = proxySettingsParams;
    }

    /*
     * Unable to fully structure code
     */
    public void handleMessage(Message message) {
        aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        if (aim != null) {
            disableCnCheck = MessageUtils.getContextualBoolean(message, "AuthenticationPolicy.DisableCnCheck", false);
            ais = new ArrayList<E>();
            ais2011 = (Collection)aim.get((Object)DynamicsCrmConstants.AUTH_POLICY_2011);
            if (ais2011 != null) {
                ais.addAll(ais2011);
            }
            if ((ais2012 = (Collection)aim.get((Object)DynamicsCrmConstants.AUTH_POLICY_2012)) != null) {
                ais.addAll(ais2012);
            }
            for (final AssertionInfo ai : ais) {
                authenticationPolicy = (XrmAuthenticationTypeAssertion)ai.getAssertion();
                if (authenticationPolicy != null && authenticationPolicy.getAuthenticationType() != null) {
                    CrmAuthenticationPolicyOutInterceptor.log.debug((Object)("Authentication type from wsdl: " + authenticationPolicy.getAuthenticationType()));
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)authenticationPolicy.getAuthenticationType(), (CharSequence)"Federation")) {
                    metadataWsdl = "";
                    issuedTokenAssertions = (Collection)aim.get((Object)SP12Constants.ISSUED_TOKEN);
                    if (issuedTokenAssertions != null && !issuedTokenAssertions.isEmpty() && (var12_12 = issuedTokenAssertions.iterator()).hasNext()) {
                        issuedTokenAssertion = (AssertionInfo)var12_12.next();
                        issuedToken = (IssuedToken)issuedTokenAssertion.getAssertion();
                        metadataWsdl = this.findMEXLocation(issuedToken.getIssuerEpr());
                    }
                    if (Strings.isNullOrEmpty((String)metadataWsdl)) {
                        ai.setNotAsserted("Unable to get Federation Metadata WSDL from CRM's Authentication Policy");
                        return;
                    }
                    CrmAuthenticationPolicyOutInterceptor.log.debug((Object)("Found Federation Metadata WSDL from CRM's Authentication Policy: " + metadataWsdl));
                    try {
                        doc = DynamicsCrmConnectionUtils.downloadUrlIntoDocument(metadataWsdl, this.proxySettingsParams);
                        xPathfactory = XPathFactory.newInstance();
                        xpath = xPathfactory.newXPath();
                        expr = xpath.compile("//*[local-name()='Address' and substring(text(), string-length(text()) - 36)='/adfs/services/trust/13/usernamemixed']");
                        node = (Node)expr.evaluate(doc, XPathConstants.NODE);
                        parts = node.getParentNode().getParentNode().getAttributes().getNamedItem("binding").getTextContent().split(":");
                        endpointName = parts.length > 1 ? parts[1] : parts[0];
                        CrmAuthenticationPolicyOutInterceptor.log.debug((Object)("Found '13/usernamemixed' endpoint in wsdl: " + endpointName));
                    }
                    catch (Exception e) {
                        endpointName = "UserNameWSTrustBinding_IWSTrust13Async1";
                    }
                    client = new STSClient((Bus)message.getExchange().get(Bus.class));
                    client.setWsdlLocation(metadataWsdl);
                    client.setEndpointQName(new QName("http://schemas.microsoft.com/ws/2008/06/identity/securitytokenservice", endpointName));
                    client.setSendRenewing(false);
                    client.setWspNamespace("http://schemas.xmlsoap.org/ws/2004/09/policy");
                    message.put((Object)"ws-security.sts.client", (Object)client);
                    try {
                        conduit = (HTTPConduit)client.getClient().getConduit();
                        DynamicsCrmConnectionUtils.setProxyConnection(conduit, this.proxySettingsParams);
                        if (!disableCnCheck) ** GOTO lbl65
                        DynamicsCrmConnectionUtils.disableCnCheck(conduit);
                    }
                    catch (Exception e) {
                        CrmAuthenticationPolicyOutInterceptor.log.error((Object)e);
                        ai.setNotAsserted("Error when trying to configure conduit in STS Client: " + e.getMessage());
                        return;
                    }
                } else if (StringUtils.equalsIgnoreCase((CharSequence)authenticationPolicy.getAuthenticationType(), (CharSequence)"OnlineFederation")) {
                    tok = (SecurityToken)MessageUtils.getContextualObject(message, "ws-security.token");
                    if (tok == null || tok.isExpired() || tok.isAboutToExpire(30L)) {
                        bus = (Bus)message.getExchange().get(Bus.class);
                        this.issueToken(message, bus);
                    }
                } else if (StringUtils.equalsIgnoreCase((CharSequence)authenticationPolicy.getAuthenticationType(), (CharSequence)"ActiveDirectory")) {
                    message.put((Object)"ws-security.sts.client", (Object)new CustomSTSClient((Bus)message.getExchange().get(Bus.class)));
                }
lbl65:
                // 6 sources

                ai.setAsserted(true);
            }
        }
    }

    private void issueToken(Message message, Bus bus) {
        RealmInfo realmInfo;
        log.info((Object)"Authenticating against Microsoft Online");
        Office365TokenRetriever tokenRetriever = (Office365TokenRetriever)MessageUtils.getContextualObject(message, "AuthenticationPolicy.OnlineTokenRetriever");
        String username = (String)MessageUtils.getContextualObject(message, "ws-security.username");
        String password = (String)MessageUtils.getContextualObject(message, "ws-security.password");
        try {
            realmInfo = tokenRetriever.getUserRealmInfo(username);
        }
        catch (Office365ConnectionException e) {
            throw new Fault((Throwable)e);
        }
        if ("Unknown".equalsIgnoreCase(realmInfo.getNamespaceType())) {
            log.info((Object)"Realm info not provided - will try federated auth if custom sts provided");
            if (Strings.isNullOrEmpty((String)realmInfo.getMetadataUrl())) {
                String customMetadataUrl = (String)MessageUtils.getContextualObject(message, "AuthenticationPolicy.StsMetadataUrl");
                if (!Strings.isNullOrEmpty((String)customMetadataUrl)) {
                    realmInfo.setMetadataUrl(customMetadataUrl);
                    realmInfo.setNamespaceType("Federated");
                }
            } else {
                realmInfo.setNamespaceType("Federated");
            }
        }
        PolicyEngine policyEngine = (PolicyEngine)bus.getExtension(PolicyEngine.class);
        MicrosoftOnlineAuthenticationPolicy onlineAuthenticationPolicy = (MicrosoftOnlineAuthenticationPolicy)MessageUtils.getContextualObject(message, "AuthenticationPolicy.OnlineAuthenticationPolicy");
        int authenticationRetries = (Integer)MessageUtils.getContextualObject(message, "AuthenticationPolicy.AuthenticationRetries");
        for (int i = 1; i <= authenticationRetries; ++i) {
            try {
                if ("Managed".equalsIgnoreCase(realmInfo.getNamespaceType())) {
                    policyEngine.setEnabled(true);
                    message.put((Object)"ws-security.token", (Object)tokenRetriever.getTokenFromOffice365(bus, username, password, onlineAuthenticationPolicy.getIssuerUri().toString(), onlineAuthenticationPolicy.getAppliesTo()));
                    break;
                }
                if ("LiveId".equalsIgnoreCase(realmInfo.getNamespaceType())) {
                    policyEngine.setEnabled(false);
                    bus.getOutInterceptors().add(new MicrosoftOnlineSecurityHeaderInterceptor(tokenRetriever.getTokenFromLiveId((String)MessageUtils.getContextualObject(message, "AuthenticationPolicy.OrganizationServiceUrl"), username, password, onlineAuthenticationPolicy)));
                    policyEngine.setEnabled(true);
                    break;
                }
                if (!"Federated".equalsIgnoreCase(realmInfo.getNamespaceType())) continue;
                policyEngine.setEnabled(true);
                SecurityToken adfsTokenForMicrosoftOnline = tokenRetriever.getTokenFromAdfs(bus, username, password, realmInfo.getMetadataUrl(), (String)MessageUtils.getContextualObject(message, "AuthenticationPolicy.PortName"), onlineAuthenticationPolicy.getMicrosoftOnlineIdentifier());
                SecurityToken microsoftOnlineTokenForCrm = tokenRetriever.getTokenFromMicrosoftOnline(bus, adfsTokenForMicrosoftOnline, onlineAuthenticationPolicy.getIssuerUri().toString(), onlineAuthenticationPolicy.getAppliesTo());
                message.put((Object)"ws-security.token", (Object)microsoftOnlineTokenForCrm);
                break;
            }
            catch (Exception e) {
                log.info((Object)"Error trying to authenticate against Microsoft Online.", (Throwable)e);
                if (i >= authenticationRetries) {
                    throw new Fault((Throwable)e);
                }
                log.info((Object)("Retries left: " + (authenticationRetries - i)));
            }
        }
    }

    private String findMEXLocation(EndpointReferenceType ref) {
        if (ref.getMetadata() != null && ref.getMetadata().getAny() != null) {
            for (Object any : ref.getMetadata().getAny()) {
                String addr;
                if (!(any instanceof Element) || (addr = this.findMEXLocation((Element)any)) == null) continue;
                return addr;
            }
        }
        return EndpointReferenceUtils.getAddress((EndpointReferenceType)ref);
    }

    private String findMEXLocation(Element ref) {
        Element el = DOMUtils.getFirstElement((Node)ref);
        while (el != null) {
            if (el.getLocalName().equals("Address") && VersionTransformer.isSupported((String)el.getNamespaceURI()) && "MetadataReference".equals(ref.getLocalName())) {
                return DOMUtils.getContent((Node)el);
            }
            String ad = this.findMEXLocation(el);
            if (ad != null) {
                return ad;
            }
            el = DOMUtils.getNextElement((Element)el);
        }
        return null;
    }
}

