/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online;

import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online.DeviceCredentials;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online.DeviceIdManager;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online.MicrosoftOnlineSecurityData;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.security.online.exception.DeviceRegistrationFailedException;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.service.exception.DynamicsCRMErrorType;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.service.exception.DynamicsCRMException;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.utils.HttpClientService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.cxf.helpers.XMLUtils;
import org.mule.runtime.core.api.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class LiveIDManager {
    private static final Logger log = LoggerFactory.getLogger((String)LiveIDManager.class.getName());
    private final String deviceTokenTemplate = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <s:Envelope  xmlns:s=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:wsse=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\" xmlns:wsp=\"http://schemas.xmlsoap.org/ws/2004/09/policy\" xmlns:wsu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\" xmlns:wsa=\"http://www.w3.org/2005/08/addressing\" xmlns:wst=\"http://schemas.xmlsoap.org/ws/2005/02/trust\">  <s:Header>   <wsa:Action s:mustUnderstand=\"1\">http://schemas.xmlsoap.org/ws/2005/02/trust/RST/Issue</wsa:Action>   <wsa:To s:mustUnderstand=\"1\">http://Passport.NET/tb</wsa:To>       <wsse:Security>     <wsse:UsernameToken wsu:Id=\"devicesoftware\">       <wsse:Username>%s</wsse:Username>       <wsse:Password>%s</wsse:Password>     </wsse:UsernameToken>   </wsse:Security> </s:Header> <s:Body>   <wst:RequestSecurityToken Id=\"RST0\">        <wst:RequestType>http://schemas.xmlsoap.org/ws/2005/02/trust/Issue</wst:RequestType>        <wsp:AppliesTo>           <wsa:EndpointReference>              <wsa:Address>http://Passport.NET/tb</wsa:Address>           </wsa:EndpointReference>        </wsp:AppliesTo>     </wst:RequestSecurityToken> </s:Body> </s:Envelope>";
    private final String securityTokenSoapTemplate = "<s:Envelope xmlns:s=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:a=\"http://www.w3.org/2005/08/addressing\" xmlns:o=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\" xmlns:wsse=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\" xmlns:wsp=\"http://schemas.xmlsoap.org/ws/2004/09/policy\" xmlns:t=\"http://schemas.xmlsoap.org/ws/2005/02/trust\" xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:u=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\"><s:Header>    <a:Action s:mustUnderstand=\"1\">    http://schemas.xmlsoap.org/ws/2005/02/trust/RST/Issue</a:Action>    <a:MessageID>urn:uuid:%s</a:MessageID>    <a:ReplyTo>      <a:Address>http://www.w3.org/2005/08/addressing/anonymous</a:Address>    </a:ReplyTo>    <a:To s:mustUnderstand=\"1\">http://Passport.NET/tb</a:To>    <o:Security s:mustUnderstand=\"1\">      <o:UsernameToken u:Id=\"user\">        <o:Username>%s</o:Username>        <o:Password>%s</o:Password>      </o:UsernameToken>      <wsse:BinarySecurityToken ValueType=\"urn:liveid:device\">        <EncryptedData Id=\"BinaryDAToken0\"        Type=\"http://www.w3.org/2001/04/xmlenc#Element\"        xmlns=\"http://www.w3.org/2001/04/xmlenc#\">          <EncryptionMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#tripledes-cbc\">          </EncryptionMethod>          <ds:KeyInfo>            <ds:KeyName>http://Passport.NET/STS</ds:KeyName>          </ds:KeyInfo>          <CipherData>            <CipherValue>              %s            </CipherValue>          </CipherData>        </EncryptedData>      </wsse:BinarySecurityToken>    </o:Security> </s:Header>  <s:Body>    <t:RequestSecurityToken>      <wsp:AppliesTo>        <a:EndpointReference>          <a:Address>%s</a:Address>        </a:EndpointReference>      </wsp:AppliesTo>     <wsp:PolicyReference URI=\"%s\"/>      <t:RequestType>http://schemas.xmlsoap.org/ws/2005/02/trust/Issue</t:RequestType>    </t:RequestSecurityToken>  </s:Body> </s:Envelope>";

    public MicrosoftOnlineSecurityData authenticateWithLiveID(String crmUrl, String liveIDUsername, String liveIDPassword, String appliesTo, String policy, URI issuerUri, HttpClientService clientService) throws SAXException, ParserConfigurationException, DeviceRegistrationFailedException, IOException, XPathExpressionException, TimeoutException {
        if (crmUrl == null) {
            throw new NullPointerException("crmUrl");
        }
        if (liveIDUsername == null) {
            throw new NullPointerException("liveIDUsername");
        }
        if (liveIDPassword == null) {
            throw new NullPointerException("liveIDPassword");
        }
        if (appliesTo == null) {
            throw new NullPointerException("partner");
        }
        if (policy == null) {
            throw new NullPointerException("policy");
        }
        if (issuerUri == null) {
            throw new NullPointerException("issuerUri");
        }
        DeviceCredentials deviceCredentials = DeviceIdManager.registerDevice(clientService);
        String soapTemplate = String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?> <s:Envelope  xmlns:s=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:wsse=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\" xmlns:wsp=\"http://schemas.xmlsoap.org/ws/2004/09/policy\" xmlns:wsu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\" xmlns:wsa=\"http://www.w3.org/2005/08/addressing\" xmlns:wst=\"http://schemas.xmlsoap.org/ws/2005/02/trust\">  <s:Header>   <wsa:Action s:mustUnderstand=\"1\">http://schemas.xmlsoap.org/ws/2005/02/trust/RST/Issue</wsa:Action>   <wsa:To s:mustUnderstand=\"1\">http://Passport.NET/tb</wsa:To>       <wsse:Security>     <wsse:UsernameToken wsu:Id=\"devicesoftware\">       <wsse:Username>%s</wsse:Username>       <wsse:Password>%s</wsse:Password>     </wsse:UsernameToken>   </wsse:Security> </s:Header> <s:Body>   <wst:RequestSecurityToken Id=\"RST0\">        <wst:RequestType>http://schemas.xmlsoap.org/ws/2005/02/trust/Issue</wst:RequestType>        <wsp:AppliesTo>           <wsa:EndpointReference>              <wsa:Address>http://Passport.NET/tb</wsa:Address>           </wsa:EndpointReference>        </wsp:AppliesTo>     </wst:RequestSecurityToken> </s:Body> </s:Envelope>", "11" + deviceCredentials.getDeviceName(), deviceCredentials.getPassword());
        log.debug("Device Credential Request: " + soapTemplate);
        String binaryDATokenXML = LiveIDManager.getSOAPResponse(issuerUri, soapTemplate, clientService);
        log.debug("Live ID Response: " + binaryDATokenXML);
        String cipherValue = this.getValueFromXML(binaryDATokenXML, "//*[local-name()='CipherValue']");
        log.debug("CipherValue: " + cipherValue);
        String securityTemplate = String.format("<s:Envelope xmlns:s=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:a=\"http://www.w3.org/2005/08/addressing\" xmlns:o=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\" xmlns:wsse=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\" xmlns:wsp=\"http://schemas.xmlsoap.org/ws/2004/09/policy\" xmlns:t=\"http://schemas.xmlsoap.org/ws/2005/02/trust\" xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:u=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\"><s:Header>    <a:Action s:mustUnderstand=\"1\">    http://schemas.xmlsoap.org/ws/2005/02/trust/RST/Issue</a:Action>    <a:MessageID>urn:uuid:%s</a:MessageID>    <a:ReplyTo>      <a:Address>http://www.w3.org/2005/08/addressing/anonymous</a:Address>    </a:ReplyTo>    <a:To s:mustUnderstand=\"1\">http://Passport.NET/tb</a:To>    <o:Security s:mustUnderstand=\"1\">      <o:UsernameToken u:Id=\"user\">        <o:Username>%s</o:Username>        <o:Password>%s</o:Password>      </o:UsernameToken>      <wsse:BinarySecurityToken ValueType=\"urn:liveid:device\">        <EncryptedData Id=\"BinaryDAToken0\"        Type=\"http://www.w3.org/2001/04/xmlenc#Element\"        xmlns=\"http://www.w3.org/2001/04/xmlenc#\">          <EncryptionMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#tripledes-cbc\">          </EncryptionMethod>          <ds:KeyInfo>            <ds:KeyName>http://Passport.NET/STS</ds:KeyName>          </ds:KeyInfo>          <CipherData>            <CipherValue>              %s            </CipherValue>          </CipherData>        </EncryptedData>      </wsse:BinarySecurityToken>    </o:Security> </s:Header>  <s:Body>    <t:RequestSecurityToken>      <wsp:AppliesTo>        <a:EndpointReference>          <a:Address>%s</a:Address>        </a:EndpointReference>      </wsp:AppliesTo>     <wsp:PolicyReference URI=\"%s\"/>      <t:RequestType>http://schemas.xmlsoap.org/ws/2005/02/trust/Issue</t:RequestType>    </t:RequestSecurityToken>  </s:Body> </s:Envelope>", UUID.randomUUID().toString(), liveIDUsername, liveIDPassword, cipherValue, appliesTo, policy);
        log.debug("Security Token Request: " + securityTemplate);
        String securityTokenXML = LiveIDManager.getSOAPResponse(issuerUri, securityTemplate, clientService);
        log.debug("Security Token Response: " + securityTokenXML);
        String securityToken0 = this.getValueFromXML(securityTokenXML, "//*[local-name()='CipherValue']");
        String securityToken1 = this.getValueFromXML(securityTokenXML, "(//*[local-name()='CipherValue'])[2]");
        String keyIdentifier = this.getValueFromXML(securityTokenXML, "//*[local-name()='KeyIdentifier']");
        log.debug("Security Token 0: " + securityToken0);
        log.debug("Security Token 1: " + securityToken1);
        log.debug("Key Identifier: " + keyIdentifier);
        return new MicrosoftOnlineSecurityData(keyIdentifier, securityToken0, securityToken1);
    }

    private String getValueFromXML(String inputXML, String xPathQuery) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(inputXML.getBytes(Charset.forName("UTF-8"))));
            XPath xpath = XPathFactory.newInstance().newXPath();
            Node cipherValue = (Node)xpath.evaluate(xPathQuery, document, XPathConstants.NODE);
            if (cipherValue == null) {
                throw new IOException("Could not find security key. XML response was: " + XMLUtils.toString((Node)document));
            }
            return cipherValue.getTextContent();
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private static String getSOAPResponse(URI issuerUri, String soapEnvelope, HttpClientService httpClientService) {
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/soap+xml; charset=UTF-8");
            InputStream response = httpClientService.sendPost(issuerUri.toString(), soapEnvelope, headers, null);
            return IOUtils.toString((InputStream)response);
        }
        catch (IOException | TimeoutException e) {
            throw new DynamicsCRMException("Error while executing login request", DynamicsCRMErrorType.CONNECTIVITY, e);
        }
    }
}

