/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection;

import com.mulesoft.connectors.microsoft.dynamics.crm.internal.connection.parameters.ConnectorErrorType;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.model.xrm._2011.contracts.services.IOrganizationService;
import com.mulesoft.connectors.microsoft.dynamics.crm.internal.service.exception.DynamicsCRMException;
import java.util.Map;
import java.util.function.Supplier;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.EndpointImpl;
import org.apache.cxf.frontend.ClientProxy;
import org.mule.connectors.commons.template.connection.ConnectorConnection;

public class DynamicsCRMConnection
implements ConnectorConnection {
    private static final Log log = LogFactory.getLog(DynamicsCRMConnection.class);
    private IOrganizationService soapClient;

    public DynamicsCRMConnection(IOrganizationService soapClient) {
        this.soapClient = soapClient;
    }

    public void disconnect() {
        try {
            Client cxfClient = ClientProxy.getClient((Object)this.soapClient);
            ((EndpointImpl)cxfClient.getEndpoint()).getBus().shutdown(false);
            cxfClient.destroy();
        }
        catch (Exception e) {
            log.debug((Object)"Error closing cxf soapClient", (Throwable)e);
        }
        finally {
            this.soapClient = null;
        }
    }

    public void validate() {
        if (this.soapClient == null) {
            throw new DynamicsCRMException("Invalid session!", ConnectorErrorType.CONNECTIVITY);
        }
    }

    public IOrganizationService getSoapClient() {
        return this.soapClient;
    }

    public Marshaller getMarshaller() {
        return null;
    }

    public Unmarshaller getUnmarshaller() {
        return null;
    }

    public Map<String, Supplier<JAXBElement<?>>> getHeaders() {
        return null;
    }
}

