/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.ldap.internal.util;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.SizeLimitExceededException;
import javax.naming.directory.SearchResult;
import org.mule.extension.ldap.internal.connection.LDAPSchemaAware;
import org.mule.extension.ldap.internal.error.LDAPErrorType;
import org.mule.extension.ldap.internal.error.exception.LDAPException;
import org.mule.extension.ldap.internal.model.LDAPEntry;
import org.mule.extension.ldap.internal.model.LDAPSearchControls;
import org.mule.extension.ldap.internal.util.LDAPJNDIUtils;
import org.mule.extension.ldap.internal.util.LDAPResultSet;
import org.mule.extension.ldap.internal.util.LDAPUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLDAPResultSet
implements LDAPResultSet {
    private static final Logger logger = LoggerFactory.getLogger(SimpleLDAPResultSet.class);
    private NamingEnumeration<SearchResult> entries = null;
    private String baseDn = null;
    private LDAPSearchControls controls = null;
    private LDAPSchemaAware schemaCache;
    private boolean returnDN = false;

    public SimpleLDAPResultSet(String baseDn, LDAPSearchControls controls, NamingEnumeration<SearchResult> entries, LDAPSchemaAware schemaCache) {
        this.entries = entries;
        this.baseDn = baseDn;
        this.controls = controls;
        this.schemaCache = schemaCache;
        this.returnDN = LDAPUtils.containsDn(controls);
    }

    @Override
    public boolean hasNext() {
        try {
            return this.entries != null && this.entries.hasMore();
        }
        catch (SizeLimitExceededException slee) {
            logger.warn("Size limit exceeded. Max results is:{}  {} ", (Object)this.controls.getMaxResults(), (Object)slee);
            return false;
        }
        catch (NamingException nex) {
            throw new LDAPException(LDAPErrorType.UNKNOWN, nex);
        }
    }

    @Override
    public LDAPEntry next() {
        SearchResult searchResult = (SearchResult)this.entries.nextElement();
        if (searchResult != null) {
            String entryDn = searchResult.getName();
            if (searchResult.isRelative()) {
                entryDn = entryDn + "," + this.baseDn;
            }
            LDAPEntry nextEntry = LDAPJNDIUtils.buildEntry(entryDn, searchResult.getAttributes(), this.schemaCache);
            if (!this.returnDN) {
                nextEntry.setDn(null);
            }
            return nextEntry;
        }
        throw new NoSuchElementException("End of result set");
    }

    @Override
    public void close() {
        try {
            if (this.entries != null) {
                this.entries.close();
            }
        }
        catch (NamingException nex) {
            throw new LDAPException(LDAPErrorType.UNKNOWN, nex);
        }
        finally {
            this.entries = null;
            this.schemaCache = null;
        }
    }

    @Override
    public List<LDAPEntry> getAllEntries() {
        ArrayList<LDAPEntry> allEntries = new ArrayList<LDAPEntry>();
        while (this.hasNext()) {
            LDAPEntry entry = this.next();
            if (entry != null) {
                allEntries.add(entry);
            }
            if (this.entries.hasMoreElements()) continue;
            break;
        }
        return allEntries;
    }

    @Override
    public int getResultSize() {
        return -1;
    }

    @Override
    public boolean isLastElement() {
        return false;
    }
}

