/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.ldap.internal.util;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.SizeLimitExceededException;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsResponseControl;
import org.mule.extension.ldap.internal.connection.LDAPSchemaAware;
import org.mule.extension.ldap.internal.error.LDAPErrorType;
import org.mule.extension.ldap.internal.error.exception.LDAPException;
import org.mule.extension.ldap.internal.model.LDAPEntry;
import org.mule.extension.ldap.internal.model.LDAPSearchControls;
import org.mule.extension.ldap.internal.util.LDAPJNDIUtils;
import org.mule.extension.ldap.internal.util.LDAPResultSet;
import org.mule.extension.ldap.internal.util.LDAPUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagedLDAPResultSet
implements LDAPResultSet {
    private static final Logger logger = LoggerFactory.getLogger(PagedLDAPResultSet.class);
    private final String baseDn;
    private final String filter;
    private final Object[] filterArgs;
    private LdapContext conn;
    private final LDAPSearchControls controls;
    private LDAPSchemaAware schemaCache = null;
    private final boolean returnDN;
    private boolean isLastElement;
    private NamingEnumeration<SearchResult> entries = null;
    private byte[] cookie = null;

    public PagedLDAPResultSet(String baseDn, String filter, Object[] filterArgs, LdapContext conn, LDAPSearchControls controls, NamingEnumeration<SearchResult> entries, LDAPSchemaAware schemaCache) {
        this.baseDn = baseDn;
        this.filter = filter;
        this.filterArgs = filterArgs != null ? (Object[])filterArgs.clone() : new Object[]{};
        this.controls = controls;
        this.conn = conn;
        this.schemaCache = schemaCache;
        this.entries = entries;
        this.returnDN = LDAPUtils.containsDn(controls);
        this.isLastElement = false;
    }

    @Override
    public void close() {
        try {
            this.closeResultSet();
        }
        finally {
            this.schemaCache = null;
            if (this.conn != null) {
                try {
                    this.conn.close();
                }
                catch (NamingException nex) {
                    throw new LDAPException(LDAPErrorType.UNKNOWN, nex);
                }
                finally {
                    this.conn = null;
                }
            }
        }
    }

    private void closeResultSet() {
        try {
            if (this.entries != null) {
                this.entries.close();
            }
        }
        catch (NamingException nex) {
            throw new LDAPException(LDAPErrorType.UNKNOWN, nex);
        }
        finally {
            this.entries = null;
        }
    }

    @Override
    public LDAPEntry next() {
        SearchResult searchResult;
        if (this.hasNext() && (searchResult = (SearchResult)this.entries.nextElement()) != null) {
            String entryDn = searchResult.getName();
            if (searchResult.isRelative()) {
                entryDn = entryDn + "," + this.baseDn;
            }
            LDAPEntry nextEntry = LDAPJNDIUtils.buildEntry(entryDn, searchResult.getAttributes(), this.schemaCache);
            if (!this.returnDN) {
                nextEntry.setDn(null);
            }
            return nextEntry;
        }
        throw new NoSuchElementException("End of result set");
    }

    private void getNextPage() {
        try {
            this.silentCloseEntriesEnumeration();
            this.conn.setRequestControls(LDAPJNDIUtils.buildRequestControls(this.controls, this.cookie));
            this.entries = this.filterArgs != null && this.filterArgs.length > 0 ? this.conn.search(this.baseDn, this.filter, this.filterArgs, LDAPJNDIUtils.buildSearchControls(this.controls)) : this.conn.search(this.baseDn, this.filter, LDAPJNDIUtils.buildSearchControls(this.controls));
        }
        catch (NamingException nex) {
            throw new LDAPException(LDAPErrorType.UNKNOWN, nex);
        }
    }

    private void silentCloseEntriesEnumeration() {
        if (this.entries != null) {
            try {
                this.entries.close();
            }
            catch (NamingException nex) {
                logger.error("Naming exception", (Throwable)nex);
            }
            finally {
                this.entries = null;
            }
        }
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.entries != null && !this.isLastElement) {
                if (!this.entries.hasMore()) {
                    this.cookie = this.getPagedResultsResponseControlCookie();
                    if (this.cookie != null) {
                        this.getNextPage();
                        return this.entries != null && this.entries.hasMore();
                    }
                    return false;
                }
                return true;
            }
            return false;
        }
        catch (SizeLimitExceededException slee) {
            logger.warn("Size limit exceeded. Max results is: " + this.controls.getMaxResults());
            logger.debug(slee.getMessage());
            this.isLastElement = true;
            return false;
        }
        catch (NamingException nex) {
            throw new LDAPException(LDAPErrorType.UNKNOWN, nex);
        }
    }

    private int getPagedResultsResponseControlResultSize() {
        try {
            Control[] responseControls = this.conn.getResponseControls();
            if (responseControls != null) {
                for (Control responseControl : responseControls) {
                    if (!(responseControl instanceof PagedResultsResponseControl)) continue;
                    PagedResultsResponseControl prrc = (PagedResultsResponseControl)responseControl;
                    return prrc.getResultSize();
                }
            }
            return -1;
        }
        catch (NamingException nex) {
            throw new LDAPException(LDAPErrorType.UNKNOWN, nex);
        }
    }

    private byte[] getPagedResultsResponseControlCookie() {
        try {
            Control[] responseControls = this.conn.getResponseControls();
            if (responseControls != null) {
                for (Control responseControl : responseControls) {
                    if (!(responseControl instanceof PagedResultsResponseControl)) continue;
                    PagedResultsResponseControl prrc = (PagedResultsResponseControl)responseControl;
                    return prrc.getCookie();
                }
            }
            return null;
        }
        catch (NamingException nex) {
            throw new LDAPException(LDAPErrorType.UNKNOWN, nex);
        }
    }

    @Override
    public List<LDAPEntry> getAllEntries() {
        ArrayList<LDAPEntry> allEntries = new ArrayList<LDAPEntry>();
        while (this.hasNext()) {
            LDAPEntry entry = this.next();
            if (entry == null) continue;
            allEntries.add(entry);
        }
        return allEntries;
    }

    @Override
    public int getResultSize() {
        return this.getPagedResultsResponseControlResultSize();
    }

    @Override
    public boolean isLastElement() {
        return this.isLastElement;
    }
}

