/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.ldap.internal.util;

import java.io.IOException;
import org.mule.extension.ldap.internal.model.LDAPSearchControls;
import org.mule.runtime.core.api.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPUtils {
    public static final String NEW_LINE = System.getProperty("line.separator") != null ? System.getProperty("line.separator") : "\n";
    private static final Logger logger = LoggerFactory.getLogger(LDAPUtils.class);

    private LDAPUtils() {
    }

    public static String encodeBase64(byte[] value) {
        try {
            return Base64.encodeBytes((byte[])value, (int)8);
        }
        catch (IOException ex) {
            logger.debug(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static boolean containsDn(LDAPSearchControls controls) {
        if (controls.getAttributesToReturn() == null || controls.getAttributesToReturn().length == 0) {
            return true;
        }
        for (String attribute : controls.getAttributesToReturn()) {
            if (!attribute.equalsIgnoreCase("dn")) continue;
            return true;
        }
        return false;
    }
}

