/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.ldap.internal.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPTrustManager
implements X509TrustManager {
    X509TrustManager defaultTrustManager;
    private static final Logger logger = LoggerFactory.getLogger(LDAPTrustManager.class);

    public LDAPTrustManager(File trustStoreLoc, String trustStorePassword) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory trustMgrFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        try (FileInputStream fis = new FileInputStream(trustStoreLoc);){
            ks.load(fis, trustStorePassword.toCharArray());
        }
        catch (IOException | CertificateException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        trustMgrFactory.init(ks);
        TrustManager[] trustManagers = trustMgrFactory.getTrustManagers();
        for (int i = 0; i < trustManagers.length; ++i) {
            if (!(trustManagers[i] instanceof X509TrustManager)) continue;
            this.defaultTrustManager = (X509TrustManager)trustManagers[i];
            return;
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] xcs, String authType) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] xcs, String authType) throws CertificateException {
        this.defaultTrustManager.checkServerTrusted(xcs, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }
}

