/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.ldap.internal.util;

import javax.naming.NamingEnumeration;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.mule.extension.ldap.internal.connection.LDAPSchemaAware;
import org.mule.extension.ldap.internal.model.LDAPSearchControls;
import org.mule.extension.ldap.internal.util.LDAPResultSet;
import org.mule.extension.ldap.internal.util.PagedLDAPResultSet;
import org.mule.extension.ldap.internal.util.SimpleLDAPResultSet;

public class LDAPResultSetFactory {
    private LDAPResultSetFactory() {
    }

    public static LDAPResultSet create(String baseDn, String filter, Object[] filterArgs, LdapContext conn, LDAPSearchControls controls, NamingEnumeration<SearchResult> entries, LDAPSchemaAware connection) {
        if (controls.isPagingEnabled()) {
            return new PagedLDAPResultSet(baseDn, filter, filterArgs, conn, controls, entries, connection);
        }
        return new SimpleLDAPResultSet(baseDn, controls, entries, connection);
    }

    public static LDAPResultSet create(String baseDn, NamingEnumeration<SearchResult> entries, LDAPSchemaAware connection) {
        return new SimpleLDAPResultSet(baseDn, new LDAPSearchControls(), entries, connection);
    }
}

