/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.ldap.internal.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.BasicControl;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.SortControl;
import javax.naming.ldap.SortKey;
import org.mule.extension.ldap.api.model.SearchScope;
import org.mule.extension.ldap.internal.connection.LDAPSchemaAware;
import org.mule.extension.ldap.internal.error.LDAPErrorType;
import org.mule.extension.ldap.internal.error.exception.LDAPException;
import org.mule.extension.ldap.internal.model.LDAPEntry;
import org.mule.extension.ldap.internal.model.LDAPEntryAttribute;
import org.mule.extension.ldap.internal.model.LDAPEntryAttributeTypeDefinition;
import org.mule.extension.ldap.internal.model.LDAPMultiValueEntryAttribute;
import org.mule.extension.ldap.internal.model.LDAPSearchControls;
import org.mule.extension.ldap.internal.model.LDAPSingleValueEntryAttribute;
import org.mule.extension.ldap.internal.model.LDAPSortKey;
import org.mule.extension.ldap.internal.model.datasense.LDAPEntryObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPJNDIUtils {
    private static final Logger logger = LoggerFactory.getLogger(LDAPJNDIUtils.class);

    private LDAPJNDIUtils() {
    }

    public static LDAPEntry buildEntry(String entryDN, Attributes attributes) {
        return LDAPJNDIUtils.buildEntry(entryDN, attributes, null);
    }

    public static LDAPEntry buildEntry(String entryDN, Attributes attributes, LDAPSchemaAware schemaCache) {
        LDAPEntry anEntry = new LDAPEntry(entryDN);
        if (attributes != null) {
            try {
                NamingEnumeration<? extends Attribute> attrs = attributes.getAll();
                while (attrs.hasMore()) {
                    anEntry.addAttribute(LDAPJNDIUtils.buildAttribute((Attribute)attrs.nextElement(), schemaCache));
                }
            }
            catch (NamingException nex) {
                throw new LDAPException(LDAPErrorType.UNKNOWN, nex);
            }
        }
        return anEntry;
    }

    protected static LDAPEntryAttribute buildAttribute(Attribute attribute, LDAPSchemaAware schemaCache) {
        if (attribute == null) {
            return null;
        }
        LDAPEntryAttributeTypeDefinition typeDefinition = null;
        if (!attribute.getID().startsWith("member;range=")) {
            try {
                typeDefinition = schemaCache != null ? schemaCache.getAttributeTypeDefinition(attribute.getID()) : null;
            }
            catch (Exception e) {
                logger.info("Ignore setting typeDefinition if it throws an exception ", (Throwable)e);
            }
        }
        boolean isMultiValue = typeDefinition != null ? !typeDefinition.isSingleValue() : attribute.size() > 1;
        return LDAPJNDIUtils.buildAttribute(attribute, typeDefinition, isMultiValue);
    }

    private static LDAPEntryAttribute buildAttribute(Attribute attribute, LDAPEntryAttributeTypeDefinition typeDefinition, boolean isMultiValue) {
        try {
            if (isMultiValue) {
                LDAPMultiValueEntryAttribute newAttribute = new LDAPMultiValueEntryAttribute();
                newAttribute.setName(attribute.getID());
                NamingEnumeration<?> values = attribute.getAll();
                while (values.hasMore()) {
                    newAttribute.addValue(values.next());
                }
                newAttribute.setTypeDefinition(typeDefinition);
                return newAttribute;
            }
            LDAPSingleValueEntryAttribute newAttribute = new LDAPSingleValueEntryAttribute();
            newAttribute.setName(attribute.getID());
            newAttribute.setValue(LDAPJNDIUtils.getSingleValue(attribute));
            newAttribute.setTypeDefinition(typeDefinition);
            return newAttribute;
        }
        catch (NamingException nex) {
            throw new LDAPException(LDAPErrorType.UNKNOWN, nex);
        }
    }

    private static Object getSingleValue(Attribute attribute) throws NamingException {
        return attribute.size() != 0 ? attribute.get() : null;
    }

    private static String getSingleValueAsString(Attribute attribute) throws NamingException {
        Object value = LDAPJNDIUtils.getSingleValue(attribute);
        return value != null ? value.toString() : null;
    }

    private static List<String> getMultiValueAsStringList(Attribute attribute) throws NamingException {
        if (attribute != null) {
            ArrayList<String> valuesList = new ArrayList<String>(attribute.size());
            for (int i = 0; i < attribute.size(); ++i) {
                Object value = attribute.get(i);
                if (value == null) continue;
                valuesList.add(value.toString());
            }
            return valuesList;
        }
        return null;
    }

    public static LDAPEntryObjectClassDefinition buildObjectClassDefinition(Attributes attributes) {
        LDAPEntryObjectClassDefinition objectClassDefinition = null;
        if (attributes != null) {
            try {
                objectClassDefinition = new LDAPEntryObjectClassDefinition();
                NamingEnumeration<? extends Attribute> attrs = attributes.getAll();
                while (attrs.hasMore()) {
                    Attribute attr = (Attribute)attrs.nextElement();
                    String attrName = attr.getID();
                    LDAPJNDIUtils.setObjectClassDefinition(objectClassDefinition, attr, attrName);
                }
            }
            catch (NamingException nex) {
                throw new LDAPException(LDAPErrorType.UNKNOWN, nex);
            }
        }
        return objectClassDefinition;
    }

    private static void setObjectClassDefinition(LDAPEntryObjectClassDefinition objectClassDefinition, Attribute attr, String attrName) throws NamingException {
        if (!"MAY".equalsIgnoreCase(attrName) && !"MUST".equalsIgnoreCase(attrName)) {
            String attrValue = LDAPJNDIUtils.getSingleValueAsString(attr);
            if (attrName != null && attrValue != null) {
                objectClassDefinition.set(attrName, attrValue);
            }
        } else {
            List<String> attrValues = LDAPJNDIUtils.getMultiValueAsStringList(attr);
            if (attrValues != null) {
                objectClassDefinition.set(attrName, attrValues);
            }
        }
    }

    public static LDAPEntryAttributeTypeDefinition buildAttributeTypeDefinition(Attributes attributes) {
        LDAPEntryAttributeTypeDefinition typeDefinition = null;
        if (attributes != null) {
            try {
                typeDefinition = new LDAPEntryAttributeTypeDefinition();
                NamingEnumeration<? extends Attribute> attrs = attributes.getAll();
                while (attrs.hasMore()) {
                    Attribute attr = (Attribute)attrs.nextElement();
                    String attrName = attr.getID();
                    String attrValue = LDAPJNDIUtils.getSingleValueAsString(attr);
                    if (attrName == null || attrValue == null) continue;
                    typeDefinition.set(attrName, attrValue);
                }
            }
            catch (NamingException nex) {
                throw new LDAPException(LDAPErrorType.UNKNOWN, nex);
            }
        }
        return typeDefinition;
    }

    public static Control[] buildRequestControls(LDAPSearchControls controls, byte[] cookie) {
        ArrayList<BasicControl> requestControls = new ArrayList<BasicControl>();
        try {
            if (controls.isPagingEnabled()) {
                if (cookie != null) {
                    requestControls.add(new PagedResultsControl(controls.getPageSize(), cookie, true));
                } else {
                    requestControls.add(new PagedResultsControl(controls.getPageSize(), true));
                }
            }
            if (controls.isSortEnabled()) {
                requestControls.add(new SortControl(LDAPJNDIUtils.buildSortKeyArray(controls.getSortKeys()), true));
            }
            return requestControls.toArray(new Control[requestControls.size()]);
        }
        catch (IOException ex) {
            throw new LDAPException("Could not create request paging and/or sort controls", LDAPErrorType.UNKNOWN, ex);
        }
    }

    private static SortKey[] buildSortKeyArray(List<LDAPSortKey> sortKeys) {
        SortKey[] keys = new SortKey[sortKeys.size()];
        int i = 0;
        for (LDAPSortKey key : sortKeys) {
            keys[i++] = new SortKey(key.getAttributeName(), key.isAscending(), key.getMatchingRuleID());
        }
        return keys;
    }

    public static SearchControls buildSearchControls(LDAPSearchControls controls) {
        SearchControls ctrls = new SearchControls();
        ctrls.setCountLimit(controls.getMaxResults());
        ctrls.setReturningAttributes(controls.getAttributesToReturn());
        ctrls.setReturningObjFlag(controls.isReturnObject());
        ctrls.setSearchScope(LDAPJNDIUtils.transformScope(controls.getScope()));
        ctrls.setTimeLimit(controls.getTimeout());
        return ctrls;
    }

    private static int transformScope(SearchScope scope) {
        return scope.getValue();
    }

    public static boolean containsDnValue(String dn, List<Object> values) {
        LdapName normalizedDn = LDAPJNDIUtils.toLdapName(dn);
        if (normalizedDn != null && values != null && !values.isEmpty()) {
            for (Object value : values) {
                if (!(value instanceof String) || !normalizedDn.equals(LDAPJNDIUtils.toLdapName((String)value))) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static LdapName toLdapName(String dn) {
        try {
            return new LdapName(dn);
        }
        catch (InvalidNameException e) {
            logger.warn("Invalid DN.");
            return null;
        }
    }

    public static String escapeMetaCharacters(String inputString) {
        String[] metaCharacters;
        for (String metaCharacter : metaCharacters = new String[]{"+", "<", ">"}) {
            if (inputString == null || !inputString.contains(metaCharacter)) continue;
            inputString = inputString.replace(metaCharacter, "\\" + metaCharacter);
        }
        return inputString;
    }
}

