/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.ldap.internal.service.connection;

import org.mule.extension.ldap.api.parameters.BasicAuthAdvancedParameterGroup;
import org.mule.extension.ldap.api.parameters.BasicAuthAdvancedPoolingParameterGroup;
import org.mule.extension.ldap.internal.connection.ConnectionParameters;
import org.mule.extension.ldap.internal.connection.LDAPConnection;
import org.mule.extension.ldap.internal.connection.parameters.CustomTrustStoreParameterGroup;
import org.mule.extension.ldap.internal.error.exception.util.ExceptionUtils;
import org.mule.extension.ldap.internal.metadata.MetaDataBuilder;
import org.mule.extension.ldap.internal.parameters.bundle.BasicParamsBundle;
import org.mule.extension.ldap.internal.parameters.bundle.LdapConnectionParameters;
import org.mule.extension.ldap.internal.parameters.bundle.SecuredParamsBundle;
import org.mule.runtime.api.connection.ConnectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionService {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionService.class);
    private static final String BASIC = "basic";
    private static final String SSL = "ssl";
    private static final String TLS = "tls";
    private final String securityProtocol;
    private static final int DISABLE_POOLING = 0;
    private static final int NO_POOLING_TIMEOUT = 0;

    public ConnectionService(String securityProtocol) {
        this.securityProtocol = securityProtocol;
    }

    public LDAPConnection connect(LdapConnectionParameters parameters) throws ConnectionException {
        LDAPConnection connection;
        String authentication = parameters.getBasicAuthParams().getAuthentication();
        authentication = authentication == null ? "simple" : authentication;
        try {
            ConnectionParameters.ConnectionParametersBuilder connectionParametersBuilder;
            if (this.securityProtocol.equals(BASIC)) {
                BasicAuthAdvancedPoolingParameterGroup basicAuthAdvancedPoolingParams = ((BasicParamsBundle)parameters).getBasicAuthAdvancedPoolingParams();
                connectionParametersBuilder = new ConnectionParameters.ConnectionParametersBuilder(basicAuthAdvancedPoolingParams.getType().toString(), parameters.getBasicAuthParams().getUrl(), authentication).setInitialPoolSize(basicAuthAdvancedPoolingParams.getInitialPoolSize()).setMaxPoolSize(basicAuthAdvancedPoolingParams.getMaxPoolSize()).setPoolTimeout(basicAuthAdvancedPoolingParams.getPoolTimeout()).setReferral(basicAuthAdvancedPoolingParams.getReferral().toString()).setExtendedConf(basicAuthAdvancedPoolingParams.getExtendedConfiguration()).setSchemaEnabled(basicAuthAdvancedPoolingParams.isSchemaEnabled());
            } else {
                BasicAuthAdvancedParameterGroup basicAuthAdvancedParams = ((SecuredParamsBundle)parameters).getBasicAuthAdvancedParams();
                CustomTrustStoreParameterGroup customTrustStoreParameterGroup = ((SecuredParamsBundle)parameters).getCustomTrustStoreParameterGroup();
                connectionParametersBuilder = new ConnectionParameters.ConnectionParametersBuilder(basicAuthAdvancedParams.getType().toString(), parameters.getBasicAuthParams().getUrl(), authentication).setInitialPoolSize(0).setMaxPoolSize(0).setPoolTimeout(0L).setReferral(basicAuthAdvancedParams.getReferral().toString()).setExtendedConf(basicAuthAdvancedParams.getExtendedConfiguration()).setSchemaEnabled(basicAuthAdvancedParams.isSchemaEnabled()).setTrustStorePath(customTrustStoreParameterGroup.getTrustStorePath()).setTrustStorePassword(customTrustStoreParameterGroup.getTrustStorePassword());
                if (this.securityProtocol.equals(SSL)) {
                    connectionParametersBuilder.setSslEnabled(true);
                } else if (this.securityProtocol.equals(TLS)) {
                    connectionParametersBuilder.setTlsEnabled(true);
                }
            }
            connection = LDAPConnection.getConnection(connectionParametersBuilder.build());
            if ("none".equals(authentication)) {
                connection.bind(null, null);
            } else {
                connection.bind(parameters.getBasicAuthParams().getAuthDn(), parameters.getBasicAuthParams().getAuthPassword());
            }
            connection.setAuthentication(authentication);
            connection.setMetaDataBuilder(new MetaDataBuilder(connection));
        }
        catch (Exception ex) {
            logger.error("Exception occurred in establishing connection.", (Throwable)ex);
            throw ExceptionUtils.toConnectionException(ex);
        }
        return connection;
    }
}

