/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.ldap.internal.service;

import java.util.Map;
import java.util.Optional;
import org.mule.connectors.commons.template.config.ConnectorConfig;
import org.mule.connectors.commons.template.connection.ConnectorConnection;
import org.mule.connectors.commons.template.service.DefaultConnectorService;
import org.mule.extension.ldap.internal.config.LDAPConfiguration;
import org.mule.extension.ldap.internal.connection.LDAPConnection;
import org.mule.extension.ldap.internal.model.LDAPEntry;
import org.mule.extension.ldap.internal.service.ConnectionOperationsService;
import org.mule.extension.ldap.internal.service.LDIFConversionServiceImpl;
import org.mule.extension.ldap.internal.util.ActiveDirectoryUUIDByteParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionOperationsServiceImpl
extends DefaultConnectorService<LDAPConfiguration, LDAPConnection>
implements ConnectionOperationsService {
    private static final Logger logger = LoggerFactory.getLogger(LDIFConversionServiceImpl.class);
    private static final String OBJECT_GUID = "objectGUID";
    private static final String OBJECT_SID = "objectSid";

    public ConnectionOperationsServiceImpl(LDAPConfiguration config, LDAPConnection ldapConnection) {
        super((ConnectorConfig)config, (ConnectorConnection)ldapConnection);
    }

    @Override
    public Map<String, Object> bind(String authDn, String authPassword, String authentication) {
        try {
            if (authDn == null) {
                ((LDAPConnection)this.getConnection()).rebind();
            } else {
                ((LDAPConnection)this.getConnection()).setAuthentication(authentication);
                ((LDAPConnection)this.getConnection()).bind(authDn, authPassword);
            }
            String dn = ((LDAPConnection)this.getConnection()).getBindedUserDn();
            logger.info("Bind was successful for user: {} ", (Object)(dn != null ? dn : "Anonymous"));
            if (dn != null) {
                logger.debug("About to retrieve authenticated user entry for: {}", (Object)dn);
                LDAPEntry entry = ((LDAPConnection)this.getConnection()).lookup(dn);
                Optional.ofNullable(entry.getAttribute(OBJECT_SID)).ifPresent(ldapEntryAttribute -> entry.addAttribute(OBJECT_SID, ActiveDirectoryUUIDByteParser.parseSID((byte[])ldapEntryAttribute.getValue())));
                Optional.ofNullable(entry.getAttribute(OBJECT_GUID)).ifPresent(ldapEntryAttribute -> entry.addAttribute(OBJECT_GUID, ActiveDirectoryUUIDByteParser.parseGUID((byte[])ldapEntryAttribute.getValue())));
                logger.debug("Retrieved entry: {}", (Object)entry);
                return entry.toMap();
            }
            logger.debug("Anonymous user returns no entry (null)");
        }
        catch (Exception e) {
            logger.warn("Error while executing bind operation : {}", (Object)e.getMessage());
            throw e;
        }
        return null;
    }

    @Override
    public void unbind() {
        try {
            ((LDAPConnection)this.getConnection()).disconnect();
        }
        catch (Exception e) {
            logger.warn("Error while executing unbind operation : {}", (Object)e.getMessage());
            throw e;
        }
    }
}

