/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.ldap.internal.operation;

import java.util.List;
import org.mule.extension.ldap.api.model.SearchScope;

public class SearchOperationParameters {
    private final String baseDn;
    private final String filter;
    private final List<String> attributes;
    private final SearchScope scope;
    private final int timeout;
    private final long maxResults;
    private final boolean returnObject;
    private final int pageSize;
    private final String structuralObjectClass;
    private final boolean showAttributesAsObjects;

    public SearchOperationParameters(String baseDn, String filter, List<String> attributes, SearchScope scope, int timeout, long maxResults, boolean returnObject, int pageSize, String structuralObjectClass) {
        this.structuralObjectClass = structuralObjectClass;
        this.baseDn = baseDn;
        this.filter = filter;
        this.attributes = attributes;
        this.scope = scope;
        this.timeout = timeout;
        this.maxResults = maxResults;
        this.returnObject = returnObject;
        this.pageSize = pageSize;
        this.showAttributesAsObjects = false;
    }

    private SearchOperationParameters(SearchOperationsParametersBuilder builder) {
        this.structuralObjectClass = builder.structuralObjectClass;
        this.baseDn = builder.baseDn;
        this.filter = builder.filter;
        this.attributes = builder.attributes;
        this.scope = builder.scope;
        this.timeout = builder.timeout;
        this.maxResults = builder.maxResults;
        this.returnObject = builder.returnObject;
        this.pageSize = builder.pageSize;
        this.showAttributesAsObjects = builder.returnAttributes;
    }

    public String getBaseDn() {
        return this.baseDn;
    }

    public String getFilter() {
        return this.filter;
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    public SearchScope getScope() {
        return this.scope;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public long getMaxResults() {
        return this.maxResults;
    }

    public boolean isReturnObject() {
        return this.returnObject;
    }

    public boolean isShowAttributesAsObjects() {
        return this.showAttributesAsObjects;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public String getStructuralObjectClass() {
        return this.structuralObjectClass;
    }

    public static class SearchOperationsParametersBuilder {
        private final String baseDn;
        private final String filter;
        private final List<String> attributes;
        private final SearchScope scope;
        private int timeout;
        private long maxResults;
        private boolean returnObject;
        private int pageSize;
        private String structuralObjectClass;
        private boolean returnAttributes = false;

        public SearchOperationsParametersBuilder(String baseDn, String filter, List<String> attributes, SearchScope scope, boolean returnAttributes) {
            this.baseDn = baseDn;
            this.filter = filter;
            this.attributes = attributes;
            this.scope = scope;
            this.returnAttributes = returnAttributes;
        }

        public SearchOperationsParametersBuilder setTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public SearchOperationsParametersBuilder setMaxResults(long maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public SearchOperationsParametersBuilder setReturnObject(boolean returnObject) {
            this.returnObject = returnObject;
            return this;
        }

        public SearchOperationsParametersBuilder setPageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public SearchOperationsParametersBuilder setStructuralObjectClass(String structuralObjectClass) {
            this.structuralObjectClass = structuralObjectClass;
            return this;
        }

        public SearchOperationsParametersBuilder setReturnAttributes(boolean returnAttributes) {
            this.returnAttributes = returnAttributes;
            return this;
        }

        public SearchOperationParameters build() {
            return new SearchOperationParameters(this);
        }
    }
}

